/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.mixin;

import aqario.fowlplay.common.entity.ChickenVariant;
import aqario.fowlplay.common.util.ChickenAnimationStates;
import aqario.fowlplay.core.FowlPlayRegistries;
import aqario.fowlplay.core.FowlPlayRegistryKeys;
import aqario.fowlplay.core.FowlPlayTrackedDataHandlerRegistry;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Chicken.class})
public abstract class ChickenEntityMixin
extends Animal
implements VariantHolder<Holder<ChickenVariant>>,
ChickenAnimationStates {
    @Unique
    private static final EntityDataAccessor<Holder<ChickenVariant>> fowlplay$VARIANT = SynchedEntityData.defineId(Chicken.class, FowlPlayTrackedDataHandlerRegistry.CHICKEN_VARIANT);
    @Unique
    private final AnimationState fowlplay$standingState = new AnimationState();
    @Unique
    private final AnimationState fowlplay$flappingState = new AnimationState();
    @Unique
    private final AnimationState fowlplay$floatingState = new AnimationState();

    protected ChickenEntityMixin(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        switch (spawnReason) {
            case BREEDING: {
                FowlPlayRegistries.CHICKEN_VARIANT.getHolder(ChickenVariant.WHITE).ifPresent(this::setVariant);
                break;
            }
            case CHUNK_GENERATION: {
                FowlPlayRegistries.CHICKEN_VARIANT.getHolder(ChickenVariant.RED_JUNGLEFOWL).ifPresent(this::setVariant);
                break;
            }
            default: {
                FowlPlayRegistries.CHICKEN_VARIANT.getRandom(world.getRandom()).ifPresent(this::setVariant);
            }
        }
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public Holder<ChickenVariant> getVariant() {
        return (Holder)this.entityData.get(fowlplay$VARIANT);
    }

    public void setVariant(Holder<ChickenVariant> variant) {
        this.entityData.set(fowlplay$VARIANT, variant);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(fowlplay$VARIANT, (Object)FowlPlayRegistries.CHICKEN_VARIANT.getHolderOrThrow(ChickenVariant.WHITE));
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void fowlplay$readCustomVariant(CompoundTag nbt, CallbackInfo ci) {
        Optional.ofNullable(ResourceLocation.tryParse((String)nbt.getString("variant"))).map(variant -> ResourceKey.create(FowlPlayRegistryKeys.CHICKEN_VARIANT, (ResourceLocation)variant)).flatMap(arg_0 -> FowlPlayRegistries.CHICKEN_VARIANT.getHolder(arg_0)).ifPresent(this::setVariant);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void fowlplay$writeCustomVariant(CompoundTag nbt, CallbackInfo ci) {
        nbt.putString("variant", this.getVariant().unwrapKey().orElse(ChickenVariant.WHITE).location().toString());
    }

    public void tick() {
        if (this.level().isClientSide()) {
            this.fowlplay$standingState.animateWhen(this.onGround() && !this.isInWaterOrBubble(), this.tickCount);
            this.fowlplay$flappingState.animateWhen(!this.onGround() && !this.isInWaterOrBubble(), this.tickCount);
            this.fowlplay$floatingState.animateWhen(this.isInWaterOrBubble(), this.tickCount);
        }
        super.tick();
    }

    @Override
    public AnimationState fowlplay$getStandingState() {
        return this.fowlplay$standingState;
    }

    @Override
    public AnimationState fowlplay$getFlappingState() {
        return this.fowlplay$flappingState;
    }

    @Override
    public AnimationState fowlplay$getFloatingState() {
        return this.fowlplay$floatingState;
    }
}

