/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CompositeBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CustomBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.FlightBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.LeaderlessFlocking;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetEntityLookTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetPerchWalkTarget;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayMemoryTypes;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetAttackTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class CrowEntity
extends TrustingBirdEntity
implements BirdBrain<CrowEntity> {
    public CrowEntity(class_1299<? extends CrowEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 0.55f;
    }

    public static class_5132.class_5133 createCrowAttributes() {
        return FlyingBirdEntity.createFlyingBirdAttributes().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23719, (double)0.225f).method_26868(class_5134.field_23720, (double)0.22f);
    }

    @Override
    public int getMaxYawChange() {
        return 18;
    }

    @Override
    public Pair<Integer, Integer> getFlyHeightRange() {
        return Pair.of((Object)12, (Object)16);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
    }

    public boolean method_6109() {
        return false;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    @Override
    public class_1856 getFood() {
        return class_1856.method_8106(FowlPlayItemTags.CROW_FOOD);
    }

    @Override
    public boolean shouldAttack(class_1309 target) {
        if (this.hasLowHealth()) {
            return false;
        }
        class_1309 hurtBy = BrainUtils.getLastAttacker((class_1309)this);
        if (!(target.method_5864().method_20210(FowlPlayEntityTypeTags.CROW_ATTACK_TARGETS) || hurtBy != null && hurtBy.equals((Object)target))) {
            return false;
        }
        Optional<List> nearbyAdults = Optional.ofNullable((List)BrainUtils.getMemory((class_1309)this, FowlPlayMemoryTypes.NEAREST_VISIBLE_ADULTS.get()));
        return nearbyAdults.filter(passiveEntities -> passiveEntities.size() >= 4).isPresent();
    }

    @Override
    public boolean shouldAvoid(class_1309 entity) {
        return entity.method_5864().method_20210(FowlPlayEntityTypeTags.CROW_AVOIDS);
    }

    @Override
    public void updateAnimations() {
        this.standingState.method_45317(!this.isFlying() && !this.method_5816(), this.field_6012);
        this.flappingState.method_45317(this.isFlying(), this.field_6012);
        this.swimmingState.method_45317(!this.isFlying() && this.method_5816(), this.field_6012);
    }

    @Override
    public float getFlapVolume() {
        return 0.65f;
    }

    @Override
    public float getFlapPitch() {
        return 0.9f;
    }

    @Override
    public float getWaterline() {
        return 0.5f;
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.5f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    @Override
    @Nullable
    protected class_3414 getCallSound() {
        return FowlPlaySoundEvents.ENTITY_CROW_CALL.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().crowCallVolume;
    }

    @Override
    public int getCallDelay() {
        return 600;
    }

    @Override
    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return FowlPlaySoundEvents.ENTITY_CROW_HURT.get();
    }

    protected class_4095.class_5303<CrowEntity> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    public List<? extends ExtendedSensor<? extends CrowEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor(), new AvoidTargetSensor(), new AttackTargetSensor()});
    }

    public BrainActivityGroup<? extends CrowEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new class_4097[]{new FloatToSurfaceOfFluid().riseChance(0.5f), FlightBehaviours.stopFalling(), new SetAttackTarget(), SetEntityLookTarget.create(Birds::isPlayerHoldingFood), new LookAtTarget().runFor(entity -> entity.method_6051().method_39332(45, 90)), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends CrowEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new class_4097[]{CustomBehaviours.setAvoidEntityWalkTarget()});
    }

    public BrainActivityGroup<? extends CrowEntity> getFightTasks() {
        return BirdBrain.fightActivity(new class_4097[]{new InvalidateAttackTarget(), FlightBehaviours.startFlying(), new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack(0)});
    }

    @Override
    public BrainActivityGroup<? extends CrowEntity> getForageTasks() {
        return BirdBrain.forageActivity(new class_4097[]{new OneRandomBehaviour(new ExtendedBehaviour[]{CompositeBehaviours.tryForage(), CompositeBehaviours.tryPerch()})});
    }

    @Override
    public BrainActivityGroup<? extends CrowEntity> getPerchTasks() {
        return BirdBrain.perchActivity(new class_4097[]{new LeaderlessFlocking(3, 0.03f, 0.6f, 0.05f, 3.0f), CompositeBehaviours.tryPerch()});
    }

    @Override
    public BrainActivityGroup<? extends CrowEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new class_4097[]{CompositeBehaviours.tryPickUpFood()});
    }

    @Override
    public BrainActivityGroup<? extends CrowEntity> getRestTasks() {
        return BirdBrain.restActivity(new class_4097[]{new SetPerchWalkTarget().startCondition(Predicate.not(Birds::isPerched)), CustomBehaviours.idleIfPerched()});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.FORAGER.get();
    }

    protected void method_5958() {
        class_4095 brain = this.method_18868();
        class_4168 activity = brain.method_24538().orElse(null);
        this.tickBrain((class_1309)this);
        if (activity == class_4168.field_22396 && brain.method_24538().orElse(null) != class_4168.field_22396) {
            brain.method_24525(class_4140.field_30246, (Object)true, 2400L);
        }
        super.method_5958();
    }
}

