/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_270;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3321;
import net.minecraft.class_6025;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class TameableBirdEntity
extends TrustingBirdEntity
implements class_6025 {
    protected static final class_2940<Byte> TAMEABLE_FLAGS = class_2945.method_12791(TameableBirdEntity.class, (class_2941)class_2943.field_13319);
    protected static final class_2940<Optional<UUID>> OWNER = class_2945.method_12791(TameableBirdEntity.class, (class_2941)class_2943.field_13313);
    private boolean sitting;

    protected TameableBirdEntity(class_1299<? extends BirdEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TAMEABLE_FLAGS, (Object)0);
        this.field_6011.method_12784(OWNER, Optional.empty());
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.method_6139() != null) {
            nbt.method_25927("owner", this.method_6139());
        }
        nbt.method_10556("sitting", this.sitting);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        UUID uuid;
        super.method_5749(nbt);
        if (nbt.method_25928("owner")) {
            uuid = nbt.method_25926("owner");
        } else {
            String string = nbt.method_10558("owner");
            uuid = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)string);
        }
        if (uuid != null) {
            try {
                this.setOwnerUuid(uuid);
                this.setTamed(true);
            }
            catch (Throwable throwable) {
                this.setTamed(false);
            }
        }
        this.sitting = nbt.method_10577("sitting");
        this.setInSittingPose(this.sitting);
    }

    protected void showEmoteParticle(boolean positive) {
        class_2400 particleEffect = class_2398.field_11201;
        if (!positive) {
            particleEffect = class_2398.field_11251;
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)particleEffect, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
        }
    }

    @Override
    public void method_5711(byte status) {
        if (status == 7) {
            this.showEmoteParticle(true);
        } else if (status == 6) {
            this.showEmoteParticle(false);
        } else {
            super.method_5711(status);
        }
    }

    public boolean isTamed() {
        return ((Byte)this.field_6011.method_12789(TAMEABLE_FLAGS) & 4) != 0;
    }

    public void setTamed(boolean tamed) {
        byte b = (Byte)this.field_6011.method_12789(TAMEABLE_FLAGS);
        if (tamed) {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (Object)((byte)(b | 4)));
        } else {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (Object)((byte)(b & 0xFFFFFFFB)));
        }
        this.onTamedChanged();
    }

    protected void onTamedChanged() {
    }

    public boolean isInSittingPose() {
        return ((Byte)this.field_6011.method_12789(TAMEABLE_FLAGS) & 1) != 0;
    }

    public void setInSittingPose(boolean inSittingPose) {
        byte b = (Byte)this.field_6011.method_12789(TAMEABLE_FLAGS);
        if (inSittingPose) {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (Object)((byte)(b | 1)));
        } else {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (Object)((byte)(b & 0xFFFFFFFE)));
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.method_37908().field_9236 && !this.method_5679(source)) {
            this.setSitting(false);
        }
        return super.method_5643(source, amount);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_6139() != null) {
            this.addTrustedUuid(this.method_6139());
            if (!this.method_5947()) {
                this.method_5971();
            }
        }
        if (this.isFlying()) {
            this.setSitting(false);
        }
        if (!this.method_37908().field_9236) {
            if (this.isSitting()) {
                this.method_5942().method_6340();
                this.setInSittingPose(true);
            } else {
                this.setInSittingPose(false);
            }
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        return this.trusts(player) ? super.method_5992(player, hand) : class_1269.field_5811;
    }

    @Nullable
    public UUID method_6139() {
        return ((Optional)this.field_6011.method_12789(OWNER)).orElse(null);
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER, Optional.ofNullable(uuid));
    }

    public void setOwner(class_1657 player) {
        this.setTamed(true);
        this.setOwnerUuid(player.method_5667());
        if (player instanceof class_3222) {
            class_174.field_1201.method_9132((class_3222)player, (class_1429)this);
        }
    }

    @Nullable
    public class_1309 method_35057() {
        try {
            UUID uuid = this.method_6139();
            return uuid == null ? null : this.method_37908().method_18470(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Override
    public boolean method_18395(class_1309 target) {
        return !this.isOwner(target) && super.method_18395(target);
    }

    public boolean isOwner(class_1309 entity) {
        return entity == this.method_35057();
    }

    public class_270 method_5781() {
        class_1309 livingEntity;
        if (this.isTamed() && (livingEntity = this.method_35057()) != null) {
            return livingEntity.method_5781();
        }
        return super.method_5781();
    }

    public boolean method_5722(class_1297 other) {
        if (this.isTamed()) {
            class_1309 livingEntity = this.method_35057();
            if (other == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.method_5722(other);
            }
        }
        return super.method_5722(other);
    }

    public void method_6078(class_1282 source) {
        if (!this.method_37908().field_9236 && this.method_37908().method_8450().method_8355(class_1928.field_19398) && this.method_35057() instanceof class_3222) {
            this.method_35057().method_43496(this.method_6066().method_5548());
        }
        super.method_6078(source);
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public void setSitting(boolean sitting) {
        this.sitting = sitting;
    }

    public class_1937 method_37908() {
        return super.method_37908();
    }
}

