/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.util;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.common.util.TargetingUtil;
import aqario.fowlplay.core.FowlPlayMemoryTypes;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_6019;
import net.minecraft.class_6670;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;

public final class Birds {
    public static final float FAST_SPEED = 1.4f;
    public static final float FLY_SPEED = 2.0f;
    public static final float SWIM_SPEED = 4.0f;
    public static final int ITEM_PICK_UP_RANGE = 32;
    public static final CylindricalRadius FLY_AVOID_RANGE = new CylindricalRadius(8, 6);
    public static final int AVOID_TICKS = 160;
    public static final int CANNOT_PICKUP_FOOD_TICKS = 1200;
    public static final class_6019 STAY_NEAR_ENTITY_RANGE = class_6019.method_35017((int)16, (int)32);

    public static boolean isDaytime(BirdEntity entity) {
        class_1937 world = entity.method_37908();
        return !world.method_8597().method_29960() && (world.method_8532() < 12500L || world.method_8532() > 23000L);
    }

    public static boolean shouldLandAtDestination(FlyingBirdEntity bird, class_2338 destination) {
        class_1937 world = bird.method_37908();
        return !world.method_8320(destination).method_26215() || !world.method_8320(destination.method_10074()).method_26215() || !world.method_8316(destination).method_15769() || !world.method_8316(destination.method_10074()).method_15769();
    }

    public static void tryFlyingAlongPath(FlyingBirdEntity bird, class_11 path) {
        if (bird.canStartFlying() && (Birds.shouldFlyToDestination(bird, path, path.method_48().method_46558()) && (!bird.method_5864().method_20210(FowlPlayEntityTypeTags.WATERBIRDS) || !bird.method_5816()) || Birds.shouldFlyFromAvoidTarget(bird))) {
            bird.startFlying();
        }
    }

    public static boolean shouldFlyToDestination(FlyingBirdEntity bird, class_11 path, class_243 target) {
        if (!path.method_21655()) {
            return true;
        }
        class_243 pos = bird.method_19538();
        double dx = target.field_1352 - pos.field_1352;
        double dy = target.field_1351 - pos.field_1351;
        double dz = target.field_1350 - pos.field_1350;
        double dxz2 = dx * dx + dz * dz;
        double dy2 = dy * dy;
        double xzRadius = bird.getWalkRange().horizontal();
        double yRadius = bird.getWalkRange().vertical();
        return dxz2 > xzRadius * xzRadius || dy2 > yRadius * yRadius;
    }

    public static boolean shouldFlyFromAvoidTarget(FlyingBirdEntity bird) {
        class_4095 brain = bird.method_18868();
        if (!BrainUtils.hasMemory((class_4095)brain, (class_4140)class_4140.field_22357) || !BrainUtils.hasMemory((class_4095)brain, FowlPlayMemoryTypes.IS_AVOIDING.get())) {
            return false;
        }
        class_1309 target = (class_1309)BrainUtils.getMemory((class_4095)brain, (class_4140)class_4140.field_22357);
        if (target.method_5624() && !target.method_7325() || target.method_5765()) {
            return true;
        }
        class_243 pos = bird.method_19538();
        class_243 targetPos = target.method_19538();
        double dx = targetPos.field_1352 - pos.field_1352;
        double dy = targetPos.field_1351 - pos.field_1351;
        double dz = targetPos.field_1350 - pos.field_1350;
        double dxz2 = dx * dx + dz * dz;
        double dy2 = dy * dy;
        double xzRadius = FLY_AVOID_RANGE.horizontal();
        double yRadius = FLY_AVOID_RANGE.vertical();
        return dxz2 <= xzRadius * xzRadius && dy2 <= yRadius * yRadius;
    }

    public static boolean isNotFlightless(class_1297 entity) {
        return entity.method_5864().method_20210(FowlPlayEntityTypeTags.BIRDS) && !entity.method_5864().method_20210(FowlPlayEntityTypeTags.FLIGHTLESS);
    }

    public static <T extends BirdEntity> void alertOthers(T bird, class_1309 attacker) {
        Birds.getNearbyVisibleAdults(bird).forEach(other -> {
            class_4095 brain = other.method_18868();
            if (attacker instanceof class_1657) {
                BrainUtils.setForgettableMemory((class_4095)brain, FowlPlayMemoryTypes.CANNOT_PICKUP_FOOD.get(), (Object)true, (int)1200);
            }
            BrainUtils.clearMemory((class_4095)brain, (class_4140)class_4140.field_19293);
            BrainUtils.setForgettableMemory((class_4095)brain, (class_4140)class_4140.field_22357, (Object)attacker, (int)160);
        });
    }

    public static <T extends BirdEntity> List<? extends class_1296> getNearbyVisibleAdults(T bird) {
        return Optional.ofNullable((List)BrainUtils.getMemory(bird, FowlPlayMemoryTypes.NEAREST_VISIBLE_ADULTS.get())).orElse((List)ImmutableList.of());
    }

    public static boolean isPlayerHoldingFood(BirdEntity bird, class_1309 target) {
        return target.method_5864() == class_1299.field_6097 && target.method_24520((Predicate)bird.getFood());
    }

    public static boolean canPickupFood(BirdEntity bird) {
        class_4095 brain = bird.method_18868();
        if (BrainUtils.hasMemory((class_4095)brain, FowlPlayMemoryTypes.CANNOT_PICKUP_FOOD.get())) {
            return false;
        }
        if (!BrainUtils.hasMemory((class_4095)brain, (class_4140)((class_4140)SBLMemoryTypes.NEARBY_ITEMS.get()))) {
            return false;
        }
        List foodItems = (List)BrainUtils.getMemory((class_4095)brain, (class_4140)((class_4140)SBLMemoryTypes.NEARBY_ITEMS.get()));
        if (foodItems.isEmpty() || bird.getFood().method_8093(bird.method_6047())) {
            return false;
        }
        class_6670 visibleMobs = (class_6670)BrainUtils.getMemory((class_4095)brain, (class_4140)class_4140.field_18442);
        if (visibleMobs == null) {
            return true;
        }
        List<class_1309> avoidTargets = visibleMobs.method_38980(entity -> true).filter(entity -> Birds.shouldAvoid(bird, entity)).filter(entity -> entity.method_24516((class_1297)foodItems.get(0), (double)bird.getFleeRange((class_1309)entity))).toList();
        return avoidTargets.isEmpty();
    }

    public static boolean shouldAvoid(BirdEntity bird, class_1309 target) {
        class_1309 attackTarget;
        class_4095 brain = bird.method_18868();
        if (!(bird.shouldAvoid(target) && class_1301.field_6156.test(target) || Birds.wasHurtBy(bird, target))) {
            return false;
        }
        if (target instanceof class_1657) {
            TrustingBirdEntity trusting;
            class_1657 player = (class_1657)target;
            if (bird instanceof TrustingBirdEntity && (trusting = (TrustingBirdEntity)bird).trusts(player)) {
                return false;
            }
        }
        if ((attackTarget = (class_1309)BrainUtils.getMemory((class_4095)brain, (class_4140)class_4140.field_22355)) != null && attackTarget.equals((Object)target)) {
            return false;
        }
        return !bird.shouldAttack(target);
    }

    public static boolean wasHurtBy(BirdEntity bird, class_1309 entity) {
        class_1309 hurtBy = (class_1309)BrainUtils.getMemory((class_1309)bird, (class_4140)class_4140.field_18452);
        return hurtBy != null && hurtBy.equals((Object)entity);
    }

    public static boolean isPerched(BirdEntity entity) {
        FlyingBirdEntity bird;
        return (!(entity instanceof FlyingBirdEntity) || !(bird = (FlyingBirdEntity)entity).isFlying()) && TargetingUtil.isPerch((class_1314)entity, entity.method_23314());
    }
}

