/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.Flocking;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CompositeBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CustomBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.FlightBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.LeaderlessFlocking;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetEntityLookTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetPerchWalkTarget;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.util.AnimationStateList;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_7094;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import org.jetbrains.annotations.Nullable;

public class SparrowEntity
extends FlyingBirdEntity
implements BirdBrain<SparrowEntity>,
Flocking {
    public final class_7094 scratchingState = new class_7094();
    public final class_7094 preeningState = new class_7094();
    private static final int FLAP_FREQUENCY = 1;
    private static final int FLAP_DURATION = 8;
    private int timeSinceLastFlap = 1;
    private int flapTime = 0;

    public SparrowEntity(class_1299<? extends SparrowEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public boolean method_6109() {
        return false;
    }

    @Override
    public class_1856 getFood() {
        return class_1856.method_8106(FowlPlayItemTags.SPARROW_FOOD);
    }

    @Override
    public boolean shouldAvoid(class_1309 entity) {
        return entity.method_5864().method_20210(FowlPlayEntityTypeTags.SPARROW_AVOIDS);
    }

    @Override
    public void method_5773() {
        super.method_5773();
    }

    @Override
    protected AnimationStateList createIdleAnimations() {
        return new AnimationStateList().with(this.scratchingState, 1).with(this.preeningState, 3);
    }

    @Override
    protected void updateAnimations() {
        if (!this.isFlying() && !this.method_5816()) {
            if (this.field_5974.method_43048(1000) < this.idleAnimationChance++ && !this.isMoving()) {
                this.resetIdleAnimationDelay();
                this.standingState.method_41325();
                this.preeningState.method_41325();
                this.scratchingState.method_41325();
                if (this.method_59922().method_43057() < 0.75f) {
                    this.preeningState.method_41322(this.field_6012);
                } else {
                    this.scratchingState.method_41322(this.field_6012);
                }
            } else if (this.isMoving()) {
                this.preeningState.method_41325();
                this.scratchingState.method_41325();
            }
            if (!this.preeningState.method_41327() && !this.scratchingState.method_41327()) {
                this.standingState.method_41324(this.field_6012);
            } else {
                this.standingState.method_41325();
            }
        } else {
            this.standingState.method_41325();
            this.preeningState.method_41325();
            this.scratchingState.method_41325();
        }
        if (this.isFlying()) {
            if (this.timeSinceLastFlap >= 1) {
                this.timeSinceLastFlap = 0;
                ++this.flapTime;
            } else if (this.isAnimatingFlapping()) {
                ++this.flapTime;
                this.glidingState.method_41325();
                this.flappingState.method_41324(this.field_6012);
            } else {
                ++this.timeSinceLastFlap;
                this.flapTime = 0;
                this.flappingState.method_41325();
                this.glidingState.method_41324(this.field_6012);
            }
        } else {
            this.timeSinceLastFlap = 1;
            this.flapTime = 0;
            this.flappingState.method_41325();
            this.glidingState.method_41325();
        }
        this.swimmingState.method_45317(!this.isFlying() && this.method_5816(), this.field_6012);
    }

    private boolean isAnimatingFlapping() {
        return this.flapTime >= 0 && this.flapTime < 8;
    }

    @Override
    protected boolean method_5776() {
        return this.isFlying() && this.isAnimatingFlapping();
    }

    @Override
    protected int getIdleAnimationDelay() {
        return 400;
    }

    @Override
    public float getFlapVolume() {
        return 0.5f;
    }

    @Override
    public float getFlapPitch() {
        return 1.0f;
    }

    @Override
    public float getWaterline() {
        return 0.45f;
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.5f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    @Override
    @Nullable
    protected class_3414 getCallSound() {
        return FowlPlaySoundEvents.ENTITY_SPARROW_CALL.get();
    }

    @Override
    @Nullable
    protected class_3414 getSongSound() {
        return FowlPlaySoundEvents.ENTITY_SPARROW_SONG.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().sparrowCallVolume;
    }

    @Override
    protected float getSongVolume() {
        return FowlPlayConfig.getInstance().sparrowSongVolume;
    }

    @Override
    public int getCallDelay() {
        return 120;
    }

    @Override
    public int getSongDelay() {
        return 360;
    }

    @Override
    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return FowlPlaySoundEvents.ENTITY_SPARROW_HURT.get();
    }

    protected class_4095.class_5303<SparrowEntity> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    public List<? extends ExtendedSensor<? extends SparrowEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor(), new AvoidTargetSensor()});
    }

    public BrainActivityGroup<? extends SparrowEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new class_4097[]{new FloatToSurfaceOfFluid(), FlightBehaviours.stopFalling(), SetEntityLookTarget.create(Birds::isPlayerHoldingFood), new LookAtTarget().runForBetween(45, 90), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends SparrowEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new class_4097[]{CustomBehaviours.setAvoidEntityWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends SparrowEntity> getForageTasks() {
        return BirdBrain.forageActivity(new class_4097[]{new OneRandomBehaviour(new ExtendedBehaviour[]{CompositeBehaviours.tryForage(), CompositeBehaviours.tryPerch()})});
    }

    @Override
    public BrainActivityGroup<? extends SparrowEntity> getPerchTasks() {
        return BirdBrain.perchActivity(new class_4097[]{new LeaderlessFlocking(3, 0.03f, 0.6f, 0.05f, 3.0f), CompositeBehaviours.tryPerch()});
    }

    @Override
    public BrainActivityGroup<? extends SparrowEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new class_4097[]{CompositeBehaviours.tryPickUpFood()});
    }

    @Override
    public BrainActivityGroup<? extends SparrowEntity> getRestTasks() {
        return BirdBrain.restActivity(new class_4097[]{new SetPerchWalkTarget().startCondition(Predicate.not(Birds::isPerched)), CustomBehaviours.idleIfPerched()});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.FORAGER.get();
    }

    protected void method_5958() {
        this.tickBrain((class_1309)this);
        super.method_5958();
    }

    @Override
    public boolean isLeader() {
        return false;
    }

    @Override
    public void setLeader() {
    }
}

