/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.core.FowlPlayActivities;
import aqario.fowlplay.core.FowlPlayMemoryTypes;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;

public interface BirdBrain<E extends BirdEntity>
extends SmartBrainOwner<E> {
    default public BrainActivityGroup<? extends E> getAvoidTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends E> getDeliverTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends E> getForageTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends E> getPerchTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends E> getPickupFoodTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends E> getRestTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends E> getSoarTasks() {
        return BrainActivityGroup.empty();
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> coreActivity(class_4097<? super T> ... behaviours) {
        return new BrainActivityGroup(class_4168.field_18594).priority(0).behaviours(behaviours);
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> avoidActivity(class_4097<? super T> ... behaviours) {
        return new BrainActivityGroup(class_4168.field_22399).priority(10).behaviours(behaviours).requireAndWipeMemoriesOnUse(new class_4140[]{FowlPlayMemoryTypes.IS_AVOIDING.get()});
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> deliverActivity(class_4097<? super T> ... behaviours) {
        return new BrainActivityGroup(FowlPlayActivities.DELIVER.get()).priority(10).behaviours(behaviours).requireAndWipeMemoriesOnUse(new class_4140[]{FowlPlayMemoryTypes.RECIPIENT.get()});
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> fightActivity(class_4097<? super T> ... behaviours) {
        return new BrainActivityGroup(class_4168.field_22396).priority(10).behaviours(behaviours).requireAndWipeMemoriesOnUse(new class_4140[]{class_4140.field_22355});
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> forageActivity(class_4097<? super T> ... behaviours) {
        return new BrainActivityGroup(FowlPlayActivities.FORAGE.get()).priority(10).behaviours(behaviours);
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> idleActivity(class_4097<? super T> ... behaviours) {
        return new BrainActivityGroup(class_4168.field_18595).priority(10).behaviours(behaviours);
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> perchActivity(class_4097<? super T> ... behaviours) {
        return new BrainActivityGroup(FowlPlayActivities.PERCH.get()).priority(10).behaviours(behaviours);
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> pickupFoodActivity(class_4097<? super T> ... behaviours) {
        return new BrainActivityGroup(FowlPlayActivities.PICK_UP.get()).priority(10).behaviours(behaviours).requireAndWipeMemoriesOnUse(new class_4140[]{FowlPlayMemoryTypes.SEES_FOOD.get()});
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> restActivity(class_4097<? super T> ... behaviours) {
        return new BrainActivityGroup(class_4168.field_18597).priority(10).behaviours(behaviours);
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> soarActivity(class_4097<? super T> ... behaviours) {
        return new BrainActivityGroup(FowlPlayActivities.SOAR.get()).priority(10).behaviours(behaviours);
    }

    default public Map<class_4168, BrainActivityGroup<? extends E>> getAdditionalTasks() {
        Object2ObjectOpenHashMap taskList = new Object2ObjectOpenHashMap();
        BrainActivityGroup<E> activityGroup = this.getDeliverTasks();
        if (!activityGroup.getBehaviours().isEmpty()) {
            taskList.put((Object)FowlPlayActivities.DELIVER.get(), activityGroup);
        }
        if (!(activityGroup = this.getAvoidTasks()).getBehaviours().isEmpty()) {
            taskList.put((Object)class_4168.field_22399, activityGroup);
        }
        if (!(activityGroup = this.getPickupFoodTasks()).getBehaviours().isEmpty()) {
            taskList.put((Object)FowlPlayActivities.PICK_UP.get(), activityGroup);
        }
        if (!(activityGroup = this.getForageTasks()).getBehaviours().isEmpty()) {
            taskList.put((Object)FowlPlayActivities.FORAGE.get(), activityGroup);
        }
        if (!(activityGroup = this.getSoarTasks()).getBehaviours().isEmpty()) {
            taskList.put((Object)FowlPlayActivities.SOAR.get(), activityGroup);
        }
        if (!(activityGroup = this.getPerchTasks()).getBehaviours().isEmpty()) {
            taskList.put((Object)FowlPlayActivities.PERCH.get(), activityGroup);
        }
        if (!(activityGroup = this.getRestTasks()).getBehaviours().isEmpty()) {
            taskList.put((Object)class_4168.field_18597, activityGroup);
        }
        return taskList;
    }

    default public List<class_4168> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new class_4168[]{FowlPlayActivities.DELIVER.get(), class_4168.field_22399, class_4168.field_22396, FowlPlayActivities.PICK_UP.get(), FowlPlayActivities.FORAGE.get(), FowlPlayActivities.SOAR.get(), FowlPlayActivities.PERCH.get(), class_4168.field_18595, class_4168.field_18597});
    }

    default public Set<class_4168> getScheduleIgnoringActivities() {
        return ObjectArraySet.of((Object[])new class_4168[]{FowlPlayActivities.DELIVER.get(), class_4168.field_22399, class_4168.field_22396, FowlPlayActivities.PICK_UP.get()});
    }

    default public class_4168 getDefaultActivity() {
        return class_4168.field_18597;
    }
}

