/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.util;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.DSL;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.level.entity.SpawnPlacementsRegistry;
import java.util.function.Supplier;
import net.minecraft.class_1208;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_4048;
import net.minecraft.class_5132;
import net.minecraft.class_7696;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_9064;
import net.minecraft.class_9066;
import net.minecraft.class_9168;
import org.jetbrains.annotations.Nullable;

public class EntityTypeBuilder<T extends class_1297> {
    private final class_1299.class_4049<T> factory;
    private final class_1311 category;
    private ImmutableSet<class_2248> immuneTo = ImmutableSet.of();
    private boolean serialize = true;
    private boolean summon = true;
    private boolean fireImmune;
    private boolean canSpawnFarFromPlayer;
    private int clientTrackingRange = 5;
    private int updateInterval = 3;
    private class_4048 dimensions = class_4048.method_18384((float)0.6f, (float)1.8f);
    private float spawnDimensionsScale = 1.0f;
    private class_9066.class_9067 attachments = class_9066.method_55673();
    private class_7699 requiredFeatures = class_7701.field_40182;
    @Nullable
    private Supplier<class_5132.class_5133> attributeBuilder;
    private class_9168 spawnPlacement;
    private class_2902.class_2903 heightmap;
    private class_1317.class_4306<T> spawnPredicate;

    private EntityTypeBuilder(class_1299.class_4049<T> factory, class_1311 category) {
        this.factory = factory;
        this.category = category;
        this.canSpawnFarFromPlayer = category == class_1311.field_6294 || category == class_1311.field_17715;
    }

    public static <T extends class_1297> EntityTypeBuilder<T> of(class_1299.class_4049<T> factory, class_1311 spawnGroup) {
        return new EntityTypeBuilder<T>(factory, spawnGroup);
    }

    public EntityTypeBuilder<T> sized(float width, float height) {
        this.dimensions = class_4048.method_18384((float)width, (float)height);
        return this;
    }

    public EntityTypeBuilder<T> spawnDimensionsScale(float spawnBoxScale) {
        this.spawnDimensionsScale = spawnBoxScale;
        return this;
    }

    public EntityTypeBuilder<T> eyeHeight(float eyeHeight) {
        this.dimensions = this.dimensions.method_55685(eyeHeight);
        return this;
    }

    public EntityTypeBuilder<T> passengerAttachments(float ... offsetYs) {
        for (float f : offsetYs) {
            this.attachments = this.attachments.method_55682(class_9064.field_47743, 0.0f, f, 0.0f);
        }
        return this;
    }

    public EntityTypeBuilder<T> passengerAttachments(class_243 ... passengerAttachments) {
        for (class_243 vec3d : passengerAttachments) {
            this.attachments = this.attachments.method_55683(class_9064.field_47743, vec3d);
        }
        return this;
    }

    public EntityTypeBuilder<T> vehicleAttachment(class_243 vehicleAttachment) {
        return this.attach(class_9064.field_47744, vehicleAttachment);
    }

    public EntityTypeBuilder<T> ridingOffset(float offsetY) {
        return this.attach(class_9064.field_47744, 0.0f, -offsetY, 0.0f);
    }

    public EntityTypeBuilder<T> nameTagOffset(float offsetY) {
        return this.attach(class_9064.field_47745, 0.0f, offsetY, 0.0f);
    }

    public EntityTypeBuilder<T> attach(class_9064 type, float offsetX, float offsetY, float offsetZ) {
        this.attachments = this.attachments.method_55682(type, offsetX, offsetY, offsetZ);
        return this;
    }

    public EntityTypeBuilder<T> attach(class_9064 type, class_243 offset) {
        this.attachments = this.attachments.method_55683(type, offset);
        return this;
    }

    public EntityTypeBuilder<T> noSummon() {
        this.summon = false;
        return this;
    }

    public EntityTypeBuilder<T> noSave() {
        this.serialize = false;
        return this;
    }

    public EntityTypeBuilder<T> fireImmune() {
        this.fireImmune = true;
        return this;
    }

    public EntityTypeBuilder<T> immuneTo(class_2248 ... blocks) {
        this.immuneTo = ImmutableSet.copyOf((Object[])blocks);
        return this;
    }

    public EntityTypeBuilder<T> canSpawnFarFromPlayer() {
        this.canSpawnFarFromPlayer = true;
        return this;
    }

    public EntityTypeBuilder<T> clientTrackingRange(int maxTrackingRange) {
        this.clientTrackingRange = maxTrackingRange;
        return this;
    }

    public EntityTypeBuilder<T> updateInterval(int ticks) {
        this.updateInterval = ticks;
        return this;
    }

    public EntityTypeBuilder<T> requiredFeatures(class_7696 ... features) {
        this.requiredFeatures = class_7701.field_40180.method_45390(features);
        return this;
    }

    public EntityTypeBuilder<T> attributes(Supplier<class_5132.class_5133> attributeBuilder) {
        this.attributeBuilder = attributeBuilder;
        return this;
    }

    public EntityTypeBuilder<T> spawnRestriction(class_9168 location, class_2902.class_2903 heightmap, class_1317.class_4306<T> spawnPredicate) {
        this.spawnPlacement = location;
        this.heightmap = heightmap;
        this.spawnPredicate = spawnPredicate;
        return this;
    }

    public class_1299<T> build() {
        return this.build(null);
    }

    public class_1299<T> build(String id) {
        class_1299 type;
        if (this.serialize) {
            class_156.method_29187((DSL.TypeReference)class_1208.field_5723, (String)id);
        }
        if ((type = new class_1299(this.factory, this.category, this.serialize, this.summon, this.fireImmune, this.canSpawnFarFromPlayer, this.immuneTo, this.dimensions.method_55684(this.attachments), this.spawnDimensionsScale, this.clientTrackingRange, this.updateInterval, this.requiredFeatures)).method_31794().isAssignableFrom(class_1309.class) && this.attributeBuilder != null) {
            EntityAttributeRegistry.register(() -> type, this.attributeBuilder);
        }
        if (type.method_31794().isAssignableFrom(class_1308.class) && this.spawnPredicate != null) {
            SpawnPlacementsRegistry.register(() -> type, (class_9168)this.spawnPlacement, (class_2902.class_2903)this.heightmap, this.spawnPredicate);
        }
        return type;
    }
}

