/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.Flocking;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.PigeonVariant;
import aqario.fowlplay.common.entity.TameableBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CompositeBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CustomBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.DeliverBundle;
import aqario.fowlplay.common.entity.ai.brain.behaviour.FlightBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.LeaderlessFlocking;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetEntityLookTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetOwnerTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetPerchWalkTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.TeleportToTarget;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.PigeonSpecificSensor;
import aqario.fowlplay.common.entity.ai.navigation.GroundNavigation;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayBuiltInRegistries;
import aqario.fowlplay.core.FowlPlayEntityDataSerializers;
import aqario.fowlplay.core.FowlPlayMemoryTypes;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class PigeonEntity
extends TameableBirdEntity
implements BirdBrain<PigeonEntity>,
VariantHolder<PigeonVariant>,
Flocking {
    private static final EntityDataAccessor<Optional<UUID>> RECIPIENT = SynchedEntityData.m_135353_(PigeonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<PigeonVariant> VARIANT = SynchedEntityData.m_135353_(PigeonEntity.class, FowlPlayEntityDataSerializers.PIGEON_VARIANT);
    public final AnimationState sittingState = new AnimationState();

    public PigeonEntity(EntityType<? extends PigeonEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.5f;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        float f = world.m_213780_().m_188501_();
        if (f < 0.5f) {
            this.setVariant(PigeonVariant.BANDED.get());
        } else if (f < 0.75f) {
            this.setVariant(PigeonVariant.CHECKERED.get());
        } else if (f < 0.95f) {
            this.setVariant(PigeonVariant.GRAY.get());
        } else if (f < 0.99f) {
            this.setVariant(PigeonVariant.RUSTY.get());
        } else {
            this.setVariant(PigeonVariant.WHITE.get());
        }
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        this.m_21409_(EquipmentSlot.MAINHAND, 1.0f);
        this.m_21409_(EquipmentSlot.OFFHAND, 1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RECIPIENT, Optional.empty());
        this.f_19804_.m_135372_(VARIANT, (Object)PigeonVariant.BANDED.get());
    }

    public PigeonVariant getVariant() {
        return (PigeonVariant)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(PigeonVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("variant", FowlPlayBuiltInRegistries.PIGEON_VARIANT.get().fowlplay$getKey(this.getVariant()).toString());
        if (this.getRecipientUuid() != null) {
            nbt.m_128362_("recipient", this.getRecipientUuid());
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        PigeonVariant variant = FowlPlayBuiltInRegistries.PIGEON_VARIANT.get().fowlplay$get(ResourceLocation.m_135820_((String)nbt.m_128461_("variant")));
        if (variant != null) {
            this.setVariant(variant);
        }
        if (nbt.m_128403_("recipient")) {
            this.setRecipientUuid(nbt.m_128342_("recipient"));
        } else {
            this.setRecipientUuid(null);
        }
    }

    @Override
    public Pair<Integer, Integer> getFlyHeightRange() {
        return Pair.of((Object)10, (Object)12);
    }

    @Override
    public float getWaterline() {
        return 0.45f;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public boolean m_6162_() {
        return false;
    }

    public static AttributeSupplier.Builder createPigeonAttributes() {
        return FlyingBirdEntity.createFlyingBirdAttributes().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22280_, (double)0.26f);
    }

    @Override
    protected PathNavigation getLandNavigation() {
        GroundNavigation navigation = new GroundNavigation((Mob)this, this.m_9236_());
        navigation.m_26477_(false);
        navigation.m_148214_(true);
        navigation.m_7008_(false);
        return navigation;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack playerStack = player.m_21120_(hand);
        ItemStack bundleStack = this.m_21120_(InteractionHand.OFF_HAND);
        if (bundleStack.m_41619_() && playerStack.m_41720_() instanceof BundleItem && playerStack.m_41788_() && this.isTamed()) {
            if (!this.m_9236_().f_46443_) {
                this.m_21008_(InteractionHand.OFF_HAND, playerStack);
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (playerStack.m_41619_() && bundleStack.m_41720_() instanceof BundleItem) {
            if (!this.m_9236_().f_46443_) {
                player.m_21008_(hand, bundleStack);
                this.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_6898_(playerStack) && !this.isTamed()) {
            if (!this.m_9236_().f_46443_) {
                this.m_142075_(player, hand, playerStack);
                if (this.f_19796_.m_188503_(4) == 0) {
                    this.setOwner(player);
                    this.f_21344_.m_26573_();
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_20096_() && this.isTamed() && this.isOwner((LivingEntity)player)) {
            if (!this.m_9236_().f_46443_) {
                this.setSitting(!this.isSitting());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return !this.isTamed() && this.getFood().test(stack);
    }

    @Override
    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot equipmentSlot = PigeonEntity.m_147233_((ItemStack)stack);
        if (!this.m_6844_(equipmentSlot).m_41619_()) {
            return false;
        }
        return equipmentSlot == EquipmentSlot.MAINHAND || equipmentSlot == EquipmentSlot.OFFHAND && super.m_7066_(stack);
    }

    @Override
    public Ingredient getFood() {
        return Ingredient.m_204132_(FowlPlayItemTags.PIGEON_FOOD);
    }

    @Override
    public boolean shouldAvoid(LivingEntity entity) {
        return entity.m_6095_().m_204039_(FowlPlayEntityTypeTags.PIGEON_AVOIDS);
    }

    protected void m_5907_() {
        super.m_5907_();
        this.m_19983_(this.m_6844_(EquipmentSlot.MAINHAND));
        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.m_19983_(this.m_6844_(EquipmentSlot.OFFHAND));
        this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
    }

    @Override
    public void updateAnimations() {
        this.standingState.m_246184_(!this.isFlying() && !this.m_20072_() && !this.isInSittingPose(), this.f_19797_);
        this.flappingState.m_246184_(this.isFlying(), this.f_19797_);
        this.swimmingState.m_246184_(!this.isFlying() && this.m_20072_(), this.f_19797_);
        this.sittingState.m_246184_(this.isInSittingPose(), this.f_19797_);
    }

    @Override
    public float getFlapVolume() {
        return 0.65f;
    }

    @Override
    public float getFlapPitch() {
        return 0.9f;
    }

    @Nullable
    public UUID getRecipientUuid() {
        return ((Optional)this.f_19804_.m_135370_(RECIPIENT)).orElse(null);
    }

    public void setRecipientUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(RECIPIENT, Optional.ofNullable(uuid));
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Override
    protected boolean canSing() {
        if (this.m_9236_().m_46461_()) {
            return false;
        }
        List list = this.m_9236_().m_6443_(Player.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0), EntitySelector.f_20408_);
        if (list.isEmpty()) {
            return false;
        }
        return super.canSing();
    }

    @Override
    @Nullable
    protected SoundEvent getCallSound() {
        return FowlPlaySoundEvents.ENTITY_PIGEON_CALL.get();
    }

    @Override
    @Nullable
    protected SoundEvent getSongSound() {
        return FowlPlaySoundEvents.ENTITY_PIGEON_SONG.get();
    }

    @Override
    public int getCallDelay() {
        return 120;
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().pigeonCallVolume;
    }

    @Override
    protected float getSongVolume() {
        return FowlPlayConfig.getInstance().pigeonSongVolume;
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return FowlPlaySoundEvents.ENTITY_PIGEON_HURT.get();
    }

    @Override
    public boolean isLeader() {
        return false;
    }

    @Override
    public void setLeader() {
    }

    protected Brain.Provider<PigeonEntity> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<? extends ExtendedSensor<? extends PigeonEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor(), new AvoidTargetSensor(), new PigeonSpecificSensor()});
    }

    public BrainActivityGroup<? extends PigeonEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new Behavior[]{new FloatToSurfaceOfFluid().riseChance(0.5f), FlightBehaviours.stopFalling(), new TeleportToTarget(), new SetOwnerTarget(), SetEntityLookTarget.create(Birds::isPlayerHoldingFood), new LookAtTarget().runFor(entity -> entity.m_217043_().m_216332_(45, 90)), new MoveToWalkTarget().startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, FowlPlayMemoryTypes.TELEPORT_TARGET.get())).stopIf(entity -> BrainUtils.hasMemory((LivingEntity)entity, FowlPlayMemoryTypes.TELEPORT_TARGET.get()))});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new Behavior[]{CustomBehaviours.setAvoidEntityWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getDeliverTasks() {
        return BirdBrain.deliverActivity(new Behavior[]{FlightBehaviours.stopFlying().startCondition(PigeonEntity::shouldStopFlyingToRecipient), FlightBehaviours.startFlying().startCondition(PigeonEntity::shouldFlyToRecipient), DeliverBundle.run()});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getForageTasks() {
        return BirdBrain.forageActivity(new Behavior[]{new OneRandomBehaviour(new ExtendedBehaviour[]{CompositeBehaviours.tryForage(), CompositeBehaviours.tryPerch()})});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getPerchTasks() {
        return BirdBrain.perchActivity(new Behavior[]{new LeaderlessFlocking(5, 0.03f, 0.6f, 0.05f, 3.0f), CompositeBehaviours.tryPerch()});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new Behavior[]{CompositeBehaviours.tryPickUpFood().startCondition(pigeon -> !pigeon.isSitting())});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getRestTasks() {
        return BirdBrain.restActivity(new Behavior[]{new SetPerchWalkTarget().startCondition(Predicate.not(Birds::isPerched)), CustomBehaviours.idleIfPerched()});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.FORAGER.get();
    }

    private static boolean shouldFlyToRecipient(PigeonEntity pigeon) {
        UUID recipientUuid = pigeon.m_6274_().m_21952_(FowlPlayMemoryTypes.RECIPIENT.get()).orElse(null);
        if (recipientUuid == null) {
            return false;
        }
        Player recipient = pigeon.m_9236_().m_46003_(recipientUuid);
        if (recipient == null) {
            return false;
        }
        return pigeon.m_20280_((Entity)recipient) > 64.0;
    }

    private static boolean shouldStopFlyingToRecipient(PigeonEntity pigeon) {
        UUID recipientUuid = pigeon.m_6274_().m_21952_(FowlPlayMemoryTypes.RECIPIENT.get()).orElse(null);
        if (recipientUuid == null) {
            return true;
        }
        Player recipient = pigeon.m_9236_().m_46003_(recipientUuid);
        if (recipient == null) {
            return true;
        }
        return pigeon.m_20280_((Entity)recipient) < 16.0;
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
        super.m_8024_();
        if (this.m_20194_() == null) {
            return;
        }
        if (!this.isTamed()) {
            return;
        }
        ItemStack stack = this.m_6844_(EquipmentSlot.OFFHAND);
        ServerPlayer recipient = this.m_20194_().m_6846_().m_11255_(stack.m_41786_().getString());
        if (!(stack.m_41720_() instanceof BundleItem) || !stack.m_41788_() || recipient == null) {
            this.setRecipientUuid(null);
            return;
        }
        this.setRecipientUuid(recipient.m_20148_());
    }
}

