/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.core.FowlPlayItems;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class ScarecrowEntity
extends LivingEntity
implements ContainerListener,
MenuProvider {
    private static final Predicate<Entity> RIDEABLE_MINECART_PREDICATE = entity -> entity instanceof AbstractMinecart && ((AbstractMinecart)entity).m_6064_() == AbstractMinecart.Type.RIDEABLE;
    private static final Rotations DEFAULT_HEAD_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFT_ARM_ROTATION = new Rotations(0.0f, 0.0f, -90.0f);
    private static final Rotations DEFAULT_RIGHT_ARM_ROTATION = new Rotations(0.0f, 0.0f, 90.0f);
    public static final EntityDataAccessor<Rotations> HEAD_ROTATION = SynchedEntityData.m_135353_(ScarecrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> BODY_ROTATION = SynchedEntityData.m_135353_(ScarecrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> LEFT_ARM_ROTATION = SynchedEntityData.m_135353_(ScarecrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> RIGHT_ARM_ROTATION = SynchedEntityData.m_135353_(ScarecrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    private Rotations headRotation = DEFAULT_HEAD_ROTATION;
    private Rotations bodyRotation = DEFAULT_BODY_ROTATION;
    private Rotations leftArmRotation = DEFAULT_LEFT_ARM_ROTATION;
    private Rotations rightArmRotation = DEFAULT_RIGHT_ARM_ROTATION;
    private static final String POSE_KEY = "pose";
    private static final String HEAD_ROTATION_KEY = "head";
    private static final String BODY_ROTATION_KEY = "body";
    private static final String LEFT_ARM_ROTATION_KEY = "left_arm";
    private static final String RIGHT_ARM_ROTATION_KEY = "right_arm";
    private static final String ITEMS_KEY = "items";
    private static final String SLOT_KEY = "slot";
    private static final int INVENTORY_SIZE = 4;
    private static final int HEAD_SLOT = 0;
    private static final int CHEST_SLOT = 1;
    private static final int MAINHAND_SLOT = 2;
    private static final int OFFHAND_SLOT = 3;
    protected SimpleContainer inventory = new SimpleContainer(4);

    public ScarecrowEntity(EntityType<? extends ScarecrowEntity> entityType, Level world) {
        super(entityType, world);
        this.inventory.m_19164_((ContainerListener)this);
        this.m_274367_(0.0f);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 1.72f;
    }

    public static AttributeSupplier.Builder createScarecrowAttributes() {
        return ScarecrowEntity.m_21183_().m_22268_(Attributes.f_22278_, 1.0);
    }

    protected float m_5632_(float bodyRotation, float headRotation) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    public void m_5618_(float bodyYaw) {
        this.f_20884_ = this.f_19859_ = bodyYaw;
        this.f_20886_ = this.f_20885_ = bodyYaw;
    }

    public void m_5616_(float headYaw) {
        this.f_20884_ = this.f_19859_ = headYaw;
        this.f_20886_ = this.f_20885_ = headYaw;
    }

    public void m_5757_(Container sender) {
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemStack = this.inventory.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                this.m_19983_(itemStack);
            }
        }
    }

    public Iterable<ItemStack> m_6167_() {
        return ImmutableList.of((Object)this.inventory.m_8020_(2), (Object)this.inventory.m_8020_(3));
    }

    public Iterable<ItemStack> m_6168_() {
        return ImmutableList.of((Object)this.inventory.m_8020_(0), (Object)this.inventory.m_8020_(1));
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> this.inventory.m_8020_(0);
            case EquipmentSlot.CHEST -> this.inventory.m_8020_(1);
            case EquipmentSlot.MAINHAND -> this.inventory.m_8020_(2);
            case EquipmentSlot.OFFHAND -> this.inventory.m_8020_(3);
            default -> ItemStack.f_41583_;
        };
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        this.m_181122_(stack);
        switch (slot) {
            case HEAD: {
                this.inventory.m_6836_(0, stack);
                break;
            }
            case CHEST: {
                this.inventory.m_6836_(1, stack);
                break;
            }
            case MAINHAND: {
                this.inventory.m_6836_(2, stack);
                break;
            }
            case OFFHAND: {
                this.inventory.m_6836_(3, stack);
            }
        }
    }

    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot equipmentSlot = ScarecrowEntity.m_147233_((ItemStack)stack);
        return this.m_6844_(equipmentSlot).m_41619_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEAD_ROTATION, (Object)DEFAULT_HEAD_ROTATION);
        this.f_19804_.m_135372_(BODY_ROTATION, (Object)DEFAULT_BODY_ROTATION);
        this.f_19804_.m_135372_(LEFT_ARM_ROTATION, (Object)DEFAULT_LEFT_ARM_ROTATION);
        this.f_19804_.m_135372_(RIGHT_ARM_ROTATION, (Object)DEFAULT_RIGHT_ARM_ROTATION);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag nbtList = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemStack = this.inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag nbtCompound = new CompoundTag();
            nbtCompound.m_128344_(SLOT_KEY, (byte)i);
            itemStack.m_41739_(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        nbt.m_128365_(ITEMS_KEY, (Tag)nbtList);
        nbt.m_128365_(POSE_KEY, (Tag)this.poseToNbt());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        ListTag nbtList = nbt.m_128437_(ITEMS_KEY, 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            int j = nbtCompound.m_128445_(SLOT_KEY) & 0xFF;
            if (j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)nbtCompound));
        }
        CompoundTag poseNbt = nbt.m_128469_(POSE_KEY);
        this.readPoseNbt(poseNbt);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!player.m_9236_().m_5776_() && player.m_21120_(hand).m_41619_() && !player.m_36341_()) {
            return InteractionResult.CONSUME;
        }
        return super.m_6096_(player, hand);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player playerEntity) {
        return null;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    protected void m_6138_() {
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_(), RIDEABLE_MINECART_PREDICATE);
        for (Entity entity : list) {
            if (!(this.m_20280_(entity) <= 0.2)) continue;
            entity.m_7334_((Entity)this);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_9236_().m_5776_() || this.m_213877_()) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            this.m_6074_();
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_7640_() instanceof FireworkRocketEntity) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            this.updateHealth(source, amount);
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268546_)) {
            this.m_20254_(10);
            if (this.m_6060_()) {
                this.updateHealth(source, 1.0f);
            }
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            this.m_20254_(5);
            if (this.m_6060_()) {
                this.updateHealth(source, 0.05f);
            }
            return false;
        }
        if (source.m_7640_() instanceof AbstractArrow) {
            return true;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_6144_()) {
                this.m_146852_(GameEvent.f_223706_, source.m_7639_());
                return true;
            }
            if (!player.m_150110_().f_35938_) {
                return false;
            }
            if (source.m_19390_()) {
                this.onBreak(source);
                this.spawnBreakParticles();
                this.m_6074_();
                return false;
            }
            this.breakAndDropThis(source);
            this.spawnBreakParticles();
            this.m_6074_();
        }
        return true;
    }

    public boolean m_6673_(DamageSource damageSource) {
        return damageSource.m_269533_(DamageTypeTags.f_268549_);
    }

    public void m_8038_(ServerLevel world, LightningBolt lightning) {
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_146850_(GameEvent.f_223707_);
    }

    protected void spawnBreakParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            world.m_8767_(this.getParticle(), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    private void updateHealth(DamageSource damageSource, float amount) {
        float f = this.m_21223_();
        if ((f -= amount) <= 0.5f) {
            this.onBreak(damageSource);
            this.m_6074_();
        } else {
            this.m_21153_(f);
            this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
        }
    }

    private void breakAndDropThis(DamageSource damageSource) {
        Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)this.getItem());
        this.onBreak(damageSource);
    }

    private void onBreak(DamageSource damageSource) {
        this.playBreakSound();
        this.m_6668_(damageSource);
    }

    private void playBreakSound() {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5592_(), this.m_5720_(), 1.0f, 1.0f);
    }

    private void readPoseNbt(CompoundTag nbt) {
        ListTag head = nbt.m_128437_(HEAD_ROTATION_KEY, 5);
        ListTag body = nbt.m_128437_(BODY_ROTATION_KEY, 5);
        ListTag leftArm = nbt.m_128437_(LEFT_ARM_ROTATION_KEY, 5);
        ListTag rightArm = nbt.m_128437_(RIGHT_ARM_ROTATION_KEY, 5);
        this.setHeadRotation(head.isEmpty() ? DEFAULT_HEAD_ROTATION : new Rotations(head));
        this.setBodyRotation(body.isEmpty() ? DEFAULT_BODY_ROTATION : new Rotations(body));
        this.setLeftArmRotation(leftArm.isEmpty() ? DEFAULT_LEFT_ARM_ROTATION : new Rotations(leftArm));
        this.setRightArmRotation(rightArm.isEmpty() ? DEFAULT_RIGHT_ARM_ROTATION : new Rotations(rightArm));
    }

    private CompoundTag poseToNbt() {
        CompoundTag nbt = new CompoundTag();
        if (!DEFAULT_HEAD_ROTATION.equals((Object)this.headRotation)) {
            nbt.m_128365_(HEAD_ROTATION_KEY, (Tag)this.headRotation.m_123155_());
        }
        if (!DEFAULT_BODY_ROTATION.equals((Object)this.bodyRotation)) {
            nbt.m_128365_(BODY_ROTATION_KEY, (Tag)this.bodyRotation.m_123155_());
        }
        if (!DEFAULT_LEFT_ARM_ROTATION.equals((Object)this.leftArmRotation)) {
            nbt.m_128365_(LEFT_ARM_ROTATION_KEY, (Tag)this.leftArmRotation.m_123155_());
        }
        if (!DEFAULT_RIGHT_ARM_ROTATION.equals((Object)this.rightArmRotation)) {
            nbt.m_128365_(RIGHT_ARM_ROTATION_KEY, (Tag)this.rightArmRotation.m_123155_());
        }
        return nbt;
    }

    public Rotations getHeadRotation() {
        return this.headRotation;
    }

    public Rotations getBodyRotation() {
        return this.bodyRotation;
    }

    public Rotations getLeftArmRotation() {
        return this.leftArmRotation;
    }

    public Rotations getRightArmRotation() {
        return this.rightArmRotation;
    }

    public void setHeadRotation(Rotations angle) {
        this.headRotation = angle;
        this.f_19804_.m_135381_(HEAD_ROTATION, (Object)angle);
    }

    public void setBodyRotation(Rotations angle) {
        this.bodyRotation = angle;
        this.f_19804_.m_135381_(BODY_ROTATION, (Object)angle);
    }

    public void setLeftArmRotation(Rotations angle) {
        this.leftArmRotation = angle;
        this.f_19804_.m_135381_(LEFT_ARM_ROTATION, (Object)angle);
    }

    public void setRightArmRotation(Rotations angle) {
        this.rightArmRotation = angle;
        this.f_19804_.m_135381_(RIGHT_ARM_ROTATION, (Object)angle);
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public ItemStack getItem() {
        return FowlPlayItems.SCARECROW.get().m_7968_();
    }

    public ParticleOptions getParticle() {
        return new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50335_.m_49966_());
    }

    public SoundEvent getPlaceSound() {
        return SoundEvents.f_12635_;
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_12633_, SoundEvents.f_12633_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12634_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12630_;
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_5789_() {
        return false;
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.getItem();
    }
}

