/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public abstract class TameableBirdEntity
extends TrustingBirdEntity
implements OwnableEntity {
    protected static final EntityDataAccessor<Byte> TAMEABLE_FLAGS = SynchedEntityData.m_135353_(TameableBirdEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(TameableBirdEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private boolean sitting;

    protected TameableBirdEntity(EntityType<? extends BirdEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TAMEABLE_FLAGS, (Object)0);
        this.f_19804_.m_135372_(OWNER, Optional.empty());
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.m_21805_() != null) {
            nbt.m_128362_("owner", this.m_21805_());
        }
        nbt.m_128379_("sitting", this.sitting);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        UUID uuid;
        super.m_7378_(nbt);
        if (nbt.m_128403_("owner")) {
            uuid = nbt.m_128342_("owner");
        } else {
            String string = nbt.m_128461_("owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)string);
        }
        if (uuid != null) {
            try {
                this.setOwnerUuid(uuid);
                this.setTamed(true);
            }
            catch (Throwable throwable) {
                this.setTamed(false);
            }
        }
        this.sitting = nbt.m_128471_("sitting");
        this.setInSittingPose(this.sitting);
    }

    protected void showEmoteParticle(boolean positive) {
        SimpleParticleType particleEffect = ParticleTypes.f_123750_;
        if (!positive) {
            particleEffect = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.f_19796_.m_188583_() * 0.02;
            double e = this.f_19796_.m_188583_() * 0.02;
            double f = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleEffect, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
        }
    }

    @Override
    public void m_7822_(byte status) {
        if (status == 7) {
            this.showEmoteParticle(true);
        } else if (status == 6) {
            this.showEmoteParticle(false);
        } else {
            super.m_7822_(status);
        }
    }

    public boolean isTamed() {
        return ((Byte)this.f_19804_.m_135370_(TAMEABLE_FLAGS) & 4) != 0;
    }

    public void setTamed(boolean tamed) {
        byte b = (Byte)this.f_19804_.m_135370_(TAMEABLE_FLAGS);
        if (tamed) {
            this.f_19804_.m_135381_(TAMEABLE_FLAGS, (Object)((byte)(b | 4)));
        } else {
            this.f_19804_.m_135381_(TAMEABLE_FLAGS, (Object)((byte)(b & 0xFFFFFFFB)));
        }
        this.onTamedChanged();
    }

    protected void onTamedChanged() {
    }

    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(TAMEABLE_FLAGS) & 1) != 0;
    }

    public void setInSittingPose(boolean inSittingPose) {
        byte b = (Byte)this.f_19804_.m_135370_(TAMEABLE_FLAGS);
        if (inSittingPose) {
            this.f_19804_.m_135381_(TAMEABLE_FLAGS, (Object)((byte)(b | 1)));
        } else {
            this.f_19804_.m_135381_(TAMEABLE_FLAGS, (Object)((byte)(b & 0xFFFFFFFE)));
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_ && !this.m_6673_(source)) {
            this.setSitting(false);
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_21805_() != null) {
            this.addTrustedUuid(this.m_21805_());
            if (!this.m_21532_()) {
                this.m_21530_();
            }
        }
        if (this.isFlying()) {
            this.setSitting(false);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isSitting()) {
                this.m_21573_().m_26573_();
                this.setInSittingPose(true);
            } else {
                this.setInSittingPose(false);
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return this.trusts(player) ? super.m_6071_(player, hand) : InteractionResult.PASS;
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER)).orElse(null);
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER, Optional.ofNullable(uuid));
    }

    public void setOwner(Player player) {
        this.setTamed(true);
        this.setOwnerUuid(player.m_20148_());
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)player, (Animal)this);
        }
    }

    @Nullable
    public LivingEntity m_269323_() {
        try {
            UUID uuid = this.m_21805_();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Override
    public boolean m_6779_(LivingEntity target) {
        return !this.isOwner(target) && super.m_6779_(target);
    }

    public boolean isOwner(LivingEntity entity) {
        return entity == this.m_269323_();
    }

    public Team m_5647_() {
        LivingEntity livingEntity;
        if (this.isTamed() && (livingEntity = this.m_269323_()) != null) {
            return livingEntity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(Entity other) {
        if (this.isTamed()) {
            LivingEntity livingEntity = this.m_269323_();
            if (other == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.m_7307_(other);
            }
        }
        return super.m_7307_(other);
    }

    public void m_6667_(DamageSource source) {
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && this.m_269323_() instanceof ServerPlayer) {
            this.m_269323_().m_213846_(this.m_21231_().m_19293_());
        }
        super.m_6667_(source);
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public void setSitting(boolean sitting) {
        this.sitting = sitting;
    }

    public Level m_9236_() {
        return super.m_9236_();
    }
}

