/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.core.FowlPlayEntityDataSerializers;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class TrustingBirdEntity
extends FlyingBirdEntity {
    protected static final EntityDataAccessor<List<UUID>> TRUSTED = SynchedEntityData.m_135353_(TrustingBirdEntity.class, FowlPlayEntityDataSerializers.UUID_LIST);

    protected TrustingBirdEntity(EntityType<? extends BirdEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public int getFleeRange(LivingEntity target) {
        return !this.getTrustedUuids().isEmpty() && target instanceof Player ? 8 : super.getFleeRange(target);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRUSTED, new ArrayList());
    }

    protected ListTag toNbtList(List<UUID> uuids) {
        ListTag nbtList = new ListTag();
        for (UUID uuid : uuids) {
            nbtList.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        return nbtList;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("trusted", (Tag)this.toNbtList(this.getTrustedUuids()));
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        ListTag list;
        super.m_7378_(nbt);
        if (nbt.m_128441_("trusted") && (list = (ListTag)nbt.m_128423_("trusted")) != null) {
            list.forEach(element -> this.addTrustedUuid(NbtUtils.m_129233_((Tag)element)));
        }
    }

    @Override
    protected void m_7581_(ItemEntity item) {
        UUID thrower;
        super.m_7581_(item);
        UUID uUID = thrower = item.m_19749_() != null ? item.m_19749_().m_20148_() : null;
        if (thrower != null && !this.trustsUuid(thrower) && this.f_19796_.m_188503_(3) == 0) {
            this.addTrustedUuid(thrower);
            this.m_9236_().m_7605_((Entity)this, (byte)14);
        }
    }

    @Override
    public void m_7822_(byte status) {
        if (status == 14) {
            if (this.f_146735_ == 0) {
                this.f_146735_ = 20;
            }
        } else {
            super.m_7822_(status);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isAmbient() && !this.getTrustedUuids().isEmpty()) {
            this.setAmbient(false);
        }
    }

    public List<UUID> getTrustedUuids() {
        return (List)this.f_19804_.m_135370_(TRUSTED);
    }

    public void addTrustedUuid(UUID uuid) {
        List trusted = (List)this.f_19804_.m_135370_(TRUSTED);
        trusted.add(uuid);
        this.f_19804_.m_135381_(TRUSTED, (Object)trusted);
    }

    public void removeTrustedUuid(UUID uuid) {
        List trusted = (List)this.f_19804_.m_135370_(TRUSTED);
        trusted.remove(uuid);
        this.f_19804_.m_135381_(TRUSTED, (Object)trusted);
    }

    public void stopTrusting(Player player) {
        this.removeTrustedUuid(player.m_20148_());
    }

    public List<Player> getTrusted() {
        List<UUID> uuids = this.getTrustedUuids();
        ArrayList<Player> entities = new ArrayList<Player>();
        for (UUID uuid : uuids) {
            entities.add(this.m_9236_().m_46003_(uuid));
        }
        return entities;
    }

    @Override
    public boolean m_6779_(LivingEntity target) {
        Player player;
        return (!(target instanceof Player) || !this.trusts(player = (Player)target)) && super.m_6779_(target);
    }

    public boolean trusts(Player player) {
        return this.getTrusted().contains(player);
    }

    public boolean trustsUuid(UUID uuid) {
        return this.getTrustedUuids().contains(uuid);
    }
}

