/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.sensor;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.core.FowlPlaySensorTypes;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.tslat.smartbrainlib.api.core.sensor.EntityFilteringSensor;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.SensoryUtils;
import org.jetbrains.annotations.Nullable;

public class AttackTargetSensor<E extends BirdEntity>
extends EntityFilteringSensor<LivingEntity, E> {
    protected MemoryModuleType<LivingEntity> getMemory() {
        return MemoryModuleType.f_148194_;
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return List.of(this.getMemory(), MemoryModuleType.f_148205_);
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return FowlPlaySensorTypes.ATTACK_TARGETS.get();
    }

    protected BiPredicate<LivingEntity, E> predicate() {
        return (target, self) -> {
            if (self.shouldAttack((LivingEntity)target) && AttackTargetSensor.canAttack(self, target)) {
                return true;
            }
            return self.canHunt((LivingEntity)target) && AttackTargetSensor.canHunt(self, target);
        };
    }

    @Nullable
    protected LivingEntity findMatches(E entity, NearestVisibleLivingEntities matcher) {
        return matcher.m_186116_(target -> this.predicate().test((LivingEntity)target, (E)((Object)entity))).orElse(null);
    }

    private static boolean canAttack(BirdEntity bird, LivingEntity target) {
        return SensoryUtils.isEntityAttackable((LivingEntity)bird, (LivingEntity)target) && EntitySelector.f_20406_.test(target);
    }

    private static boolean canHunt(BirdEntity bird, LivingEntity target) {
        return !BrainUtils.hasMemory((LivingEntity)bird, (MemoryModuleType)MemoryModuleType.f_148201_) && AttackTargetSensor.canAttack(bird, target);
    }
}

