/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.util;

import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.core.tags.FowlPlayBlockTags;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TargetingUtil {
    @Nullable
    public static BlockPos tryFindAir(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = RandomPos.m_217863_((PathfinderMob)entity, (int)range.horizontal(), (RandomSource)entity.m_217043_(), (BlockPos)pos);
        if (GoalUtils.m_148445_((PathfinderMob)entity, (BlockPos)(adjustedPos = RandomPos.m_148545_((BlockPos)adjustedPos, (int)entity.m_9236_().m_151558_(), currentPos -> GoalUtils.m_148461_((PathfinderMob)entity, (BlockPos)currentPos)))) || GoalUtils.m_148458_((PathfinderMob)entity, (BlockPos)adjustedPos) || GoalUtils.m_148448_((PathNavigation)entity.m_21573_(), (BlockPos)adjustedPos)) {
            return null;
        }
        return adjustedPos;
    }

    @Nullable
    public static BlockPos tryFindWater(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, range, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, 0, currentPos -> GoalUtils.m_148461_((PathfinderMob)entity, (BlockPos)currentPos) || GoalUtils.m_148445_((PathfinderMob)entity, (BlockPos)currentPos));
        if (!GoalUtils.m_148445_((PathfinderMob)entity, (BlockPos)adjustedPos)) {
            return null;
        }
        return adjustedPos;
    }

    @Nullable
    public static BlockPos tryFindNonAir(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, range, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, 1, currentPos -> GoalUtils.m_148461_((PathfinderMob)entity, (BlockPos)currentPos) || GoalUtils.m_148445_((PathfinderMob)entity, (BlockPos)currentPos));
        if (GoalUtils.m_148458_((PathfinderMob)entity, (BlockPos)adjustedPos) || !TargetingUtil.isPositionNonAir(entity, adjustedPos)) {
            return null;
        }
        return entity.m_9236_().m_46801_(adjustedPos.m_7495_()) ? adjustedPos.m_7495_() : adjustedPos;
    }

    @Nullable
    public static BlockPos tryFindGround(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, range, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, 1, currentPos -> GoalUtils.m_148461_((PathfinderMob)entity, (BlockPos)currentPos));
        if (GoalUtils.m_148445_((PathfinderMob)entity, (BlockPos)adjustedPos) || GoalUtils.m_148458_((PathfinderMob)entity, (BlockPos)adjustedPos) || !TargetingUtil.isPositionGrounded(entity, adjustedPos)) {
            return null;
        }
        return adjustedPos;
    }

    @Nullable
    public static BlockPos tryFindPerch(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, range, Heightmap.Types.MOTION_BLOCKING, 1, currentPos -> GoalUtils.m_148461_((PathfinderMob)entity, (BlockPos)currentPos) && !TargetingUtil.isPerch(entity, currentPos));
        if (GoalUtils.m_148445_((PathfinderMob)entity, (BlockPos)adjustedPos.m_7495_()) || GoalUtils.m_148458_((PathfinderMob)entity, (BlockPos)adjustedPos) || !TargetingUtil.isPerch(entity, adjustedPos)) {
            return null;
        }
        return entity.m_9236_().m_8055_(adjustedPos).m_60734_() instanceof LeavesBlock ? adjustedPos.m_7495_() : adjustedPos;
    }

    public static BlockPos findSurfacePosition(PathfinderMob entity, BlockPos initialPos, CylindricalRadius range, Heightmap.Types heightmap, int blocksAbove, Predicate<BlockPos> predicate) {
        BlockPos adjustedPos = RandomPos.m_217863_((PathfinderMob)entity, (int)range.horizontal(), (RandomSource)entity.m_217043_(), (BlockPos)initialPos);
        adjustedPos = adjustedPos.m_123342_() > entity.m_9236_().m_6924_(heightmap, adjustedPos.m_123341_(), adjustedPos.m_123343_()) ? new BlockPos(adjustedPos.m_123341_(), entity.m_9236_().m_6924_(heightmap, adjustedPos.m_123341_(), adjustedPos.m_123343_()) + blocksAbove, adjustedPos.m_123343_()) : RandomPos.m_148545_((BlockPos)adjustedPos, (int)entity.m_9236_().m_151558_(), predicate).m_6630_(blocksAbove - 1);
        return adjustedPos;
    }

    @Nullable
    public static BlockPos validateBlockPos(PathfinderMob entity, @Nullable BlockPos pos, CylindricalRadius range) {
        if (pos == null) {
            return null;
        }
        if (GoalUtils.m_148451_((BlockPos)pos, (PathfinderMob)entity) || GoalUtils.m_148454_((boolean)GoalUtils.m_148442_((PathfinderMob)entity, (int)range.horizontal()), (PathfinderMob)entity, (BlockPos)pos)) {
            return null;
        }
        return pos;
    }

    @Nullable
    public static Vec3 validatePos(PathfinderMob entity, BlockPos pos, CylindricalRadius range) {
        BlockPos validPos = TargetingUtil.validateBlockPos(entity, pos, range);
        return validPos != null ? Vec3.m_82539_((Vec3i)validPos) : null;
    }

    public static boolean isPerch(PathfinderMob entity, BlockPos pos) {
        return entity.m_9236_().m_8055_(pos).m_204336_(FowlPlayBlockTags.PERCHES);
    }

    public static boolean isPositionNonAir(PathfinderMob entity, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        return TargetingUtil.isFullBlockAt(entity, belowPos) || GoalUtils.m_148445_((PathfinderMob)entity, (BlockPos)belowPos);
    }

    public static boolean isPositionGrounded(PathfinderMob entity, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        return TargetingUtil.isFullBlockAt(entity, belowPos);
    }

    public static boolean isFullBlockAt(PathfinderMob entity, BlockPos pos) {
        return entity.m_9236_().m_8055_(pos).m_60804_((BlockGetter)entity.m_9236_(), pos);
    }

    public static boolean isWithinAngle(Vec3 normalVec, Vec3 targetVec, double angle) {
        float cosMaxAngle;
        float cosVectorAngle = (float)(normalVec = normalVec.m_82541_()).m_82526_(targetVec = targetVec.m_82541_());
        return cosVectorAngle >= (cosMaxAngle = Mth.m_14089_((float)((float)angle)));
    }

    public static boolean isPosWithinViewAngle(PathfinderMob entity, BlockPos pos, double angle) {
        Vec3 lookVec = entity.m_20252_(1.0f);
        Vec3 target = Vec3.m_82512_((Vec3i)pos);
        Vec3 targetVec = target.m_82546_(entity.m_20182_());
        return TargetingUtil.isWithinAngle(lookVec, targetVec, angle);
    }
}

