/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.mixin;

import aqario.fowlplay.core.platform.CustomMobCategory;
import aqario.fowlplay.core.platform.CustomSpawnPlacementType;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NaturalSpawner.class})
public class NaturalSpawnerMixin {
    @Unique
    private static boolean fowlplay$isClearForSpawn(LevelReader world, BlockPos pos, EntityType<?> entityType) {
        BlockState blockState = world.m_8055_(pos);
        return NaturalSpawner.m_47056_((BlockGetter)world, (BlockPos)pos, (BlockState)blockState, (FluidState)blockState.m_60819_(), entityType);
    }

    @Unique
    private static boolean fowlplay$spawnsOnGround(LevelReader world, BlockPos spawnPos, EntityType<?> entityType) {
        if (entityType != null && world.m_6857_().m_61937_(spawnPos)) {
            BlockPos headPos = spawnPos.m_7494_();
            return NaturalSpawnerMixin.fowlplay$isClearForSpawn(world, spawnPos, entityType) && (entityType.m_20679_() <= 1.0f || NaturalSpawnerMixin.fowlplay$isClearForSpawn(world, headPos, entityType));
        }
        return false;
    }

    @Unique
    private static boolean fowlplay$spawnsOnWater(LevelReader world, BlockPos spawnPos, EntityType<?> entityType) {
        if (entityType != null && world.m_6857_().m_61937_(spawnPos)) {
            BlockPos headPos = spawnPos.m_7494_();
            return world.m_6425_(spawnPos.m_7495_()).m_205070_(FluidTags.f_13131_) && (entityType.m_20679_() <= 1.0f || NaturalSpawnerMixin.fowlplay$isClearForSpawn(world, headPos, entityType));
        }
        return false;
    }

    @Inject(method={"isSpawnPositionOk(Lnet/minecraft/world/entity/SpawnPlacements$Type;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/EntityType;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fowlplay$addCustomSpawnPlacementTypeChecks(SpawnPlacements.Type location, LevelReader world, BlockPos pos, @Nullable EntityType<?> entityType, CallbackInfoReturnable<Boolean> cir) {
        if (location == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (location == SpawnPlacements.Type.NO_RESTRICTIONS) {
            return;
        }
        if (entityType == null || !world.m_6857_().m_61937_(pos)) {
            return;
        }
        if (location == CustomSpawnPlacementType.ground()) {
            cir.setReturnValue((Object)NaturalSpawnerMixin.fowlplay$spawnsOnGround(world, pos, entityType));
        } else if (location == CustomSpawnPlacementType.semiaquatic()) {
            cir.setReturnValue((Object)(NaturalSpawnerMixin.fowlplay$spawnsOnWater(world, pos, entityType) || NaturalSpawnerMixin.fowlplay$spawnsOnGround(world, pos, entityType) ? 1 : 0));
        } else if (location == CustomSpawnPlacementType.aquatic()) {
            cir.setReturnValue((Object)NaturalSpawnerMixin.fowlplay$spawnsOnWater(world, pos, entityType));
        }
    }

    @Inject(method={"spawnCategoryForChunk(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/LevelChunk;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fowlplay$reduceSpawningFrequency(MobCategory group, ServerLevel world, LevelChunk chunk, NaturalSpawner.SpawnPredicate checker, NaturalSpawner.AfterSpawnCallback runner, CallbackInfo ci) {
        if (group == CustomMobCategory.birds() && world.m_6106_().m_6793_() % 20L != 0L) {
            ci.cancel();
        }
    }

    @Redirect(method={"spawnCategoryForPosition(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;getY()I"))
    private static int fowlplay$midairSpawning(BlockPos pos, MobCategory group, ServerLevel world) {
        if ((group == CustomMobCategory.birds() || group == CustomMobCategory.ambientBirds()) && world.m_213780_().m_188501_() < 0.01f && world.m_6106_().m_6793_() % 100L != 0L) {
            return pos.m_123342_() + world.m_213780_().m_216332_(32, 64);
        }
        return pos.m_123342_();
    }
}

