/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.CustomSpawnGroup;
import aqario.fowlplay.common.entity.ai.control.BirdBodyControl;
import aqario.fowlplay.common.entity.ai.control.BirdLookControl;
import aqario.fowlplay.common.entity.ai.control.BirdMoveControl;
import aqario.fowlplay.common.network.FowlPlayDebugInfoSender;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1330;
import net.minecraft.class_1335;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_4141;
import net.minecraft.class_4174;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public abstract class BirdEntity
extends class_1429 {
    private boolean ambient;
    private int eatingTime;
    protected int idleAnimationChance;
    protected int callChance;
    protected int songChance;

    protected BirdEntity(class_1299<? extends BirdEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5952(true);
        this.field_6207 = this.createMoveControl();
        this.field_6206 = new BirdLookControl((class_1308)this, 85);
        this.idleAnimationChance = this.field_5974.method_43048(this.getIdleAnimationDelay()) - this.getIdleAnimationDelay();
        this.callChance = this.field_5974.method_43048(this.getCallDelay()) - this.getCallDelay();
        this.songChance = this.field_5974.method_43048(this.getSongDelay()) - this.getSongDelay();
    }

    public static class_5132.class_5133 createBirdAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23719, (double)0.2f);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.method_36456(world.method_8409().method_43057() * 360.0f);
        this.method_5636(this.method_36454());
        this.method_5847(this.method_36454());
        if (this.method_5864().method_5891() == CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup) {
            this.setAmbient(true);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("ambient", this.ambient);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("ambient")) {
            this.setAmbient(nbt.method_10577("ambient"));
        } else {
            this.setAmbient(this.method_5864().method_5891() == CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup);
        }
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    protected void setAmbient(boolean ambient) {
        this.ambient = ambient;
    }

    public boolean method_5974(double distanceSquared) {
        return this.isAmbient() && !this.method_5947() && !this.method_16914();
    }

    public int method_5945() {
        return 8;
    }

    public boolean method_18397(class_1799 stack) {
        class_1304 equipmentSlot = this.method_32326(stack);
        if (!this.method_6118(equipmentSlot).method_7960()) {
            return false;
        }
        return equipmentSlot == class_1304.field_6173 && super.method_18397(stack);
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public boolean method_5939(class_1799 stack) {
        class_1799 heldStack = this.method_6118(class_1304.field_6173);
        return this.getFood().method_8093(stack) && !this.getFood().method_8093(heldStack);
    }

    public boolean shouldDropBeakItem(class_1799 stack) {
        return !stack.method_7960() && !this.getFood().method_8093(stack);
    }

    private void dropWithoutDelay(class_1799 stack, class_1297 thrower) {
        class_1542 item = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), stack);
        if (thrower != null) {
            item.method_6981(thrower);
        }
        this.method_37908().method_8649((class_1297)item);
    }

    protected void method_5949(class_1542 item) {
        class_1297 thrower = item.method_24921();
        class_1799 stack = item.method_6983();
        if (this.method_5939(stack)) {
            int i = stack.method_7947();
            if (i > 1) {
                this.dropWithoutDelay(stack.method_7971(i - 1), thrower);
            }
            this.method_5775(this.method_6118(class_1304.field_6173));
            this.method_29499(item);
            this.method_5673(class_1304.field_6173, stack.method_7971(1));
            this.method_25939(class_1304.field_6173);
            this.method_6103((class_1297)item, stack.method_7947());
            item.method_31472();
            this.eatingTime = 0;
            if (this.method_18868().method_18876(FowlPlayMemoryModuleType.SEES_FOOD.get(), class_4141.field_18456)) {
                this.method_18868().method_18875(FowlPlayMemoryModuleType.SEES_FOOD.get());
            }
        }
    }

    public boolean isBelowWaterline() {
        return this.method_5869() || this.method_5861(class_3486.field_15517) > (double)this.getWaterline();
    }

    public abstract float getWaterline();

    private boolean canEat(class_1799 stack) {
        return this.getFood().method_8093(stack);
    }

    public abstract class_1856 getFood();

    public boolean canHunt(class_1309 target) {
        return false;
    }

    public boolean shouldAttack(class_1309 target) {
        return false;
    }

    public boolean shouldAvoid(class_1309 entity) {
        return false;
    }

    public int getFleeRange(class_1309 target) {
        return Birds.isNotFlightless((class_1297)target) ? 32 : 16;
    }

    public boolean hasLowHealth() {
        return this.method_6032() <= this.method_6063() / 2.0f;
    }

    public boolean method_18395(class_1309 target) {
        return super.method_18395(target) && (this.shouldAttack(target) || this.canHunt(target));
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236 && this.method_5805()) {
            ++this.eatingTime;
            class_1799 stack = this.method_6118(class_1304.field_6173);
            if (this.canEat(stack)) {
                if (this.eatingTime > 40 && this.field_5974.method_43057() < 0.05f || this.eatingTime > 200) {
                    if (stack.method_7909().method_57347().method_57832(class_9334.field_50075)) {
                        this.method_6025(((class_4174)stack.method_7909().method_57347().method_57829(class_9334.field_50075)).comp_2491());
                    } else {
                        stack.method_7934(1);
                    }
                    class_1799 usedStack = stack.method_7910(this.method_37908(), (class_1309)this);
                    if (!usedStack.method_7960()) {
                        this.method_5673(class_1304.field_6173, usedStack);
                    }
                    this.method_5783(this.method_18869(stack), 1.0f, 1.0f);
                    this.method_37908().method_8421((class_1297)this, (byte)45);
                    this.eatingTime = 0;
                    return;
                }
                if (this.eatingTime > 20 && this.field_5974.method_43057() < 0.05f) {
                    this.method_5783(this.method_18869(stack), 1.0f, 1.0f);
                    this.method_37908().method_8421((class_1297)this, (byte)45);
                }
            } else if (this.shouldDropBeakItem(stack) && this.field_5974.method_43057() < 0.1f) {
                this.method_5775(this.method_6118(class_1304.field_6173));
                this.method_5673(class_1304.field_6173, class_1799.field_8037);
            }
        }
    }

    public void method_5711(byte status) {
        if (status == 45) {
            class_1799 food = this.method_6118(class_1304.field_6173);
            if (!food.method_7960()) {
                for (int i = 0; i < 8; ++i) {
                    class_243 vec3d = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.method_36454() * ((float)Math.PI / 180));
                    this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, food), this.method_23317() + this.method_5720().field_1352 / 2.0, this.method_23318(), this.method_23321() + this.method_5720().field_1350 / 2.0, vec3d.field_1352, vec3d.field_1351 + 0.05, vec3d.field_1350);
                }
            }
        } else {
            super.method_5711(status);
        }
    }

    public void method_5670() {
        super.method_5670();
        this.method_37908().method_16107().method_15396("birdBaseTick");
        if (this.method_5805() && this.field_5974.method_43048(1000) < this.callChance++) {
            this.resetCallDelay();
            if (this.canCall()) {
                this.playCallSound();
            }
        } else if (this.method_5805() && this.field_5974.method_43048(1000) < this.songChance++) {
            this.resetSongDelay();
            if (this.canSing()) {
                this.playSongSound();
            }
        }
        this.method_37908().method_16107().method_15407();
    }

    public void method_5773() {
        if (this.method_37908().method_8608()) {
            this.updateAnimations();
        }
        super.method_5773();
    }

    protected void updateAnimations() {
    }

    protected int getIdleAnimationDelay() {
        return 240;
    }

    protected void resetIdleAnimationDelay() {
        this.idleAnimationChance = -(this.getIdleAnimationDelay() + this.field_5974.method_39332(-200, 200));
    }

    protected boolean canCall() {
        return Birds.isDaytime(this);
    }

    protected boolean canSing() {
        return Birds.isDaytime(this) && this.method_24828() && !this.method_6109();
    }

    private void resetCallDelay() {
        this.callChance = -(this.getCallDelay() + this.field_5974.method_39332(-150, 150));
    }

    private void resetSongDelay() {
        this.songChance = -(this.getSongDelay() + this.field_5974.method_39332(-150, 150));
    }

    public final void playCallSound() {
        class_3414 call = this.getCallSound();
        if (call != null) {
            this.method_5783(call, this.getCallVolume(), this.method_6017());
        }
    }

    public final void playSongSound() {
        class_3414 song = this.getSongSound();
        if (song != null) {
            this.method_5783(song, this.getSongVolume(), this.method_6017());
        }
    }

    protected void method_6013(class_1282 damageSource) {
        this.resetCallDelay();
        this.resetSongDelay();
        class_3414 hurt = this.method_6011(damageSource);
        if (hurt != null) {
            this.method_5783(hurt, this.getCallVolume(), this.method_6017());
        }
    }

    public int getCallDelay() {
        return 240;
    }

    public int getSongDelay() {
        return 720;
    }

    @Nullable
    protected class_3414 getCallSound() {
        return null;
    }

    @Nullable
    protected class_3414 getSongSound() {
        return null;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return null;
    }

    @Nullable
    protected class_3414 method_6002() {
        return null;
    }

    public class_3414 method_18869(class_1799 stack) {
        return FowlPlaySoundEvents.ENTITY_BIRD_EAT.get();
    }

    protected float getCallVolume() {
        return 1.0f;
    }

    protected float getSongVolume() {
        return 1.0f;
    }

    public int method_20240() {
        return 100;
    }

    public int method_5978() {
        return 100;
    }

    public int method_5986() {
        return 135;
    }

    protected class_1335 createMoveControl() {
        return new BirdMoveControl(this);
    }

    protected class_1330 method_5963() {
        return new BirdBodyControl(this);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28631;
    }

    public float method_6017() {
        return (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.05f + 1.0f;
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
        FowlPlayDebugInfoSender.sendBirdDebugData(this);
    }
}

