/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_4168;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import org.jetbrains.annotations.Nullable;

public class ExtendedSchedule
extends SmartBrainSchedule {
    private final SmartBrainSchedule.Type type;
    private final Int2ObjectArrayMap<Supplier<class_4168>> timeline = new Int2ObjectArrayMap(0);
    private final ListMultimap<Integer, Consumer<class_1309>> callbacks = MultimapBuilder.hashKeys((int)0).arrayListValues().build();
    private boolean sortedTimeline = true;

    public ExtendedSchedule() {
        this(SmartBrainSchedule.Type.DAYTIME);
    }

    public ExtendedSchedule(SmartBrainSchedule.Type type) {
        this.type = type;
    }

    public ExtendedSchedule activityAt(int tick, class_4168 activity) {
        return this.activityAt(tick, () -> activity);
    }

    public ExtendedSchedule activityAt(int tick, Supplier<class_4168> activity) {
        this.timeline.put(tick, activity);
        this.sortedTimeline = false;
        return this;
    }

    public ExtendedSchedule doAt(int tick, Consumer<class_1309> callback) {
        this.callbacks.put((Object)tick, callback);
        return this;
    }

    public void scheduleTask(class_1309 brainOwner, int delay, Consumer<class_1309> task) {
        this.callbacks.put((Object)this.type.resolveDelay(brainOwner, delay), entity -> task.accept(brainOwner));
    }

    public void clearSchedule() {
        this.callbacks.clear();
        this.timeline.clear();
    }

    @Nullable
    public class_4168 tick(class_1309 brainOwner) {
        int tick = this.type.resolve(brainOwner);
        if (!this.callbacks.isEmpty()) {
            this.callbacks.get((Object)tick).forEach(consumer -> consumer.accept(brainOwner));
            if (this.type == SmartBrainSchedule.Type.AGE) {
                this.callbacks.removeAll((Object)tick);
            }
        }
        if (!this.timeline.isEmpty()) {
            if (!this.sortedTimeline) {
                this.sortTimeline();
            }
            int index = -1;
            class_4168 activity = null;
            for (Int2ObjectMap.Entry entry : this.timeline.int2ObjectEntrySet()) {
                ++index;
                if (entry.getIntKey() >= tick) {
                    if (entry.getIntKey() != tick) break;
                    activity = (class_4168)((Supplier)entry.getValue()).get();
                    break;
                }
                activity = (class_4168)((Supplier)entry.getValue()).get();
            }
            if (this.type == SmartBrainSchedule.Type.AGE && index + 1 >= this.timeline.size()) {
                this.timeline.clear();
            }
            return activity;
        }
        return null;
    }

    private void sortTimeline() {
        Int2ObjectArrayMap copy = new Int2ObjectArrayMap(this.timeline);
        int[] keys = copy.keySet().toArray(new int[0]);
        Arrays.sort(keys);
        this.timeline.clear();
        for (int key : keys) {
            this.timeline.put(key, (Object)((Supplier)copy.get(key)));
        }
        this.sortedTimeline = true;
    }
}

