/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.util;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.DSL;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.level.entity.SpawnPlacementsRegistry;
import java.util.function.Supplier;
import net.minecraft.class_1208;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_4048;
import net.minecraft.class_5132;
import net.minecraft.class_7696;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_9064;
import net.minecraft.class_9066;
import net.minecraft.class_9168;
import org.jetbrains.annotations.Nullable;

public class EntityTypeBuilder<T extends class_1297> {
    private final class_1299.class_4049<T> factory;
    private final class_1311 spawnGroup;
    private ImmutableSet<class_2248> canSpawnInside = ImmutableSet.of();
    private boolean saveable = true;
    private boolean summonable = true;
    private boolean fireImmune;
    private boolean spawnableFarFromPlayer;
    private int maxTrackingRange = 5;
    private int trackingTickInterval = 3;
    private class_4048 dimensions = class_4048.method_18384((float)0.6f, (float)1.8f);
    private float spawnBoxScale = 1.0f;
    private class_9066.class_9067 attachments = class_9066.method_55673();
    private class_7699 requiredFeatures = class_7701.field_40182;
    @Nullable
    private Supplier<class_5132.class_5133> attributeBuilder;
    private class_9168 location;
    private class_2902.class_2903 heightmap;
    private class_1317.class_4306<T> spawnPredicate;

    private EntityTypeBuilder(class_1299.class_4049<T> factory, class_1311 spawnGroup) {
        this.factory = factory;
        this.spawnGroup = spawnGroup;
        this.spawnableFarFromPlayer = spawnGroup == class_1311.field_6294 || spawnGroup == class_1311.field_17715;
    }

    public static <T extends class_1297> EntityTypeBuilder<T> create(class_1299.class_4049<T> factory, class_1311 spawnGroup) {
        return new EntityTypeBuilder<T>(factory, spawnGroup);
    }

    public static <T extends class_1297> EntityTypeBuilder<T> create(class_1311 spawnGroup) {
        return new EntityTypeBuilder<T>((type, world) -> null, spawnGroup);
    }

    public EntityTypeBuilder<T> dimensions(float width, float height) {
        this.dimensions = class_4048.method_18384((float)width, (float)height);
        return this;
    }

    public EntityTypeBuilder<T> spawnBoxScale(float spawnBoxScale) {
        this.spawnBoxScale = spawnBoxScale;
        return this;
    }

    public EntityTypeBuilder<T> eyeHeight(float eyeHeight) {
        this.dimensions = this.dimensions.method_55685(eyeHeight);
        return this;
    }

    public EntityTypeBuilder<T> passengerAttachments(float ... offsetYs) {
        for (float f : offsetYs) {
            this.attachments = this.attachments.method_55682(class_9064.field_47743, 0.0f, f, 0.0f);
        }
        return this;
    }

    public EntityTypeBuilder<T> passengerAttachments(class_243 ... passengerAttachments) {
        for (class_243 vec3d : passengerAttachments) {
            this.attachments = this.attachments.method_55683(class_9064.field_47743, vec3d);
        }
        return this;
    }

    public EntityTypeBuilder<T> vehicleAttachment(class_243 vehicleAttachment) {
        return this.attachment(class_9064.field_47744, vehicleAttachment);
    }

    public EntityTypeBuilder<T> vehicleAttachment(float offsetY) {
        return this.attachment(class_9064.field_47744, 0.0f, -offsetY, 0.0f);
    }

    public EntityTypeBuilder<T> nameTagAttachment(float offsetY) {
        return this.attachment(class_9064.field_47745, 0.0f, offsetY, 0.0f);
    }

    public EntityTypeBuilder<T> attachment(class_9064 type, float offsetX, float offsetY, float offsetZ) {
        this.attachments = this.attachments.method_55682(type, offsetX, offsetY, offsetZ);
        return this;
    }

    public EntityTypeBuilder<T> attachment(class_9064 type, class_243 offset) {
        this.attachments = this.attachments.method_55683(type, offset);
        return this;
    }

    public EntityTypeBuilder<T> disableSummon() {
        this.summonable = false;
        return this;
    }

    public EntityTypeBuilder<T> disableSaving() {
        this.saveable = false;
        return this;
    }

    public EntityTypeBuilder<T> makeFireImmune() {
        this.fireImmune = true;
        return this;
    }

    public EntityTypeBuilder<T> allowSpawningInside(class_2248 ... blocks) {
        this.canSpawnInside = ImmutableSet.copyOf((Object[])blocks);
        return this;
    }

    public EntityTypeBuilder<T> spawnableFarFromPlayer() {
        this.spawnableFarFromPlayer = true;
        return this;
    }

    public EntityTypeBuilder<T> maxTrackingRange(int maxTrackingRange) {
        this.maxTrackingRange = maxTrackingRange;
        return this;
    }

    public EntityTypeBuilder<T> trackingTickInterval(int trackingTickInterval) {
        this.trackingTickInterval = trackingTickInterval;
        return this;
    }

    public EntityTypeBuilder<T> requires(class_7696 ... features) {
        this.requiredFeatures = class_7701.field_40180.method_45390(features);
        return this;
    }

    public EntityTypeBuilder<T> attributes(Supplier<class_5132.class_5133> attributeBuilder) {
        this.attributeBuilder = attributeBuilder;
        return this;
    }

    public EntityTypeBuilder<T> spawnRestriction(class_9168 location, class_2902.class_2903 heightmap, class_1317.class_4306<T> spawnPredicate) {
        this.location = location;
        this.heightmap = heightmap;
        this.spawnPredicate = spawnPredicate;
        return this;
    }

    public class_1299<T> build() {
        return this.build(null);
    }

    public class_1299<T> build(String id) {
        class_1299 type;
        if (this.saveable) {
            class_156.method_29187((DSL.TypeReference)class_1208.field_5723, (String)id);
        }
        if ((type = new class_1299(this.factory, this.spawnGroup, this.saveable, this.summonable, this.fireImmune, this.spawnableFarFromPlayer, this.canSpawnInside, this.dimensions.method_55684(this.attachments), this.spawnBoxScale, this.maxTrackingRange, this.trackingTickInterval, this.requiredFeatures)).method_31794().isAssignableFrom(class_1309.class) && this.attributeBuilder != null) {
            EntityAttributeRegistry.register(() -> type, this.attributeBuilder);
        }
        if (type.method_31794().isAssignableFrom(class_1308.class) && this.spawnPredicate != null) {
            SpawnPlacementsRegistry.register(() -> type, (class_9168)this.location, (class_2902.class_2903)this.heightmap, this.spawnPredicate);
        }
        return type;
    }
}

