/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage;

import io.github.chickensaysbak.chatimage.core.ChatImage;
import io.github.chickensaysbak.chatimage.core.media.Media;
import java.util.UUID;
import net.kyori.adventure.text.Component;

public class ChatImageAPI {
    private ChatImageAPI() {
    }

    public static boolean isHidingImages(UUID uuid) {
        return !ChatImage.getInstance().getPlayerPreferences().isShowingImages(uuid);
    }

    public static Component createMediaFromURL(String url, String text, boolean smooth, boolean trim, int width, int height) {
        Media media = ChatImage.getInstance().loadMedia(url, width, height, smooth, trim, false);
        if (media == null) {
            return null;
        }
        return media.formatFor(null, text, false);
    }

    public static Component createMediaFromURL(String url, String text, boolean smooth, boolean trim, int width) {
        int height = ChatImage.getInstance().getSettings().getMaxHeight();
        return ChatImageAPI.createMediaFromURL(url, text, smooth, trim, width, height);
    }

    public static Component createMediaFromURL(String url, String text, boolean smooth, boolean trim) {
        int width = ChatImage.getInstance().getSettings().getMaxWidth();
        return ChatImageAPI.createMediaFromURL(url, text, smooth, trim, width);
    }

    public static Component createMediaFromURL(String url, String text, boolean smooth) {
        boolean trim = ChatImage.getInstance().getSettings().isTrimTransparency();
        return ChatImageAPI.createMediaFromURL(url, text, smooth, trim);
    }

    public static Component createMediaFromURL(String url, String text) {
        boolean smooth = ChatImage.getInstance().getSettings().isSmoothRender();
        return ChatImageAPI.createMediaFromURL(url, text, smooth);
    }

    public static Component createMediaFromURL(String url) {
        return ChatImageAPI.createMediaFromURL(url, null);
    }

    public static Component getSavedMedia(String name, String text) {
        Media media = ChatImage.getInstance().getSavedImages().getMedia(name);
        if (media == null) {
            return null;
        }
        return media.formatFor(null, text, false);
    }

    public static Component getSavedMedia(String name) {
        return ChatImageAPI.getSavedMedia(name, null);
    }
}

