/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.bungee;

import io.github.chickensaysbak.chatimage.bungee.CommandBungee;
import io.github.chickensaysbak.chatimage.bungee.PlayerBungee;
import io.github.chickensaysbak.chatimage.bungee.YamlBungee;
import io.github.chickensaysbak.chatimage.bungeecord.Metrics;
import io.github.chickensaysbak.chatimage.charts.DrilldownPie;
import io.github.chickensaysbak.chatimage.charts.SimplePie;
import io.github.chickensaysbak.chatimage.charts.SingleLineChart;
import io.github.chickensaysbak.chatimage.core.ChatImage;
import io.github.chickensaysbak.chatimage.core.adapters.CommandAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.PlayerAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.PluginAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.YamlAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.CustomClickEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import net.md_5.bungee.event.EventHandler;

public class PluginBungee
extends Plugin
implements Listener,
PluginAdapter {
    private ChatImage core;
    private Metrics bStats;

    public void onEnable() {
        this.bStats = new Metrics(this, 12674);
        this.core = new ChatImage(this);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
    }

    public void onDisable() {
        this.core.onDisable();
    }

    @EventHandler
    public void onJoin(PostLoginEvent event) {
        this.core.onJoin(new PlayerBungee(event.getPlayer()));
    }

    @EventHandler(priority=32)
    public void onChat(ChatEvent event) {
        ProxiedPlayer player;
        boolean cancelEvent;
        Connection connection;
        if (!event.isCancelled() && !event.isCommand() && (connection = event.getSender()) instanceof ProxiedPlayer && (cancelEvent = this.core.onChat(new PlayerBungee(player = (ProxiedPlayer)connection), Component.text(event.getMessage())))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onClick(CustomClickEvent event) {
        this.core.onClick(new PlayerBungee(event.getPlayer()), event.getId());
    }

    @Override
    public void registerCommand(CommandAdapter command) {
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new CommandBungee(command));
    }

    @Override
    public InputStream getResource(String name) {
        return this.getResourceAsStream(name);
    }

    @Override
    public void saveResource(String resourcePath) {
        File dataFolder = this.getDataFolder();
        File file = this.getFile();
        Logger logger = this.getLogger();
        if (resourcePath == null || resourcePath.equals("")) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        InputStream in = this.getResource(resourcePath = resourcePath.replace('\\', '/'));
        if (in == null) {
            throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found in " + String.valueOf(file));
        }
        File outFile = new File(dataFolder, resourcePath);
        int lastIndex = resourcePath.lastIndexOf(47);
        File outDir = new File(dataFolder, resourcePath.substring(0, Math.max(lastIndex, 0)));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            if (!outFile.exists()) {
                int len;
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not save " + outFile.getName() + " to " + String.valueOf(outFile), ex);
        }
    }

    @Override
    public void sendConsoleMessage(Component message) {
        this.getProxy().getConsole().sendMessage(BungeeComponentSerializer.get().serialize(message));
    }

    @Override
    public PlayerAdapter getPlayer(UUID uuid) {
        ProxiedPlayer player = this.getProxy().getPlayer(uuid);
        if (player == null) {
            return null;
        }
        return new PlayerBungee(player);
    }

    @Override
    public PlayerAdapter getPlayer(String name) {
        ProxiedPlayer player = this.getProxy().getPlayer(name);
        if (player == null) {
            return null;
        }
        return new PlayerBungee(player);
    }

    @Override
    public List<PlayerAdapter> getOnlinePlayers() {
        return this.getProxy().getPlayers().stream().map(PlayerBungee::new).collect(Collectors.toList());
    }

    @Override
    public YamlAdapter loadYaml(File file) {
        try {
            return new YamlBungee(this, ConfigurationProvider.getProvider(YamlConfiguration.class).load(file));
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public void runAsyncTaskLater(Runnable task, long ticks) {
        this.getProxy().getScheduler().schedule((Plugin)this, task, ticks * 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void runTaskLater(Runnable task, long ticks) {
        this.runAsyncTaskLater(task, ticks);
    }

    @Override
    public void publishStat(String id, String value) {
        this.bStats.addCustomChart(new SimplePie(id, () -> value));
    }

    @Override
    public void publishStat(String id, int value) {
        this.bStats.addCustomChart(new SingleLineChart(id, () -> value));
    }

    @Override
    public void publishStat(String id, Map<String, Map<String, Integer>> value) {
        this.bStats.addCustomChart(new DrilldownPie(id, () -> value));
    }

    @Override
    public String setPlaceholders(UUID uuid, String text, boolean brackets) {
        return text;
    }

    @Override
    public boolean hasDialogSupport() {
        return true;
    }
}

