/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.core;

import io.github.chickensaysbak.chatimage.core.Filtration;
import io.github.chickensaysbak.chatimage.core.GifHandler;
import io.github.chickensaysbak.chatimage.core.adapters.PlayerAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.PluginAdapter;
import io.github.chickensaysbak.chatimage.core.commands.ChatImageCommand;
import io.github.chickensaysbak.chatimage.core.commands.HideImagesCommand;
import io.github.chickensaysbak.chatimage.core.commands.ShowImagesCommand;
import io.github.chickensaysbak.chatimage.core.loaders.Loadable;
import io.github.chickensaysbak.chatimage.core.loaders.PlayerPreferences;
import io.github.chickensaysbak.chatimage.core.loaders.SavedMedia;
import io.github.chickensaysbak.chatimage.core.loaders.Settings;
import io.github.chickensaysbak.chatimage.core.media.Gif;
import io.github.chickensaysbak.chatimage.core.media.HidableImage;
import io.github.chickensaysbak.chatimage.core.media.Image;
import io.github.chickensaysbak.chatimage.core.media.Media;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class ChatImage {
    private static ChatImage instance;
    private PluginAdapter plugin;
    private GifHandler gifHandler;
    private Filtration filtration;
    private Settings settings;
    private PlayerPreferences playerPreferences;
    private SavedMedia savedMedia;
    private ArrayList<Loadable> loaders = new ArrayList();
    private HashMap<String, Long> lastSent = new HashMap();
    private ArrayList<UUID> recordedPlayerLocale = new ArrayList();
    public static String USER_AGENT;

    public ChatImage(PluginAdapter plugin) {
        instance = this;
        this.plugin = plugin;
        this.gifHandler = new GifHandler(plugin);
        this.filtration = new Filtration(plugin);
        this.settings = new Settings(plugin);
        this.playerPreferences = new PlayerPreferences(plugin);
        this.savedMedia = new SavedMedia(plugin);
        this.loaders.addAll(Arrays.asList(this.settings, this.playerPreferences, this.savedMedia));
        plugin.registerCommand(new ChatImageCommand(plugin));
        plugin.registerCommand(new HideImagesCommand(plugin));
        plugin.registerCommand(new ShowImagesCommand(plugin));
    }

    public void onDisable() {
        if (this.playerPreferences.isSaveQueued()) {
            this.playerPreferences.saveFile();
        }
    }

    public void onJoin(PlayerAdapter player) {
        UUID uuid = player.getUniqueId();
        if (this.recordedPlayerLocale.contains(uuid)) {
            return;
        }
        this.plugin.runTaskLater(() -> {
            HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(player.getLocale().toLowerCase(), 1);
            map.put(this.settings.getLanguageDefault(), entry);
            this.plugin.publishStat("locale", map);
            if (!this.recordedPlayerLocale.contains(uuid)) {
                this.recordedPlayerLocale.add(uuid);
            }
        }, 20L);
    }

    public boolean onChat(PlayerAdapter player, Component message) {
        return this.processChatLinks(message, player.getUniqueId().toString(), player.hasPermission("chatimage.use"));
    }

    public void onClick(PlayerAdapter player, String id) {
        if (id.equals("chatimage:close_gif")) {
            this.gifHandler.closeGif(player);
        } else if (id.startsWith("chatimage:open_gif_")) {
            String[] parts = id.split("_");
            int gifID = Integer.parseInt(parts[2]);
            String text = parts.length >= 4 ? Gif.decodeText(parts[3]) : null;
            Component component = text != null && !text.isEmpty() ? (Component)MiniMessage.miniMessage().deserialize(text) : null;
            this.gifHandler.playGif(player, this.gifHandler.getGif(gifID), component);
        }
    }

    public boolean processChatLinks(Component message, String id, boolean hasPermission) {
        boolean dontRender;
        int cooldown = this.settings.getCooldown();
        boolean strictCooldown = this.settings.isStrictCooldown();
        boolean filterExplicitContent = this.settings.isFilterExplicitContent();
        boolean removeExplicitContent = this.settings.isRemoveExplicitContent();
        boolean underCooldown = cooldown > 0 && this.lastSent.containsKey(id) && (System.currentTimeMillis() - this.lastSent.get(id)) / 1000L < (long)cooldown;
        boolean underRegularCooldown = !strictCooldown && underCooldown;
        boolean bl = dontRender = !hasPermission || underRegularCooldown;
        if (!removeExplicitContent && dontRender) {
            return false;
        }
        String url = ChatImage.findURL(message);
        if (url == null) {
            return false;
        }
        if (removeExplicitContent && filterExplicitContent && this.filtration.hasExplicitContent(url)) {
            return true;
        }
        if (dontRender) {
            return false;
        }
        this.lastSent.put(id, System.currentTimeMillis());
        if (strictCooldown && underCooldown) {
            return false;
        }
        this.plugin.runAsyncTaskLater(() -> {
            if (!removeExplicitContent && filterExplicitContent && this.filtration.hasExplicitContent(url)) {
                return;
            }
            Media media = this.loadMedia(url, null, null, null, null, true);
            if (media != null) {
                this.plugin.getOnlinePlayers().forEach(p -> p.sendMessage(media.formatFor((PlayerAdapter)p, null, false)));
            }
        }, 1L);
        return false;
    }

    public void sendUIMessage(UUID recipient, String key, TagResolver ... variables) {
        PlayerAdapter player = recipient != null ? this.plugin.getPlayer(recipient) : null;
        String locale = player != null ? player.getLocale() : this.settings.getLanguageDefault();
        Component message = this.getUIMessage(key, locale, variables);
        if (message == null) {
            return;
        }
        if (recipient != null) {
            if (player != null) {
                player.sendMessage(message);
            }
        } else {
            this.plugin.sendConsoleMessage(message);
        }
    }

    public Component getUIMessage(String key, String locale, TagResolver ... variables) {
        String message = this.settings.getMessage(key, locale);
        if (message == null) {
            return null;
        }
        return MiniMessage.miniMessage().deserialize(message, variables);
    }

    public void reload() {
        for (Loadable loadable : this.loaders) {
            loadable.reload();
        }
    }

    public static String findURL(Component text) {
        String[] words;
        String stripped = PlainTextComponentSerializer.plainText().serialize(text);
        for (String word : words = stripped.split(" ")) {
            if (!word.startsWith("http")) continue;
            return word;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Media loadMedia(String url, Integer width, Integer height, Boolean smooth, Boolean trim, boolean user) {
        if (url.toLowerCase().contains("tenor.com/view")) {
            url = this.extractDirectTenorUrl(url);
        }
        if (smooth == null) {
            smooth = this.settings.isSmoothRender();
        }
        if (trim == null) {
            trim = this.settings.isTrimTransparency();
        }
        try {
            URLConnection connection = new URI(url).toURL().openConnection();
            connection.addRequestProperty("User-Agent", USER_AGENT);
            if ("image/gif".equalsIgnoreCase(connection.getContentType())) {
                GifHandler.Gif gif;
                if (width == null) {
                    width = this.settings.getMaxGifWidth();
                }
                if (height == null) {
                    height = this.settings.getMaxGifHeight();
                }
                if ((gif = this.gifHandler.loadGif(connection, new Dimension(width, height), smooth)) != null) {
                    return new Gif(gif);
                }
            }
            try (InputStream in = connection.getInputStream();){
                BufferedImage img = ImageIO.read(in);
                if (img == null) {
                    if (this.settings.isDebug()) {
                        this.plugin.getLogger().warning("ChatImage Debugger - Error loading image: Null BufferedImage");
                        this.plugin.getLogger().warning("URL: " + url);
                    }
                    Media media = null;
                    return media;
                }
                if (width == null) {
                    width = this.settings.getMaxWidth();
                }
                if (height == null) {
                    height = this.settings.getMaxHeight();
                }
                Image image = user ? new HidableImage(url, img) : new Image(img, new Dimension(width, height), smooth, trim);
                return image;
            }
        }
        catch (IOException | URISyntaxException e) {
            if (!this.settings.isDebug()) return null;
            this.plugin.getLogger().warning("ChatImage Debugger - Error loading media");
            this.plugin.getLogger().warning("URL: " + url);
            this.plugin.getLogger().log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    private String extractDirectTenorUrl(String url) {
        Document doc;
        try {
            doc = Jsoup.connect(url).userAgent(USER_AGENT).get();
        }
        catch (IOException e) {
            if (this.settings.isDebug()) {
                this.plugin.getLogger().warning("ChatImage Debugger - Error extracting Tenor URL");
                this.plugin.getLogger().warning("URL: " + url);
                this.plugin.getLogger().log(Level.WARNING, e.getMessage(), e);
            }
            return url;
        }
        Element meta = doc.selectFirst("meta[property=og:image]");
        if (meta != null) {
            return meta.attr("content");
        }
        meta = doc.selectFirst("meta[property=twitter:image]");
        if (meta != null) {
            return meta.attr("content");
        }
        if (this.settings.isDebug()) {
            this.plugin.getLogger().warning("ChatImage Debugger - Error extracting Tenor URL");
            this.plugin.getLogger().warning("URL: " + url);
        }
        return url;
    }

    public static ChatImage getInstance() {
        return instance;
    }

    public GifHandler getGifHandler() {
        return this.gifHandler;
    }

    public Filtration getFiltration() {
        return this.filtration;
    }

    public PluginAdapter getPlugin() {
        return this.plugin;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public PlayerPreferences getPlayerPreferences() {
        return this.playerPreferences;
    }

    public SavedMedia getSavedImages() {
        return this.savedMedia;
    }

    static {
        USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:25.0) Gecko/20100101 Firefox/25.0";
    }
}

