/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.core;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.chickensaysbak.chatimage.core.ChatImage;
import io.github.chickensaysbak.chatimage.core.adapters.PluginAdapter;
import io.github.chickensaysbak.chatimage.core.loaders.Settings;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Filtration {
    private PluginAdapter plugin;
    private HashMap<String, JsonObject> explicitCache = new HashMap();

    Filtration(PluginAdapter plugin) {
        this.plugin = plugin;
    }

    public boolean hasExplicitContent(String url) {
        boolean cached;
        JsonObject json;
        Logger logger;
        boolean debug;
        block14: {
            ChatImage chatImage = ChatImage.getInstance();
            Settings settings = chatImage.getSettings();
            debug = settings.isDebug();
            logger = this.plugin.getLogger();
            json = this.explicitCache.getOrDefault(url, null);
            cached = true;
            if (json == null) {
                cached = false;
                try {
                    HttpClient client = HttpClient.newHttpClient();
                    String body = "--$bound%\r\nContent-Disposition: form-data; name=\"url\"\r\n\r\n" + url + "\r\n--$bound%--\r\n";
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://demo.api4ai.cloud/nsfw/v1/results")).header("Content-Type", "multipart/form-data; boundary=$bound%").POST(HttpRequest.BodyPublishers.ofString(body)).build();
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    int httpCode = response.statusCode();
                    if (httpCode == 200) {
                        JsonObject newJson = new JsonParser().parse(response.body()).getAsJsonObject();
                        if (newJson != null) {
                            JsonObject status = (newJson = newJson.getAsJsonArray("results").get(0).getAsJsonObject()).getAsJsonObject("status");
                            String statusCode = status.get("code").getAsString();
                            if (statusCode.equalsIgnoreCase("ok")) {
                                json = newJson;
                                this.explicitCache.put(url, newJson);
                            } else if (debug) {
                                logger.warning("ChatImage Debugger - API error");
                                logger.warning("URL: " + url);
                                logger.warning("ERROR: " + statusCode + " - " + status.get("message").getAsString());
                                return false;
                            }
                        } else if (debug) {
                            logger.warning("ChatImage Debugger - Null json");
                            logger.warning("URL: " + url);
                            logger.warning("RESPONSE: " + String.valueOf(response));
                        }
                    } else if (debug) {
                        logger.warning("ChatImage Debugger - Bad http response");
                        logger.warning("URL: " + url);
                        logger.warning("HTTP CODE: " + httpCode);
                    }
                }
                catch (IOException | InterruptedException e) {
                    if (!debug) break block14;
                    logger.warning("ChatImage Debugger - Attempted explicit content filtration");
                    logger.warning("URL: " + url);
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        if (json != null) {
            double nsfwConfidence = json.getAsJsonArray("entities").get(0).getAsJsonObject().getAsJsonObject("classes").get("nsfw").getAsDouble();
            if (debug) {
                logger.info("ChatImage Debugger - Explicit content filtration");
                logger.info("URL: " + url);
                logger.info("RESPONSE: " + String.valueOf(json));
                logger.info("CACHED: " + cached);
            }
            return nsfwConfidence > 0.5;
        }
        return false;
    }
}

