/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.chickensaysbak.chatimage.core.ChatImage;
import io.github.chickensaysbak.chatimage.core.ImageMaker;
import io.github.chickensaysbak.chatimage.core.adapters.PlayerAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.PluginAdapter;
import io.github.chickensaysbak.chatimage.lib.com.madgag.gif.fmsware.GifDecoder;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class GifHandler {
    private PluginAdapter plugin;
    private LinkedHashMap<String, Gif> gifs = new LinkedHashMap();
    private HashMap<UUID, Gif> playersViewing = new HashMap();

    GifHandler(PluginAdapter plugin) {
        this.plugin = plugin;
    }

    public Gif getGif(int id) {
        if (this.gifs.size() <= id) {
            return null;
        }
        return new ArrayList<Gif>(this.gifs.values()).get(id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Gif loadGif(URLConnection connection, Dimension dim, boolean smooth) {
        String url = connection.getURL().toString();
        String key = url + " " + smooth + " " + dim.getWidth() + " " + dim.getHeight();
        if (this.gifs.containsKey(key)) {
            return this.gifs.get(key);
        }
        boolean debug = ChatImage.getInstance().getSettings().isDebug();
        try {
            GifDecoder decoder = new GifDecoder();
            try (InputStream in = connection.getInputStream();){
                int status = decoder.read(in);
                if (status != 0) {
                    if (debug) {
                        this.plugin.getLogger().warning("ChatImage Debugger - Error parsing GIF");
                        this.plugin.getLogger().warning("URL: " + url);
                        this.plugin.getLogger().warning("Status: " + status);
                    }
                    Gif gif = null;
                    return gif;
                }
            }
            ArrayList<Component> frames = new ArrayList<Component>();
            ArrayList<Long> tickDelays = new ArrayList<Long>();
            long gifDuration = 0L;
            long tickDuration = 0L;
            for (int i = 0; i < decoder.getFrameCount() && i < 2000; ++i) {
                long targetTickDuration = Math.round((double)(gifDuration += (long)decoder.getDelay(i)) / 50.0);
                long tickDelay = targetTickDuration - tickDuration;
                tickDuration = targetTickDuration;
                if (tickDelay <= 0L) continue;
                frames.add(ImageMaker.createChatImage(decoder.getFrame(i), dim, smooth, false));
                tickDelays.add(tickDelay);
            }
            if (frames.isEmpty()) {
                return null;
            }
            Gif gif = new Gif(this.gifs.size(), frames, tickDelays);
            this.gifs.put(key, gif);
            return gif;
        }
        catch (IOException | NullPointerException e) {
            if (!debug) return null;
            this.plugin.getLogger().warning("ChatImage Debugger - Error loading GIF");
            this.plugin.getLogger().warning("URL: " + url);
            this.plugin.getLogger().log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public Gif loadSavedGif(String name, JsonObject json) {
        MiniMessage mm = MiniMessage.miniMessage();
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        SerializableGif sGif = (SerializableGif)gson.fromJson((JsonElement)json, SerializableGif.class);
        List<Component> frames = sGif.frames.stream().map(mm::deserialize).toList();
        if (frames.isEmpty()) {
            return null;
        }
        Gif gif = new Gif(this.gifs.size(), frames, sGif.tickDelays);
        this.gifs.put(name, gif);
        return gif;
    }

    public void playGif(PlayerAdapter player, Gif gif, Component text) {
        if (gif == null) {
            return;
        }
        this.playersViewing.put(player.getUniqueId(), gif);
        gif.play(player, 0, text);
    }

    public void closeGif(PlayerAdapter player) {
        this.playersViewing.remove(player.getUniqueId());
        this.plugin.runTaskLater(player::closeDialog, 1L);
    }

    public class Gif {
        private int id;
        private List<Component> frames;
        private List<Long> tickDelays;

        Gif(int id, List<Component> frames, List<Long> tickDelays) {
            this.id = id;
            this.frames = frames;
            this.tickDelays = tickDelays;
        }

        public int getID() {
            return this.id;
        }

        void play(PlayerAdapter player, int frameNum, Component text) {
            if (!this.equals(GifHandler.this.playersViewing.get(player.getUniqueId()))) {
                return;
            }
            player.sendGifFrame(this.frames.get(frameNum), text);
            int nextFrameNum = frameNum < this.frames.size() - 1 ? frameNum + 1 : 0;
            GifHandler.this.plugin.runAsyncTaskLater(() -> this.play(player, nextFrameNum, text), this.tickDelays.get(frameNum));
        }

        public String toJson() {
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            return gson.toJson((Object)new SerializableGif(GifHandler.this, this.frames, this.tickDelays));
        }
    }

    public class SerializableGif {
        private List<String> frames;
        private List<Long> tickDelays;

        SerializableGif(GifHandler this$0, List<Component> frames, List<Long> tickDelays) {
            MiniMessage mm = MiniMessage.miniMessage();
            this.frames = frames.stream().map(mm::serialize).toList();
            this.tickDelays = tickDelays;
        }
    }
}

