/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.core;

import com.mortennobel.imagescaling.ResampleFilters;
import com.mortennobel.imagescaling.ResampleOp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class ImageMaker {
    public static final String SOLID_PIXEL = "\u2588";
    public static final String TRANSPARENT_PIXEL = "\u2592";
    public static final int MID_ALPHA = 128;

    private ImageMaker() {
    }

    public static Component addText(Component chatImage, String text) {
        MiniMessage mm = MiniMessage.miniMessage();
        ArrayList<Object> newChildren = new ArrayList<Object>();
        String[] lines = text.split("(?i)<newline>|<br>|\\n");
        int currentLine = 0;
        for (Component child : chatImage.children()) {
            if (currentLine < lines.length && child.equals(Component.newline())) {
                String currentText = " " + lines[currentLine];
                newChildren.add(mm.deserialize(currentText));
                ++currentLine;
            }
            newChildren.add(child);
        }
        return chatImage.children(newChildren);
    }

    public static Component createChatImage(BufferedImage original, Dimension maximum, boolean smooth, boolean trim) {
        boolean hasPartialTransparency = ImageMaker.hasPartialTransparency(original);
        BufferedImage image = original;
        if (trim) {
            image = ImageMaker.trimTransparency(image, hasPartialTransparency);
        }
        Dimension scaled = ImageMaker.getScaledDimension(image, maximum);
        BufferedImage bufferedImage = image = smooth ? ImageMaker.resizeImageSmooth(image, scaled) : ImageMaker.resizeImage(image, scaled);
        if (trim) {
            image = ImageMaker.trimTransparency(image, hasPartialTransparency);
        }
        return ImageMaker.convertToText(image, hasPartialTransparency);
    }

    private static Component convertToText(BufferedImage image, boolean hasPartialTransparency) {
        Component result = Component.empty();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                int alpha = new Color(rgb, true).getAlpha();
                Component pixel = ImageMaker.isPixelVisible(alpha, hasPartialTransparency) && ImageMaker.isPixelNormal(rgb) ? Component.text(alpha > 128 ? SOLID_PIXEL : TRANSPARENT_PIXEL).color(TextColor.color(rgb & 0xFFFFFF)) : ((TextComponent)Component.text(" ").decorate(TextDecoration.BOLD)).append(Component.text(" ").decoration(TextDecoration.BOLD, false));
                result = result.append(pixel);
            }
            if (y >= image.getHeight() - 1) continue;
            result = result.appendNewline();
        }
        return result;
    }

    private static BufferedImage trimTransparency(BufferedImage original, boolean hasPartialTransparency) {
        int height;
        int width = original.getWidth();
        int top = height = original.getHeight();
        int bottom = 0;
        int left = width;
        int right = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = original.getRGB(x, y);
                int alpha = new Color(rgb, true).getAlpha();
                if (!ImageMaker.isPixelVisible(alpha, hasPartialTransparency) || !ImageMaker.isPixelNormal(rgb)) continue;
                top = Math.min(top, y);
                bottom = Math.max(bottom, y);
                left = Math.min(left, x);
                right = Math.max(right, x);
            }
        }
        int newWidth = right - left + 1;
        int newHeight = bottom - top + 1;
        return original.getSubimage(left, top, newWidth, newHeight);
    }

    private static BufferedImage resizeImageSmooth(BufferedImage original, Dimension dimension) {
        int width = (int)dimension.getWidth();
        int height = (int)dimension.getHeight();
        try {
            ResampleOp resizeOp = new ResampleOp(width, height);
            resizeOp.setFilter(ResampleFilters.getLanczos3Filter());
            return resizeOp.filter(original, null);
        }
        catch (RuntimeException e) {
            return ImageMaker.resizeImage(original, dimension);
        }
    }

    private static BufferedImage resizeImage(BufferedImage original, Dimension dimension) {
        double width = dimension.getWidth();
        double height = dimension.getHeight();
        AffineTransform af = new AffineTransform();
        af.scale(width / (double)original.getWidth(), height / (double)original.getHeight());
        return new AffineTransformOp(af, 1).filter(original, null);
    }

    private static Dimension getScaledDimension(BufferedImage original, Dimension bounds) {
        int original_width = original.getWidth();
        int original_height = original.getHeight();
        int bound_width = bounds.width;
        int bound_height = bounds.height;
        int new_width = original_width;
        int new_height = original_height;
        if (original_width > bound_width) {
            new_width = bound_width;
            new_height = new_width * original_height / original_width;
        }
        if (new_height > bound_height) {
            new_height = bound_height;
            new_width = new_height * original_width / original_height;
        }
        return new Dimension(new_width, new_height);
    }

    private static boolean hasPartialTransparency(BufferedImage original) {
        double THRESHOLD = 0.05;
        int midAlphaPixels = 0;
        int visiblePixels = 0;
        for (int y = 0; y < original.getHeight(); ++y) {
            for (int x = 0; x < original.getWidth(); ++x) {
                int rgb = original.getRGB(x, y);
                int alpha = new Color(rgb, true).getAlpha();
                if (alpha > 0 && alpha <= 128) {
                    ++midAlphaPixels;
                }
                if (alpha <= 0) continue;
                ++visiblePixels;
            }
        }
        double ratio = (double)midAlphaPixels / (double)visiblePixels;
        return ratio >= 0.05;
    }

    private static boolean isPixelNormal(int rgb) {
        return Integer.toHexString(rgb).length() == 8;
    }

    private static boolean isPixelVisible(int alpha, boolean hasPartialTransparency) {
        return alpha > 0 && (hasPartialTransparency || alpha > 128);
    }
}

