/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.core.commands;

import io.github.chickensaysbak.chatimage.core.ChatImage;
import io.github.chickensaysbak.chatimage.core.adapters.CommandAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.PlayerAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.PluginAdapter;
import io.github.chickensaysbak.chatimage.core.loaders.SavedMedia;
import io.github.chickensaysbak.chatimage.core.loaders.Settings;
import io.github.chickensaysbak.chatimage.core.media.Media;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

public class ChatImageCommand
extends CommandAdapter {
    public ChatImageCommand(PluginAdapter plugin) {
        super(plugin);
    }

    @Override
    public String getName() {
        return "chatimage";
    }

    @Override
    public String getPermission() {
        return "chatimage.admin";
    }

    @Override
    public String[] getAliases() {
        return new String[0];
    }

    @Override
    public void onCommand(UUID sender, String[] args) {
        ChatImage chatImage = ChatImage.getInstance();
        SavedMedia savedMedia = chatImage.getSavedImages();
        if (args.length < 1) {
            chatImage.sendUIMessage(sender, "chatimage_usage", new TagResolver[0]);
            return;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            chatImage.reload();
            chatImage.sendUIMessage(sender, "reload_config", new TagResolver[0]);
        } else if (args[0].equalsIgnoreCase("send")) {
            if (args.length < 3) {
                chatImage.sendUIMessage(sender, "chatimage_send_usage", new TagResolver[0]);
                chatImage.sendUIMessage(sender, "chatimage_send_usage_2", new TagResolver[0]);
                return;
            }
            PlayerAdapter recipient = this.getPlugin().getPlayer(args[1]);
            if (recipient == null && !args[1].equalsIgnoreCase("all")) {
                chatImage.sendUIMessage(sender, "error_player_offline", new TagResolver[0]);
                return;
            }
            String mediaRef = args[2];
            if (!mediaRef.startsWith("http")) {
                Media media = savedMedia.getMedia(mediaRef);
                if (media == null) {
                    chatImage.sendUIMessage(sender, "error_doesnt_exist", Placeholder.unparsed("name", mediaRef));
                    return;
                }
                Object text = "";
                for (int i = 3; i < args.length; ++i) {
                    text = (String)text + args[i].replace("\\n", "\n") + " ";
                }
                if (!((String)text).isEmpty()) {
                    text = ((String)text).substring(0, ((String)text).length() - 1);
                }
                this.sendMedia(media, (String)text, recipient, sender);
            } else {
                this.getPlugin().runAsyncTaskLater(() -> {
                    Media media;
                    Boolean smooth = null;
                    Boolean trim = null;
                    Integer width = null;
                    Integer height = null;
                    if (args.length >= 4) {
                        if (args[3].equalsIgnoreCase("true")) {
                            smooth = true;
                        } else if (args[3].equalsIgnoreCase("false")) {
                            smooth = false;
                        }
                    }
                    if (args.length >= 5) {
                        if (args[4].equalsIgnoreCase("true")) {
                            trim = true;
                        } else if (args[4].equalsIgnoreCase("false")) {
                            trim = false;
                        }
                    }
                    if (args.length >= 6) {
                        try {
                            width = Integer.parseInt(args[5]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (args.length >= 7) {
                        try {
                            height = Integer.parseInt(args[6]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if ((media = chatImage.loadMedia(mediaRef, width, height, smooth, trim, false)) == null) {
                        chatImage.sendUIMessage(sender, "error_load", new TagResolver[0]);
                        return;
                    }
                    Object text = "";
                    for (int i = 7; i < args.length; ++i) {
                        text = (String)text + args[i].replace("\\n", "\n") + " ";
                    }
                    if (!((String)text).isEmpty()) {
                        text = ((String)text).substring(0, ((String)text).length() - 1);
                    }
                    this.sendMedia(media, (String)text, recipient, sender);
                }, 0L);
            }
        } else if (args[0].equalsIgnoreCase("save")) {
            if (args.length < 3) {
                chatImage.sendUIMessage(sender, "chatimage_save_usage", new TagResolver[0]);
                return;
            }
            String name = args[1];
            if (name.startsWith("http")) {
                chatImage.sendUIMessage(sender, "error_order", new TagResolver[0]);
                return;
            }
            if (savedMedia.getMedia(name) != null) {
                chatImage.sendUIMessage(sender, "error_already_exists", Placeholder.unparsed("name", name));
                return;
            }
            this.getPlugin().runAsyncTaskLater(() -> {
                Media media;
                Settings settings = chatImage.getSettings();
                boolean smooth = settings.isSmoothRender();
                boolean trim = settings.isTrimTransparency();
                int width = settings.getMaxWidth();
                int height = settings.getMaxHeight();
                if (args.length >= 4) {
                    if (args[3].equalsIgnoreCase("true")) {
                        smooth = true;
                    } else if (args[3].equalsIgnoreCase("false")) {
                        smooth = false;
                    }
                }
                if (args.length >= 5) {
                    if (args[4].equalsIgnoreCase("true")) {
                        trim = true;
                    } else if (args[4].equalsIgnoreCase("false")) {
                        trim = false;
                    }
                }
                if (args.length >= 6) {
                    try {
                        width = Integer.parseInt(args[5]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (args.length >= 7) {
                    try {
                        height = Integer.parseInt(args[6]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((media = chatImage.loadMedia(args[2], width, height, smooth, trim, false)) == null) {
                    chatImage.sendUIMessage(sender, "error_load", new TagResolver[0]);
                    return;
                }
                if (savedMedia.saveMedia(name, media)) {
                    chatImage.sendUIMessage(sender, "image_saved", Placeholder.unparsed("name", name));
                } else {
                    chatImage.sendUIMessage(sender, "error_save", new TagResolver[0]);
                }
            }, 0L);
        } else if (args[0].equalsIgnoreCase("delete")) {
            if (args.length < 2) {
                chatImage.sendUIMessage(sender, "chatimage_delete_usage", new TagResolver[0]);
                return;
            }
            String name = args[1];
            if (savedMedia.getMedia(name) == null) {
                chatImage.sendUIMessage(sender, "error_doesnt_exist", Placeholder.unparsed("name", name));
                return;
            }
            if (savedMedia.deleteMedia(name)) {
                chatImage.sendUIMessage(sender, "image_deleted", Placeholder.unparsed("name", name));
            } else {
                chatImage.sendUIMessage(sender, "error_delete", new TagResolver[0]);
            }
        } else {
            chatImage.sendUIMessage(sender, "chatimage_usage", new TagResolver[0]);
        }
    }

    @Override
    public List<String> onTabComplete(UUID sender, String[] args) {
        boolean usingURL;
        ChatImage chatImage = ChatImage.getInstance();
        Settings settings = chatImage.getSettings();
        SavedMedia savedMedia = chatImage.getSavedImages();
        ArrayList<String> result = new ArrayList<String>();
        boolean bl = usingURL = args.length >= 3 && args[2].startsWith("http");
        if (args.length < 1) {
            return result;
        }
        if (args.length == 1) {
            result.addAll(Arrays.asList("reload", "send", "save", "delete"));
        } else if (args[0].equalsIgnoreCase("send")) {
            switch (args.length) {
                case 2: {
                    List names = this.getPlugin().getOnlinePlayers().stream().map(PlayerAdapter::getName).collect(Collectors.toList());
                    names.add("all");
                    names.stream().filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).forEach(result::add);
                    break;
                }
                case 3: {
                    savedMedia.getMediaNames().stream().filter(name -> name.toLowerCase().startsWith(args[2].toLowerCase())).forEach(result::add);
                    break;
                }
                case 4: 
                case 5: {
                    if (!usingURL) break;
                    result.addAll(Arrays.asList("default", "true", "false"));
                    break;
                }
                case 6: {
                    if (!usingURL) break;
                    result.addAll(Arrays.asList("default", "" + settings.getMaxWidth()));
                    break;
                }
                case 7: {
                    if (!usingURL) break;
                    result.addAll(Arrays.asList("default", "" + settings.getMaxHeight()));
                }
            }
        } else if (args[0].equalsIgnoreCase("save")) {
            switch (args.length) {
                case 4: 
                case 5: {
                    result.addAll(Arrays.asList("default", "true", "false"));
                    break;
                }
                case 6: {
                    result.addAll(Arrays.asList("default", "" + settings.getMaxWidth()));
                    break;
                }
                case 7: {
                    result.addAll(Arrays.asList("default", "" + settings.getMaxHeight()));
                }
            }
        } else if (args[0].equalsIgnoreCase("delete")) {
            switch (args.length) {
                case 2: {
                    savedMedia.getMediaNames().stream().filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).forEach(result::add);
                }
            }
        }
        return result;
    }

    private void sendMedia(Media media, String text, PlayerAdapter recipient, UUID sender) {
        ChatImage chatImage = ChatImage.getInstance();
        if (recipient == null) {
            this.getPlugin().getOnlinePlayers().forEach(p -> p.sendMessage(media.formatFor((PlayerAdapter)p, text, false)));
            if (sender != null) {
                chatImage.sendUIMessage(sender, "image_sent_all", new TagResolver[0]);
            }
        } else {
            if (recipient.isOnline()) {
                Component component = media.formatFor(recipient, text, false);
                if (component == null) {
                    chatImage.sendUIMessage(sender, "error_outdated", new TagResolver[0]);
                    return;
                }
                recipient.sendMessage(component);
            }
            if (sender != null && !sender.equals(recipient.getUniqueId())) {
                chatImage.sendUIMessage(sender, "image_sent", new TagResolver[0]);
            }
        }
    }
}

