/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.core.loaders;

import io.github.chickensaysbak.chatimage.core.ChatImage;
import io.github.chickensaysbak.chatimage.core.adapters.PluginAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.YamlAdapter;
import io.github.chickensaysbak.chatimage.core.loaders.Loadable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;

public class PlayerPreferences
implements Loadable {
    private PluginAdapter plugin;
    private File preferencesFile;
    private HashMap<UUID, Boolean> preferences = new HashMap();
    private int saveTimeRemaining = 0;
    private ArrayList<UUID> recordedPlayerPreference = new ArrayList();

    public PlayerPreferences(PluginAdapter plugin) {
        this.plugin = plugin;
        this.preferencesFile = new File(plugin.getDataFolder(), "player_preferences.yml");
        this.reload();
        this.convertIgnoringFile();
    }

    public void setShowingImages(UUID uuid, boolean showImages) {
        boolean autoHide = ChatImage.getInstance().getSettings().isAutoHide();
        if (showImages == autoHide) {
            this.preferences.put(uuid, showImages);
        } else {
            this.preferences.remove(uuid);
        }
        this.updateStats();
        this.queueSave();
    }

    public boolean isShowingImages(UUID uuid) {
        boolean autoHide = ChatImage.getInstance().getSettings().isAutoHide();
        return this.preferences.getOrDefault(uuid, !autoHide);
    }

    public void updateStats() {
        int hiding = 0;
        for (UUID uuid : this.preferences.keySet()) {
            if (this.preferences.get(uuid).booleanValue() || this.recordedPlayerPreference.contains(uuid)) continue;
            ++hiding;
            this.recordedPlayerPreference.add(uuid);
        }
        if (hiding > 0) {
            this.plugin.publishStat("players_hiding_images2", hiding);
        }
    }

    @Override
    public void reload() {
        this.preferences.clear();
        if (!this.preferencesFile.exists()) {
            return;
        }
        YamlAdapter preferencesYaml = this.plugin.loadYaml(this.preferencesFile);
        boolean autoHide = ChatImage.getInstance().getSettings().isAutoHide();
        for (String uuidString : preferencesYaml.getKeys("preferences")) {
            try {
                UUID uuid = UUID.fromString(uuidString);
                this.preferences.put(uuid, preferencesYaml.getBoolean("preferences." + uuidString, !autoHide));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().log(Level.WARNING, e.getMessage(), e);
            }
        }
        this.updateStats();
    }

    public boolean isSaveQueued() {
        return this.saveTimeRemaining > 0;
    }

    public void queueSave() {
        boolean startTimer = !this.isSaveQueued();
        this.saveTimeRemaining = 5;
        if (startTimer) {
            this.queueSaveTimer();
        }
    }

    private void queueSaveTimer() {
        this.plugin.runAsyncTaskLater(() -> {
            if (this.isSaveQueued()) {
                --this.saveTimeRemaining;
                this.queueSaveTimer();
            } else {
                this.saveFile();
            }
        }, 20L);
    }

    public void saveFile() {
        if (this.preferences.isEmpty()) {
            if (this.preferencesFile.exists()) {
                this.preferencesFile.delete();
            }
            return;
        }
        try {
            if (!this.preferencesFile.exists()) {
                this.preferencesFile.getParentFile().mkdirs();
                this.preferencesFile.createNewFile();
            }
            YamlAdapter preferencesYaml = this.plugin.loadYaml(this.preferencesFile);
            preferencesYaml.set("preferences", null);
            for (UUID uuid : this.preferences.keySet()) {
                preferencesYaml.set("preferences." + uuid.toString(), this.preferences.get(uuid));
            }
            preferencesYaml.save(this.preferencesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void convertIgnoringFile() {
        File ignoringFile = new File(this.plugin.getDataFolder(), "ignoring.yml");
        if (!ignoringFile.exists()) {
            return;
        }
        YamlAdapter ignoringYaml = this.plugin.loadYaml(ignoringFile);
        for (String uuidString : ignoringYaml.getStringList("ignoring")) {
            try {
                UUID uuid = UUID.fromString(uuidString);
                this.preferences.put(uuid, false);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().log(Level.WARNING, e.getMessage(), e);
            }
        }
        ignoringFile.delete();
        this.saveFile();
    }
}

