/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.core.loaders;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.chickensaysbak.chatimage.core.ChatImage;
import io.github.chickensaysbak.chatimage.core.GifHandler;
import io.github.chickensaysbak.chatimage.core.adapters.PluginAdapter;
import io.github.chickensaysbak.chatimage.core.loaders.Loadable;
import io.github.chickensaysbak.chatimage.core.media.Gif;
import io.github.chickensaysbak.chatimage.core.media.Image;
import io.github.chickensaysbak.chatimage.core.media.Media;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;

public class SavedMedia
implements Loadable {
    private PluginAdapter plugin;
    private File savedDirectory;
    private HashMap<String, Media> savedMedia = new HashMap();

    public SavedMedia(PluginAdapter plugin) {
        this.plugin = plugin;
        this.savedDirectory = new File(plugin.getDataFolder(), "saved");
        this.reload();
    }

    public boolean saveMedia(String name, Media media) {
        try {
            File file = new File(this.savedDirectory, name + ".json");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            Files.writeString(file.toPath(), (CharSequence)media.serialize(), new OpenOption[0]);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
        this.savedMedia.put(name, media);
        return true;
    }

    public boolean deleteMedia(String name) {
        boolean successful;
        File file = new File(this.savedDirectory, name + ".json");
        boolean bl = successful = !file.exists() || file.delete();
        if (this.savedDirectory.listFiles().length == 0) {
            this.savedDirectory.delete();
        }
        if (successful) {
            this.savedMedia.remove(name);
        }
        return successful;
    }

    public Media getMedia(String name) {
        return this.savedMedia.get(name);
    }

    public ArrayList<String> getMediaNames() {
        ArrayList<String> names = new ArrayList<String>(this.savedMedia.keySet());
        Collections.sort(names);
        return names;
    }

    @Override
    public void reload() {
        this.savedMedia.clear();
        MiniMessage mm = MiniMessage.miniMessage();
        this.convertLegacyImages(mm);
        if (!this.savedDirectory.exists()) {
            return;
        }
        for (File file : this.savedDirectory.listFiles()) {
            GifHandler.Gif gif;
            String jsonStr;
            if (!file.getName().toLowerCase().endsWith(".json")) continue;
            try {
                jsonStr = Files.readString(file.toPath());
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            String name = file.getName().replace(".json", "");
            JsonObject json = JsonParser.parseString((String)jsonStr).getAsJsonObject();
            Media media = null;
            if (json.has("image")) {
                Object component = mm.deserialize(json.get("image").getAsString());
                media = new Image((Component)component);
            } else if (json.has("frames") && (gif = ChatImage.getInstance().getGifHandler().loadSavedGif(name, json)) != null) {
                media = new Gif(gif);
            }
            if (media == null) continue;
            this.savedMedia.put(name, media);
        }
    }

    private void convertLegacyImages(MiniMessage mm) {
        File oldImagesDirectory = new File(this.plugin.getDataFolder(), "images");
        if (!oldImagesDirectory.exists()) {
            return;
        }
        ArrayList<File> toDelete = new ArrayList<File>();
        for (File file : oldImagesDirectory.listFiles()) {
            if (!file.getName().toLowerCase().endsWith(".json")) continue;
            try {
                String jsonString = Files.readString(file.toPath());
                String miniMessage = (String)mm.serialize(GsonComponentSerializer.gson().deserialize(jsonString));
                File newFile = new File(this.savedDirectory, file.getName());
                if (!newFile.exists()) {
                    newFile.getParentFile().mkdirs();
                    newFile.createNewFile();
                }
                JsonObject newJson = new JsonObject();
                newJson.addProperty("image", miniMessage);
                Files.writeString(newFile.toPath(), (CharSequence)newJson.toString(), new OpenOption[0]);
                toDelete.add(file);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, e.getMessage(), e);
            }
        }
        toDelete.forEach(File::delete);
        oldImagesDirectory.delete();
    }
}

