/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.core.loaders;

import io.github.chickensaysbak.chatimage.core.adapters.PluginAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.YamlAdapter;
import io.github.chickensaysbak.chatimage.core.loaders.Loadable;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;

public class Settings
implements Loadable {
    private PluginAdapter plugin;
    private File configFile;
    private int cooldown;
    private boolean strictCooldown;
    private boolean smoothRender;
    private boolean trimTransparency;
    private int maxWidth;
    private int maxHeight;
    private boolean autoHide;
    private int hiddenWidth;
    private int hiddenHeight;
    private int gifWidth;
    private int gifHeight;
    private boolean filterExplicitContent;
    private boolean removeExplicitContent;
    private String languageDefault;
    private boolean debug;
    private File messagesDirectory;
    private HashMap<String, HashMap<String, String>> multilingualMsgs = new HashMap();
    private String[] suppliedLangs = new String[]{"de_de", "en_us", "es_es", "fi_fi", "fr_fr", "hi_in", "id_id", "ja_jp", "ko_kr", "nl_nl", "pl_pl", "pt_pt", "vi_vn", "zh_cn", "zh_hk"};

    public Settings(PluginAdapter plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
        this.messagesDirectory = new File(plugin.getDataFolder(), "messages");
        this.reload();
    }

    @Override
    public void reload() {
        this.plugin.saveResource("config.yml");
        this.convertLegacyMessages();
        Arrays.stream(this.suppliedLangs).forEach(lang -> this.plugin.saveResource("messages/" + lang + ".yml"));
        YamlAdapter config = this.plugin.loadYaml(this.configFile);
        this.cooldown = config.getInt("cooldown", 3);
        this.strictCooldown = config.getBoolean("strict_cooldown", false);
        this.smoothRender = config.getBoolean("smooth_render", config.getBoolean("fancy_render", true));
        this.trimTransparency = config.getBoolean("trim_transparency", true);
        this.maxWidth = config.getInt("max_width", 35);
        this.maxHeight = config.getInt("max_height", 20);
        this.autoHide = config.getBoolean("hidden_images.auto_hide", false);
        this.hiddenWidth = config.getInt("hidden_images.max_width", 23);
        this.hiddenHeight = config.getInt("hidden_images.max_height", 24);
        this.gifWidth = config.getInt("gifs.max_width", 22);
        this.gifHeight = config.getInt("gifs.max_height", 22);
        this.filterExplicitContent = config.getBoolean("explicit_content.enabled", false);
        this.removeExplicitContent = config.getBoolean("explicit_content.remove_message", false);
        this.languageDefault = config.getString("language_default", "en_us");
        this.debug = config.getBoolean("debug", false);
        this.multilingualMsgs.clear();
        for (File f : this.messagesDirectory.listFiles()) {
            if (f == null || !f.getName().endsWith(".yml")) continue;
            YamlAdapter messages = this.plugin.loadYaml(f);
            HashMap<String, String> msgs = new HashMap<String, String>();
            for (String key : messages.getKeys()) {
                msgs.put(key, messages.getString(key, ""));
            }
            this.multilingualMsgs.put(f.getName().split("\\.")[0], msgs);
        }
        this.plugin.publishStat("cooldowns", String.valueOf(this.cooldown));
        this.plugin.publishStat("strict_cooldown", String.valueOf(this.strictCooldown));
        this.plugin.publishStat("smooth_render", String.valueOf(this.smoothRender));
        this.plugin.publishStat("trim_transparency", String.valueOf(this.trimTransparency));
        this.plugin.publishStat("max_width", String.valueOf(this.maxWidth));
        this.plugin.publishStat("max_height", String.valueOf(this.maxHeight));
        this.plugin.publishStat("auto_hide", String.valueOf(this.autoHide));
        this.plugin.publishStat("max_hidden_width", String.valueOf(this.hiddenWidth));
        this.plugin.publishStat("max_hidden_height", String.valueOf(this.hiddenHeight));
        this.plugin.publishStat("max_gif_width", String.valueOf(this.gifWidth));
        this.plugin.publishStat("max_gif_height", String.valueOf(this.gifHeight));
        this.plugin.publishStat("explicit_content_filtration2", String.valueOf(this.filterExplicitContent));
        this.plugin.publishStat("explicit_content_message_removal2", String.valueOf(this.removeExplicitContent));
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean isStrictCooldown() {
        return this.strictCooldown;
    }

    public boolean isSmoothRender() {
        return this.smoothRender;
    }

    public boolean isTrimTransparency() {
        return this.trimTransparency;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public boolean isAutoHide() {
        return this.autoHide;
    }

    public int getMaxHiddenWidth() {
        return this.hiddenWidth;
    }

    public int getMaxHiddenHeight() {
        return this.hiddenHeight;
    }

    public int getMaxGifWidth() {
        return this.gifWidth;
    }

    public int getMaxGifHeight() {
        return this.gifHeight;
    }

    public boolean isFilterExplicitContent() {
        return this.filterExplicitContent;
    }

    public boolean isRemoveExplicitContent() {
        return this.removeExplicitContent;
    }

    public String getLanguageDefault() {
        return this.languageDefault;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getMessage(String name, String locale) {
        if (!this.multilingualMsgs.containsKey(locale = locale.toLowerCase())) {
            String baseLang = locale.split("_")[0] + "_";
            locale = this.multilingualMsgs.keySet().stream().filter(l -> l.startsWith(baseLang)).findFirst().orElseGet(() -> this.multilingualMsgs.containsKey(this.languageDefault) ? this.languageDefault : "en_us");
        }
        return this.multilingualMsgs.get(locale).get(name);
    }

    private void convertLegacyMessages() {
        File legacyMessages = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!legacyMessages.exists()) {
            return;
        }
        File enUS = new File(this.messagesDirectory, "en_us.yml");
        if (enUS.exists()) {
            return;
        }
        try {
            Files.copy(legacyMessages.toPath(), enUS.toPath(), new CopyOption[0]);
            legacyMessages.delete();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }
}

