/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.core.media;

import io.github.chickensaysbak.chatimage.core.ChatImage;
import io.github.chickensaysbak.chatimage.core.GifHandler;
import io.github.chickensaysbak.chatimage.core.adapters.PlayerAdapter;
import io.github.chickensaysbak.chatimage.core.loaders.Settings;
import io.github.chickensaysbak.chatimage.core.media.Media;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.apache.commons.codec.binary.Base32;

public class Gif
implements Media {
    private GifHandler.Gif gif;

    public Gif(GifHandler.Gif gif) {
        this.gif = gif;
    }

    @Override
    public Component formatFor(PlayerAdapter player, String text, boolean placeholder) {
        if (!ChatImage.getInstance().getPlugin().hasDialogSupport()) {
            return null;
        }
        if (player != null && !Gif.isVersionCompatible(player.getVersion())) {
            return null;
        }
        Settings settings = ChatImage.getInstance().getSettings();
        MiniMessage mm = MiniMessage.miniMessage();
        String locale = player != null ? player.getLocale() : ChatImage.getInstance().getSettings().getLanguageDefault();
        String showGifMsg = settings.getMessage("show_gif", locale);
        Object showGif = mm.deserialize(showGifMsg != null ? showGifMsg : "<green>[Show GIF]");
        String playGifMsg = settings.getMessage("play_gif", locale);
        TextComponent playGif = playGifMsg != null ? mm.deserialize(playGifMsg) : Component.empty();
        String formattedText = text != null && !text.isEmpty() && player != null ? ChatImage.getInstance().getPlugin().setPlaceholders(player.getUniqueId(), text, placeholder) : text;
        return showGif.hoverEvent(HoverEvent.showText(playGif)).clickEvent(ClickEvent.custom(Key.key("chatimage:open_gif_" + this.gif.getID() + "_" + Gif.encodeText(formattedText)), BinaryTagHolder.binaryTagHolder("{}")));
    }

    @Override
    public String serialize() {
        return this.gif.toJson();
    }

    public static boolean isVersionCompatible(int version) {
        return version == -1 || version >= 771;
    }

    public static String encodeText(String text) {
        if (text == null) {
            return "";
        }
        Base32 base32 = new Base32(false, 46);
        return base32.encodeAsString(text.getBytes()).toLowerCase();
    }

    public static String decodeText(String encoded) {
        if (encoded.isEmpty()) {
            return encoded;
        }
        Base32 base32 = new Base32(false, 46);
        return new String(base32.decode(encoded));
    }
}

