/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.core.media;

import io.github.chickensaysbak.chatimage.core.ChatImage;
import io.github.chickensaysbak.chatimage.core.ImageMaker;
import io.github.chickensaysbak.chatimage.core.adapters.PlayerAdapter;
import io.github.chickensaysbak.chatimage.core.loaders.Settings;
import io.github.chickensaysbak.chatimage.core.media.Image;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.StyleSetter;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class HidableImage
extends Image {
    private String url;
    private Component hiddenImage;

    public HidableImage(String url, BufferedImage image) {
        this.url = url;
        Settings settings = ChatImage.getInstance().getSettings();
        boolean smooth = settings.isSmoothRender();
        boolean trim = settings.isTrimTransparency();
        Dimension expandedDim = new Dimension(settings.getMaxWidth(), settings.getMaxHeight());
        Dimension hiddenDim = new Dimension(settings.getMaxHiddenWidth(), settings.getMaxHiddenHeight());
        this.expandedImage = ImageMaker.createChatImage(image, expandedDim, smooth, trim);
        this.hiddenImage = ImageMaker.createChatImage(image, hiddenDim, smooth, trim);
    }

    @Override
    public Component formatFor(PlayerAdapter player, String text, boolean placeholder) {
        if (player != null && !HidableImage.isVersionCompatible(player.getVersion())) {
            return null;
        }
        String locale = player != null ? player.getLocale() : ChatImage.getInstance().getSettings().getLanguageDefault();
        boolean showing = ChatImage.getInstance().getPlayerPreferences().isShowingImages(player.getUniqueId());
        return showing ? this.formatExpandedImage(locale) : this.formatHiddenImage(locale);
    }

    public String getUrl() {
        return this.url;
    }

    private Component formatExpandedImage(String locale) {
        MiniMessage mm = MiniMessage.miniMessage();
        String hoverTip = ChatImage.getInstance().getSettings().getMessage("hover_tip", locale);
        StyleSetter<Component> result = Component.textOfChildren(this.expandedImage);
        if (hoverTip != null) {
            Object tip = mm.deserialize(hoverTip);
            result = result.hoverEvent(HoverEvent.showText(tip));
        }
        return result.clickEvent(ClickEvent.openUrl(this.url));
    }

    private Component formatHiddenImage(String locale) {
        MiniMessage mm = MiniMessage.miniMessage();
        String showImageMsg = ChatImage.getInstance().getSettings().getMessage("show_image", locale);
        Object showImage = mm.deserialize(showImageMsg != null ? showImageMsg : "<green>[Show Image]");
        Component hoverImage = Component.newline().append(this.hiddenImage);
        return showImage.hoverEvent(HoverEvent.showText(hoverImage)).clickEvent(ClickEvent.openUrl(this.url));
    }
}

