/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.core.media;

import com.google.gson.JsonObject;
import io.github.chickensaysbak.chatimage.core.ChatImage;
import io.github.chickensaysbak.chatimage.core.ImageMaker;
import io.github.chickensaysbak.chatimage.core.adapters.PlayerAdapter;
import io.github.chickensaysbak.chatimage.core.media.Media;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class Image
implements Media {
    Component expandedImage;

    public Image(BufferedImage image, Dimension dim, boolean smooth, boolean trim) {
        this.expandedImage = ImageMaker.createChatImage(image, dim, smooth, trim);
    }

    public Image(Component image) {
        this.expandedImage = image;
    }

    Image() {
    }

    @Override
    public Component formatFor(PlayerAdapter player, String text, boolean placeholder) {
        if (player != null && !Image.isVersionCompatible(player.getVersion())) {
            return null;
        }
        if (text != null && !text.isEmpty()) {
            String formattedText = player != null ? ChatImage.getInstance().getPlugin().setPlaceholders(player.getUniqueId(), text, placeholder) : text;
            return ImageMaker.addText(this.expandedImage, formattedText);
        }
        return this.expandedImage;
    }

    @Override
    public String serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("image", (String)MiniMessage.miniMessage().serialize(this.expandedImage));
        return json.toString();
    }

    public static boolean isVersionCompatible(int version) {
        return version == -1 || version >= 735;
    }
}

