/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.paper;

import io.github.chickensaysbak.chatimage.core.adapters.PlayerAdapter;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class PlayerPaper
implements PlayerAdapter {
    private Player player;

    PlayerPaper(Player player) {
        this.player = player;
    }

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public boolean isOnline() {
        return this.player != null && this.player.isOnline();
    }

    @Override
    public boolean hasPermission(String node) {
        return this.player.hasPermission(node);
    }

    @Override
    public void sendMessage(Component component) {
        if (component == null) {
            return;
        }
        this.player.sendMessage(component);
    }

    @Override
    public void sendGifFrame(Component frame, Component text) {
        Dialog dialog = Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)(text != null ? text : Component.empty())).body(List.of(DialogBody.plainMessage((Component)frame))).build()).type((DialogType)DialogType.notice((ActionButton)ActionButton.builder((Component)Component.translatable("mco.selectServer.close", "Close")).action((DialogAction)DialogAction.customClick((Key)Key.key("chatimage:close_gif"), null)).build())));
        this.player.showDialog((DialogLike)dialog);
    }

    @Override
    public void closeDialog() {
        this.player.closeInventory();
    }

    @Override
    public int getVersion() {
        return this.player.getProtocolVersion();
    }

    @Override
    public String getLocale() {
        return this.player.locale().toString().toLowerCase();
    }
}

