/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.paper;

import io.github.chickensaysbak.chatimage.bukkit.Metrics;
import io.github.chickensaysbak.chatimage.charts.DrilldownPie;
import io.github.chickensaysbak.chatimage.charts.SimplePie;
import io.github.chickensaysbak.chatimage.charts.SingleLineChart;
import io.github.chickensaysbak.chatimage.core.ChatImage;
import io.github.chickensaysbak.chatimage.core.adapters.CommandAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.PlayerAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.PluginAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.YamlAdapter;
import io.github.chickensaysbak.chatimage.paper.CommandPaper;
import io.github.chickensaysbak.chatimage.paper.PlayerPaper;
import io.github.chickensaysbak.chatimage.paper.YamlPaper;
import io.github.chickensaysbak.chatimage.paper.softdepend.DiscordSRVHandler;
import io.github.chickensaysbak.chatimage.paper.softdepend.EssXDiscordHandler;
import io.github.chickensaysbak.chatimage.paper.softdepend.PAPIHandler;
import io.papermc.paper.connection.PlayerCommonConnection;
import io.papermc.paper.connection.PlayerGameConnection;
import io.papermc.paper.event.player.AsyncChatEvent;
import io.papermc.paper.event.player.PlayerCustomClickEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginPaper
extends JavaPlugin
implements Listener,
PluginAdapter {
    private ChatImage core;
    private Metrics bStats;
    private DiscordSRVHandler discordSRVHandler = null;
    private EssXDiscordHandler essXDiscordHandler = null;
    private PAPIHandler papiHandler = null;

    public void onEnable() {
        this.bStats = new Metrics((Plugin)this, 12672);
        this.core = new ChatImage(this);
        boolean debug = this.core.getSettings().isDebug();
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)this, (Plugin)this);
        if (pluginManager.isPluginEnabled("DiscordSRV")) {
            this.discordSRVHandler = new DiscordSRVHandler();
            if (debug) {
                this.getLogger().info("ChatImage Debugger - DiscordSRV found");
            }
        }
        if (pluginManager.isPluginEnabled("EssentialsDiscord")) {
            this.essXDiscordHandler = new EssXDiscordHandler();
            pluginManager.registerEvents((Listener)this.essXDiscordHandler, (Plugin)this);
            if (debug) {
                this.getLogger().info("ChatImage Debugger - EssentialsDiscord found");
            }
        }
        if (pluginManager.isPluginEnabled("PlaceholderAPI")) {
            this.papiHandler = new PAPIHandler();
            if (debug) {
                this.getLogger().info("ChatImage Debugger - PlaceholderAPI found");
            }
        }
        this.publishStat("discordsrv", String.valueOf(this.discordSRVHandler != null));
        this.publishStat("essxdiscord", String.valueOf(this.essXDiscordHandler != null));
        this.publishStat("papi", String.valueOf(this.papiHandler != null));
    }

    public void onDisable() {
        if (this.discordSRVHandler != null) {
            this.discordSRVHandler.unsubscribe();
        }
        this.core.onDisable();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.core.onJoin(new PlayerPaper(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onChat(AsyncChatEvent event) {
        boolean cancelEvent = this.core.onChat(new PlayerPaper(event.getPlayer()), event.message());
        if (cancelEvent) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onClick(PlayerCustomClickEvent event) {
        PlayerCommonConnection playerCommonConnection = event.getCommonConnection();
        if (playerCommonConnection instanceof PlayerGameConnection) {
            PlayerGameConnection pgc = (PlayerGameConnection)playerCommonConnection;
            this.core.onClick(new PlayerPaper(pgc.getPlayer()), event.getIdentifier().asString());
        }
    }

    @Override
    public void registerCommand(CommandAdapter command) {
        this.registerCommand(command.getName(), Arrays.asList(command.getAliases()), new CommandPaper(command));
    }

    @Override
    public void saveResource(String path) {
        File target = new File(this.getDataFolder(), path);
        if (!target.exists()) {
            this.saveResource(path, false);
        }
    }

    @Override
    public void sendConsoleMessage(Component message) {
        this.getServer().getConsoleSender().sendMessage(message);
    }

    @Override
    public PlayerAdapter getPlayer(UUID uuid) {
        Player player = this.getServer().getPlayer(uuid);
        if (player == null) {
            return null;
        }
        return new PlayerPaper(player);
    }

    @Override
    public PlayerAdapter getPlayer(String name) {
        Player player = this.getServer().getPlayer(name);
        if (player == null) {
            return null;
        }
        return new PlayerPaper(player);
    }

    @Override
    public List<PlayerAdapter> getOnlinePlayers() {
        return this.getServer().getOnlinePlayers().stream().map(PlayerPaper::new).collect(Collectors.toList());
    }

    @Override
    public YamlAdapter loadYaml(File file) {
        return new YamlPaper(this, YamlConfiguration.loadConfiguration((File)file));
    }

    @Override
    public void runAsyncTaskLater(Runnable task, long ticks) {
        this.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this, task, ticks).getTaskId();
    }

    @Override
    public void runTaskLater(Runnable task, long ticks) {
        this.getServer().getScheduler().runTaskLater((Plugin)this, task, ticks).getTaskId();
    }

    @Override
    public void publishStat(String id, String value) {
        this.bStats.addCustomChart(new SimplePie(id, () -> value));
    }

    @Override
    public void publishStat(String id, int value) {
        this.bStats.addCustomChart(new SingleLineChart(id, () -> value));
    }

    @Override
    public void publishStat(String id, Map<String, Map<String, Integer>> value) {
        this.bStats.addCustomChart(new DrilldownPie(id, () -> value));
    }

    @Override
    public String setPlaceholders(UUID uuid, String text, boolean brackets) {
        return this.papiHandler != null ? this.papiHandler.setPlaceholders((OfflinePlayer)this.getServer().getPlayer(uuid), text, brackets) : text;
    }

    @Override
    public boolean hasDialogSupport() {
        return true;
    }
}

