/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.spigot;

import io.github.chickensaysbak.chatimage.core.adapters.PlayerAdapter;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.api.dialog.Dialog;
import net.md_5.bungee.api.dialog.DialogBase;
import net.md_5.bungee.api.dialog.NoticeDialog;
import net.md_5.bungee.api.dialog.action.Action;
import net.md_5.bungee.api.dialog.action.ActionButton;
import net.md_5.bungee.api.dialog.action.CustomClickAction;
import net.md_5.bungee.api.dialog.body.PlainMessageBody;
import org.bukkit.entity.Player;

public class PlayerSpigot
implements PlayerAdapter {
    private Player player;

    PlayerSpigot(Player player) {
        this.player = player;
    }

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public boolean isOnline() {
        return this.player != null && this.player.isOnline();
    }

    @Override
    public boolean hasPermission(String node) {
        return this.player.hasPermission(node);
    }

    @Override
    public void sendMessage(Component component) {
        if (component == null) {
            return;
        }
        this.player.spigot().sendMessage(BungeeComponentSerializer.get().serialize(component));
    }

    @Override
    public void sendGifFrame(Component frame, Component text) {
        TextComponent frameTC = new TextComponent(BungeeComponentSerializer.get().serialize(frame));
        TextComponent textTC = text != null ? new TextComponent(BungeeComponentSerializer.get().serialize(text)) : new TextComponent();
        TranslatableComponent closeText = new TranslatableComponent("mco.selectServer.close", new Object[0]);
        closeText.setFallback("Close");
        NoticeDialog dialog = new NoticeDialog(new DialogBase((BaseComponent)textTC).body(List.of(new PlainMessageBody((BaseComponent)frameTC))), new ActionButton((BaseComponent)closeText, (Action)new CustomClickAction("chatimage:close_gif")));
        this.player.showDialog((Dialog)dialog);
    }

    @Override
    public void closeDialog() {
        this.player.clearDialog();
    }

    @Override
    public int getVersion() {
        return -1;
    }

    @Override
    public String getLocale() {
        return this.player.getLocale();
    }
}

