/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import io.github.chickensaysbak.chatimage.charts.DrilldownPie;
import io.github.chickensaysbak.chatimage.charts.SimplePie;
import io.github.chickensaysbak.chatimage.charts.SingleLineChart;
import io.github.chickensaysbak.chatimage.core.ChatImage;
import io.github.chickensaysbak.chatimage.core.adapters.CommandAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.PlayerAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.PluginAdapter;
import io.github.chickensaysbak.chatimage.core.adapters.YamlAdapter;
import io.github.chickensaysbak.chatimage.velocity.CommandVelocity;
import io.github.chickensaysbak.chatimage.velocity.Metrics;
import io.github.chickensaysbak.chatimage.velocity.PlayerVelocity;
import io.github.chickensaysbak.chatimage.velocity.YamlVelocity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class PluginVelocity
implements PluginAdapter {
    private ProxyServer proxy;
    private Logger logger;
    private Path dataFolder;
    private Metrics.Factory metricsFactory;
    private ChatImage core;
    private Metrics bStats;

    @Inject
    public PluginVelocity(ProxyServer proxy, Logger logger, @DataDirectory Path dataFolder, Metrics.Factory metricsFactory) {
        this.proxy = proxy;
        this.logger = logger;
        this.dataFolder = dataFolder;
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.bStats = this.metricsFactory.make(this, 22012);
        this.core = new ChatImage(this);
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.core.onDisable();
    }

    @Subscribe
    public void onJoin(ServerConnectedEvent event) {
        this.core.onJoin(new PlayerVelocity(event.getPlayer()));
    }

    @Subscribe(priority=-16384)
    public void onChat(PlayerChatEvent event) {
        if (!event.getResult().isAllowed()) {
            return;
        }
        boolean cancelEvent = this.core.onChat(new PlayerVelocity(event.getPlayer()), Component.text(event.getMessage()));
        if (cancelEvent) {
            event.setResult(PlayerChatEvent.ChatResult.denied());
        }
    }

    @Override
    public void registerCommand(CommandAdapter command) {
        CommandManager manager = this.proxy.getCommandManager();
        CommandMeta meta = manager.metaBuilder(command.getName()).aliases(command.getAliases()).plugin((Object)this).build();
        manager.register(meta, (Command)new CommandVelocity(command));
    }

    @Override
    public File getDataFolder() {
        return this.dataFolder.toFile();
    }

    @Override
    public InputStream getResource(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    @Override
    public void saveResource(String resourcePath) {
        File dataFolder = this.getDataFolder();
        Logger logger = this.getLogger();
        if (resourcePath == null || resourcePath.equals("")) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        InputStream in = this.getResource(resourcePath = resourcePath.replace('\\', '/'));
        if (in == null) {
            throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found");
        }
        File outFile = new File(dataFolder, resourcePath);
        int lastIndex = resourcePath.lastIndexOf(47);
        File outDir = new File(dataFolder, resourcePath.substring(0, Math.max(lastIndex, 0)));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            if (!outFile.exists()) {
                int len;
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not save " + outFile.getName() + " to " + String.valueOf(outFile), ex);
        }
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void sendConsoleMessage(Component message) {
        this.proxy.sendMessage(message);
    }

    @Override
    public PlayerAdapter getPlayer(UUID uuid) {
        return this.proxy.getPlayer(uuid).map(PlayerVelocity::new).orElse(null);
    }

    @Override
    public PlayerAdapter getPlayer(String name) {
        return this.proxy.getPlayer(name).map(PlayerVelocity::new).orElse(null);
    }

    @Override
    public List<PlayerAdapter> getOnlinePlayers() {
        return this.proxy.getAllPlayers().stream().map(PlayerVelocity::new).collect(Collectors.toList());
    }

    @Override
    public YamlAdapter loadYaml(File file) {
        try {
            return new YamlVelocity(this, ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(file)).build().load());
        }
        catch (ConfigurateException e) {
            this.getLogger().log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public void runAsyncTaskLater(Runnable task, long ticks) {
        this.proxy.getScheduler().buildTask((Object)this, task).delay(ticks * 50L, TimeUnit.MILLISECONDS).schedule();
    }

    @Override
    public void runTaskLater(Runnable task, long ticks) {
        this.runAsyncTaskLater(task, ticks);
    }

    @Override
    public void publishStat(String id, String value) {
        this.bStats.addCustomChart(new SimplePie(id, () -> value));
    }

    @Override
    public void publishStat(String id, int value) {
        this.bStats.addCustomChart(new SingleLineChart(id, () -> value));
    }

    @Override
    public void publishStat(String id, Map<String, Map<String, Integer>> value) {
        this.bStats.addCustomChart(new DrilldownPie(id, () -> value));
    }

    @Override
    public String setPlaceholders(UUID uuid, String text, boolean brackets) {
        return text;
    }

    @Override
    public boolean hasDialogSupport() {
        return false;
    }
}

