/*
 * Decompiled with CFR 0.152.
 */
package io.github.chickensaysbak.chatimage.velocity;

import io.github.chickensaysbak.chatimage.core.adapters.YamlAdapter;
import io.github.chickensaysbak.chatimage.velocity.PluginVelocity;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class YamlVelocity
implements YamlAdapter {
    private PluginVelocity plugin;
    private ConfigurationNode config;

    YamlVelocity(PluginVelocity plugin, ConfigurationNode config) {
        this.plugin = plugin;
        this.config = config;
    }

    @Override
    public void save(File file) throws IOException {
        ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(file)).build().save(this.config);
    }

    @Override
    public void set(String path, Object value) {
        try {
            YamlVelocity.nodeAtDotPath(this.config, path).set(value);
        }
        catch (SerializationException e) {
            this.plugin.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public Collection<String> getKeys() {
        return this.config.childrenMap().keySet().stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getKeys(String path) {
        return YamlVelocity.nodeAtDotPath(this.config, path).childrenMap().keySet().stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        return YamlVelocity.nodeAtDotPath(this.config, path).getBoolean(def);
    }

    @Override
    public int getInt(String path, int def) {
        return YamlVelocity.nodeAtDotPath(this.config, path).getInt(def);
    }

    @Override
    public long getLong(String path, long def) {
        return YamlVelocity.nodeAtDotPath(this.config, path).getLong(def);
    }

    @Override
    public double getDouble(String path, double def) {
        return YamlVelocity.nodeAtDotPath(this.config, path).getDouble(def);
    }

    @Override
    public String getString(String path, String def) {
        return YamlVelocity.nodeAtDotPath(this.config, path).getString(def);
    }

    @Override
    public List<String> getStringList(String path) {
        try {
            return YamlVelocity.nodeAtDotPath(this.config, path).getList(String.class);
        }
        catch (SerializationException e) {
            this.plugin.getLogger().log(Level.SEVERE, e.getMessage(), e);
            return List.of();
        }
    }

    private static ConfigurationNode nodeAtDotPath(ConfigurationNode root, String path) {
        String[] parts = path.split("\\.");
        return root.node((Object[])parts);
    }
}

