/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.api;

import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import eu.pb4.banhammer.api.PunishmentData;
import eu.pb4.banhammer.api.PunishmentType;
import eu.pb4.banhammer.api.TriState;
import eu.pb4.banhammer.impl.BanHammerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;

public final class BanHammer {
    private BanHammer() {
    }

    public static void punish(PunishmentData punishment) {
        BanHammer.punish(punishment, false, false);
    }

    public static void punish(PunishmentData punishment, boolean silent) {
        BanHammer.punish(punishment, silent, false);
    }

    public static void punish(PunishmentData punishment, boolean silent, boolean invisible) {
        BanHammerImpl.punishPlayer(punishment, silent, invisible);
    }

    public static int removePunishment(PunishmentData.Synced punishment) {
        return BanHammerImpl.removePunishment(punishment);
    }

    public static int removePunishment(UUID uuid, PunishmentType type) {
        return BanHammerImpl.removePunishment(uuid.toString(), type);
    }

    public static int removePunishment(String ip, PunishmentType type) {
        if (InetAddresses.isInetAddress((String)ip)) {
            return BanHammerImpl.removePunishment(ip, type);
        }
        return 0;
    }

    public static Collection<PunishmentData.Synced> getPunishments(String ip, PunishmentType type) {
        if (InetAddresses.isInetAddress((String)ip)) {
            return BanHammerImpl.getPlayersPunishments(ip, type);
        }
        return Collections.emptyList();
    }

    public static Collection<PunishmentData.Synced> getPunishments(UUID uuid, PunishmentType type) {
        return BanHammerImpl.getPlayersPunishments(uuid.toString(), type);
    }

    public static Collection<PunishmentData.Synced> getPunishments(String ip) {
        ArrayList<PunishmentData.Synced> list = new ArrayList<PunishmentData.Synced>();
        if (InetAddresses.isInetAddress((String)ip)) {
            for (PunishmentType type : PunishmentType.values()) {
                list.addAll(BanHammerImpl.getPlayersPunishments(ip, type));
            }
        }
        return list;
    }

    public static Collection<PunishmentData.Synced> getPunishments(UUID uuid) {
        ArrayList<PunishmentData.Synced> list = new ArrayList<PunishmentData.Synced>();
        String id = uuid.toString();
        for (PunishmentType type : PunishmentType.values()) {
            list.addAll(BanHammerImpl.getPlayersPunishments(id, type));
        }
        return list;
    }

    public static Collection<PunishmentData.Synced> getAllPunishments(PunishmentType type) {
        ArrayList<PunishmentData.Synced> list = new ArrayList<PunishmentData.Synced>();
        BanHammerImpl.DATABASE.getAllPunishments(type, list::add);
        return list;
    }

    public static Collection<PunishmentData.Synced> getAllPunishments() {
        ArrayList<PunishmentData.Synced> list = new ArrayList<PunishmentData.Synced>();
        for (PunishmentType type : PunishmentType.values()) {
            BanHammerImpl.DATABASE.getAllPunishments(type, list::add);
        }
        return list;
    }

    public static boolean isPunished(UUID uuid, PunishmentType type) {
        return BanHammerImpl.isPlayerPunished(uuid.toString(), type);
    }

    public static boolean isPunished(String ip, PunishmentType type) {
        if (InetAddresses.isInetAddress((String)ip)) {
            return BanHammerImpl.isPlayerPunished(ip, type);
        }
        return false;
    }

    public static void registerPunishmentEvent(PunishmentEvent event) {
        BanHammerImpl.PUNISHMENT_EVENT.register((Object)event);
    }

    public static void registerPunishmentCheckEvent(PunishmentCheckEvent event) {
        BanHammerImpl.CAN_PUNISH_CHECK_EVENT.register((Object)event);
    }

    public static void registerImporter(class_2960 identifier, PunishmentImporter importer) {
        BanHammerImpl.IMPORTERS.put(identifier.toString(), importer);
    }

    public static interface PunishmentImporter {
        @Deprecated
        default public boolean importPunishments(MinecraftServer server, Consumer<PunishmentData> consumer, boolean remove) {
            return false;
        }

        default public boolean importPunishments(MinecraftServer server, PunishmentConsumer consumer, boolean remove) {
            return this.importPunishments(server, consumer, remove);
        }

        public static interface PunishmentConsumer
        extends Consumer<PunishmentData> {
            public static PunishmentConsumer of(final Consumer<PunishmentData> active, final Consumer<PunishmentData> history) {
                return new PunishmentConsumer(){

                    @Override
                    public void accept(PunishmentData data) {
                        active.accept(data);
                    }

                    @Override
                    public void acceptHistory(PunishmentData data) {
                        history.accept(data);
                    }
                };
            }

            @Override
            public void accept(PunishmentData var1);

            public void acceptHistory(PunishmentData var1);
        }
    }

    @FunctionalInterface
    public static interface PunishmentCheckEvent {
        public TriState canSourcePunish(GameProfile var1, class_2168 var2);
    }

    @FunctionalInterface
    public static interface PunishmentEvent {
        public void onPunishment(PunishmentData var1, boolean var2, boolean var3);
    }
}

