/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.api;

import eu.pb4.banhammer.api.PunishmentType;
import eu.pb4.banhammer.impl.BHUtils;
import eu.pb4.banhammer.impl.config.Config;
import eu.pb4.banhammer.impl.config.ConfigManager;
import eu.pb4.banhammer.impl.config.data.DiscordMessageData;
import eu.pb4.banhammer.impl.config.data.MessageConfigData;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.EmptyNode;
import eu.pb4.placeholders.api.node.TextNode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;

public sealed class PunishmentData {
    public final PunishmentType type;
    public final long time;
    public final long duration;
    public final UUID playerUUID;
    public final String playerIP;
    public final UUID adminUUID;
    public final class_2561 adminDisplayName;
    public final String reason;
    public final class_2561 playerDisplayName;
    public final String playerName;

    @ApiStatus.Internal
    public PunishmentData(UUID playerUUID, String playerIP, class_2561 playerName, String playerNameRaw, UUID adminUUID, class_2561 adminDisplay, long time, long duration, String reason, PunishmentType type) {
        this.time = time;
        this.playerUUID = playerUUID;
        this.playerIP = playerIP;
        this.playerName = playerNameRaw;
        this.playerDisplayName = playerName;
        this.duration = duration;
        this.adminDisplayName = adminDisplay;
        this.adminUUID = adminUUID;
        this.reason = reason;
        this.type = type;
    }

    public static PunishmentData create(class_3222 punished, class_2168 admin, String reason, long duration, PunishmentType type) {
        return PunishmentData.create(punished.method_5667(), punished.method_14209(), punished.method_5476(), punished.method_7334().name(), admin, reason, duration, type);
    }

    public static PunishmentData create(UUID uuid, String ip, class_2561 displayName, String playerName, class_2168 admin, String reason, long duration, PunishmentType type) {
        return new PunishmentData(uuid, ip, displayName, playerName, admin.method_9228() != null ? admin.method_9228().method_5667() : class_156.field_25140, admin.method_9223(), BHUtils.getNow(), duration, reason, type);
    }

    public final boolean isExpired() {
        return this.isTemporary() && this.time + this.duration < System.currentTimeMillis() / 1000L;
    }

    public final Date getExpirationDate() {
        return this.isTemporary() ? new Date((this.time + this.duration) * 1000L) : new Date(0x7FFFFFFFFFFFFFFEL);
    }

    public final Date getDate() {
        return new Date(this.time * 1000L);
    }

    public final String getFormattedDate() {
        return ConfigManager.getConfig().dateTimeFormatter.format(this.getDate());
    }

    public final String getFormattedExpirationDate() {
        return this.isTemporary() ? ConfigManager.getConfig().dateTimeFormatter.format(this.getExpirationDate()) : ConfigManager.getConfig().neverExpires;
    }

    public final String getFormattedExpirationTime() {
        if (this.duration > -1L) {
            long x = this.duration + this.time - System.currentTimeMillis() / 1000L;
            MessageConfigData data = ConfigManager.getConfig().messageConfigData;
            long seconds = x % 60L;
            long minutes = x / 60L % 60L;
            long hours = x / 3600L % 24L;
            long days = x / 86400L % 365L;
            long years = x / 31536000L;
            StringBuilder builder = new StringBuilder();
            if (years > 0L) {
                builder.append(years).append(data.yearsText);
            }
            if (days > 0L) {
                builder.append(days).append(data.daysText);
            }
            if (hours > 0L) {
                builder.append(hours).append(data.hoursText);
            }
            if (minutes > 0L) {
                builder.append(minutes).append(data.minutesText);
            }
            if (seconds > 0L) {
                builder.append(seconds).append(data.secondsText);
            }
            return builder.toString();
        }
        return ConfigManager.getConfig().neverExpires;
    }

    public final class_2561 getDisconnectMessage(PlaceholderContext context) {
        EmptyNode message = switch (this.type) {
            case PunishmentType.KICK -> ConfigManager.getConfig().kickScreenMessage;
            case PunishmentType.BAN -> {
                if (this.isTemporary()) {
                    yield ConfigManager.getConfig().tempBanScreenMessage;
                }
                yield ConfigManager.getConfig().banScreenMessage;
            }
            case PunishmentType.IP_BAN -> {
                if (this.isTemporary()) {
                    yield ConfigManager.getConfig().tempIpBanScreenMessage;
                }
                yield ConfigManager.getConfig().ipBanScreenMessage;
            }
            case PunishmentType.MUTE -> {
                if (this.isTemporary()) {
                    yield ConfigManager.getConfig().tempMutedMessage;
                }
                yield ConfigManager.getConfig().mutedMessage;
            }
            default -> EmptyNode.INSTANCE;
        };
        return message.toText(context.asParserContext().with(Config.PLACEHOLDER, this.getPlaceholders()::get));
    }

    public final class_2561 getChatMessage(PlaceholderContext context) {
        TextNode message = switch (this.type) {
            default -> throw new MatchException(null, null);
            case PunishmentType.KICK -> ConfigManager.getConfig().kickChatMessage;
            case PunishmentType.BAN -> {
                if (this.isTemporary()) {
                    yield ConfigManager.getConfig().tempBanChatMessage;
                }
                yield ConfigManager.getConfig().banChatMessage;
            }
            case PunishmentType.IP_BAN -> {
                if (this.isTemporary()) {
                    yield ConfigManager.getConfig().tempIpBanChatMessage;
                }
                yield ConfigManager.getConfig().ipBanChatMessage;
            }
            case PunishmentType.MUTE -> {
                if (this.isTemporary()) {
                    yield ConfigManager.getConfig().tempMuteChatMessage;
                }
                yield ConfigManager.getConfig().muteChatMessage;
            }
            case PunishmentType.WARN -> this.isTemporary() ? ConfigManager.getConfig().tempWarnChatMessage : ConfigManager.getConfig().warnChatMessage;
        };
        return message.toText(context.asParserContext().with(Config.PLACEHOLDER, this.getPlaceholders()::get));
    }

    public final DiscordMessageData.Message getRawDiscordMessage() {
        DiscordMessageData.Message message = null;
        Config config = ConfigManager.getConfig();
        DiscordMessageData data = config.discordMessages;
        switch (this.type) {
            case KICK: {
                if (!data.sendKickMessage) break;
                message = data.kickMessage;
                break;
            }
            case BAN: {
                if (this.isTemporary() && data.sendTempBanMessage) {
                    message = data.tempBanMessage;
                    break;
                }
                if (!data.sendBanMessage) break;
                message = data.banMessage;
                break;
            }
            case IP_BAN: {
                if (this.isTemporary() && data.sendTempBanIpMessage) {
                    message = data.tempBanIpMessage;
                    break;
                }
                if (!data.sendBanIpMessage) break;
                message = data.banIpMessage;
                break;
            }
            case MUTE: {
                if (this.isTemporary() && data.sendTempMuteMessage) {
                    message = data.tempMuteMessage;
                    break;
                }
                if (!data.sendMuteMessage) break;
                message = data.muteMessage;
                break;
            }
            case WARN: {
                if (this.isTemporary() && data.sendTempWarnMessage) {
                    message = data.tempWarnMessage;
                    break;
                }
                if (!data.sendWarnMessage) break;
                message = data.warnMessage;
            }
        }
        return message;
    }

    public final Map<String, class_2561> getPlaceholders() {
        HashMap<String, class_2561> list = new HashMap<String, class_2561>();
        list.put("operator", (class_2561)this.adminDisplayName.method_27661());
        list.put("operator_uuid", (class_2561)class_2561.method_43470((String)this.adminUUID.toString()));
        list.put("reason", (class_2561)class_2561.method_43470((String)this.reason));
        list.put("expiration_date", (class_2561)class_2561.method_43470((String)this.getFormattedExpirationDate()));
        list.put("expiration_time", (class_2561)class_2561.method_43470((String)this.getFormattedExpirationTime()));
        list.put("banned", (class_2561)this.playerDisplayName.method_27661());
        list.put("banned_name", (class_2561)class_2561.method_43470((String)this.playerName));
        list.put("banned_uuid", (class_2561)class_2561.method_43470((String)this.playerUUID.toString()));
        return list;
    }

    public final Map<String, String> getStringPlaceholders() {
        HashMap<String, String> list = new HashMap<String, String>();
        list.put("operator", this.adminDisplayName.getString());
        list.put("operator_uuid", this.adminUUID.toString());
        list.put("reason", this.reason);
        list.put("expiration_date", this.getFormattedExpirationDate());
        list.put("expiration_time", this.getFormattedExpirationTime());
        list.put("expiration_timestamp", String.valueOf(this.getExpirationDate().getTime() / 1000L));
        list.put("banned", this.playerDisplayName.getString());
        list.put("banned_name", this.playerName);
        list.put("banned_uuid", this.playerUUID.toString());
        return list;
    }

    public final boolean isTemporary() {
        return this.duration > -1L;
    }

    public static final class Synced
    extends PunishmentData {
        private final long id;

        @ApiStatus.Internal
        public Synced(long id, UUID playerUUID, String playerIP, class_2561 playerName, String playerNameRaw, UUID adminUUID, class_2561 adminDisplay, long time, long duration, String reason, PunishmentType type) {
            super(playerUUID, playerIP, playerName, playerNameRaw, adminUUID, adminDisplay, time, duration, reason, type);
            this.id = id;
        }

        public final long getId() {
            return this.id;
        }
    }
}

