/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.GameProfile;
import eu.pb4.banhammer.api.BanHammer;
import eu.pb4.banhammer.api.PunishmentData;
import eu.pb4.banhammer.api.PunishmentType;
import eu.pb4.banhammer.api.TriState;
import eu.pb4.banhammer.impl.CardboardWarning;
import eu.pb4.banhammer.impl.GenericModInfo;
import eu.pb4.banhammer.impl.commands.GeneralCommands;
import eu.pb4.banhammer.impl.commands.PunishCommands;
import eu.pb4.banhammer.impl.commands.UnpunishCommands;
import eu.pb4.banhammer.impl.config.Config;
import eu.pb4.banhammer.impl.config.ConfigManager;
import eu.pb4.banhammer.impl.config.data.ConfigData;
import eu.pb4.banhammer.impl.config.database.DbConfig;
import eu.pb4.banhammer.impl.database.DatabaseHandlerInterface;
import eu.pb4.banhammer.impl.database.MySQLDatabase;
import eu.pb4.banhammer.impl.database.PostgreSQLDatabase;
import eu.pb4.banhammer.impl.database.SQLiteDatabase;
import eu.pb4.banhammer.impl.gson.CodecSerializer;
import eu.pb4.banhammer.impl.gson.LowercaseEnumTypeAdapterFactory;
import eu.pb4.banhammer.impl.importers.BanHammerJsonImporter;
import eu.pb4.banhammer.impl.importers.VanillaImport;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_11560;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BanHammerImpl
implements ModInitializer {
    public static final int LOWER_LIMIT = 32;
    public static final int UPPER_LIMIT = 64;
    public static final List<PunishmentData> CACHED_PUNISHMENTS = new CopyOnWriteArrayList<PunishmentData>();
    public static final Logger LOGGER = LogManager.getLogger((String)"BanHammer");
    public static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();
    public static final Event<BanHammer.PunishmentEvent> PUNISHMENT_EVENT = EventFactory.createArrayBacked(BanHammer.PunishmentEvent.class, callbacks -> (punishment, s, i) -> {
        for (BanHammer.PunishmentEvent callback : callbacks) {
            callback.onPunishment(punishment, s, i);
        }
    });
    public static final Event<BanHammer.PunishmentCheckEvent> CAN_PUNISH_CHECK_EVENT = EventFactory.createArrayBacked(BanHammer.PunishmentCheckEvent.class, callbacks -> (gameProfile, source) -> {
        for (BanHammer.PunishmentCheckEvent callback : callbacks) {
            TriState state = callback.canSourcePunish(gameProfile, source);
            if (state == TriState.DEFAULT) continue;
            return state;
        }
        return TriState.TRUE;
    });
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().registerTypeHierarchyAdapter(class_2561.class, CodecSerializer.TEXT).registerTypeAdapterFactory((TypeAdapterFactory)new LowercaseEnumTypeAdapterFactory()).create();
    public static MinecraftServer SERVER;
    public static DatabaseHandlerInterface DATABASE;
    public static ConcurrentHashMap<UUID, String> UUID_TO_IP_CACHE;
    public static ConcurrentHashMap<String, Set<UUID>> IP_TO_UUID_CACHE;
    public static HashMap<String, BanHammer.PunishmentImporter> IMPORTERS;

    public static void punishPlayer(PunishmentData punishment, boolean silent) {
        BanHammerImpl.punishPlayer(punishment, silent, false);
    }

    public static void punishPlayer(PunishmentData punishment, boolean silent, boolean invisible) {
        class_3222 player;
        Config config = ConfigManager.getConfig();
        if (config.configData.cachePunishmentsLocally && punishment.type.databaseName != null) {
            CACHED_PUNISHMENTS.add(punishment);
            if (CACHED_PUNISHMENTS.size() > 64) {
                int[] dynInt = new int[]{0};
                CACHED_PUNISHMENTS.removeIf(x -> {
                    int n = dynInt[0];
                    dynInt[0] = n + 1;
                    return n < 32 || x.isExpired();
                });
            }
        }
        CompletableFuture.runAsync(() -> {
            if (punishment.type.databaseName != null) {
                DATABASE.insertPunishment(punishment);
            }
            if (ConfigManager.getConfig().configData.storeAllPunishmentsInHistory) {
                DATABASE.insertPunishmentIntoHistory(punishment);
            }
            if (!invisible && !config.webhooks.isEmpty()) {
                HttpRequest.BodyPublisher json = HttpRequest.BodyPublishers.ofString(punishment.getRawDiscordMessage().build(punishment.getStringPlaceholders()));
                for (URI hook : config.webhooks) {
                    HTTP_CLIENT.sendAsync(HttpRequest.newBuilder().uri(hook).headers("Content-Type", "application/json").POST(json).build(), HttpResponse.BodyHandlers.discarding());
                }
            }
            if (punishment.type == PunishmentType.WARN) {
                int count = BanHammerImpl.getPlayersPunishments(punishment.playerUUID.toString(), PunishmentType.WARN).size() + 1;
                int distance = Integer.MAX_VALUE;
                List<String> actions = null;
                for (ConfigData.WarnAction act : config.configData.warnActions) {
                    int dist2 = count - act.count;
                    if (act.count > count || distance <= dist2) continue;
                    distance = dist2;
                    actions = act.execute;
                }
                if (actions != null) {
                    List<String> finalActions = actions;
                    SERVER.execute(() -> {
                        for (String i : finalActions) {
                            SERVER.method_3734().method_44252(SERVER.method_3739(), i.replace("${uuid}", punishment.playerUUID.toString()).replace("${name}", punishment.playerName).replace("${ip}", punishment.playerIP).replace("${reason}", punishment.reason).replace("${count}", "" + count));
                        }
                    });
                }
            }
        });
        if (punishment.type.kick && punishment.type.ipBased) {
            boolean alreadyStandardBanned = false;
            for (class_3222 player2 : SERVER.method_3760().method_14571()) {
                if (!player2.method_14209().equals(punishment.playerIP)) continue;
                player2.field_13987.method_52396(punishment.getDisconnectMessage(PlaceholderContext.of((class_3222)player2)));
                if (!ConfigManager.getConfig().configData.standardBanPlayersWithBannedIps || punishment.type != PunishmentType.IP_BAN) continue;
                PunishmentData punishment1 = new PunishmentData(player2.method_5667(), player2.method_14209(), player2.method_5476(), player2.method_7334().name(), punishment.adminUUID, punishment.adminDisplayName, punishment.time, punishment.duration, punishment.reason, PunishmentType.BAN);
                if (player2.method_5667() == punishment.playerUUID) {
                    alreadyStandardBanned = true;
                }
                BanHammerImpl.punishPlayer(punishment1, true, true);
            }
            if (ConfigManager.getConfig().configData.standardBanPlayersWithBannedIps && punishment.type == PunishmentType.IP_BAN && !alreadyStandardBanned) {
                PunishmentData punishment1 = new PunishmentData(punishment.playerUUID, punishment.playerIP, punishment.playerDisplayName, punishment.playerName, punishment.adminUUID, punishment.adminDisplayName, punishment.time, punishment.duration, punishment.reason, PunishmentType.BAN);
                BanHammerImpl.punishPlayer(punishment1, true, true);
            }
        } else if (punishment.type.kick && (player = SERVER.method_3760().method_14602(punishment.playerUUID)) != null) {
            player.field_13987.method_52396(punishment.getDisconnectMessage(PlaceholderContext.of((class_3222)player)));
        }
        if (!invisible) {
            if (!silent) {
                SERVER.method_3760().method_43514(punishment.getChatMessage(PlaceholderContext.of((GameProfile)new GameProfile(punishment.playerUUID, punishment.playerName), (MinecraftServer)SERVER)), false);
            } else {
                class_2561 message = punishment.getChatMessage(PlaceholderContext.of((GameProfile)new GameProfile(punishment.playerUUID, punishment.playerName), (MinecraftServer)SERVER));
                SERVER.method_43496(message);
                for (class_3222 player2 : SERVER.method_3760().method_14571()) {
                    if (!Permissions.check((class_2172)player2.method_64396(), (String)"banhammer.seesilent", (int)3)) continue;
                    player2.method_64398(message);
                }
            }
        }
        ((BanHammer.PunishmentEvent)PUNISHMENT_EVENT.invoker()).onPunishment(punishment, silent, invisible);
    }

    public static int removePunishment(String id, PunishmentType type) {
        CACHED_PUNISHMENTS.removeIf(x -> x.type == type && (x.type.ipBased ? x.playerIP.equals(id) : x.playerUUID.toString().equals(id)));
        return DATABASE.removePunishment(id, type);
    }

    public static int removePunishment(PunishmentData.Synced punishment) {
        return DATABASE.removePunishment(punishment.getId(), punishment.type);
    }

    public static List<PunishmentData.Synced> getPlayersPunishments(String id, PunishmentType type) {
        ArrayList<PunishmentData.Synced> punishments = new ArrayList<PunishmentData.Synced>();
        Consumer<PunishmentData.Synced> consumer = punishment -> {
            if (punishment.isExpired()) {
                DATABASE.removePunishment(punishment.getId(), punishment.type);
            } else {
                punishments.add((PunishmentData.Synced)punishment);
            }
        };
        if (type != null) {
            DATABASE.getPunishments(id, type, consumer);
        } else {
            for (PunishmentType type2 : PunishmentType.values()) {
                DATABASE.getPunishments(id, type2, consumer);
            }
        }
        return punishments;
    }

    public static boolean isPlayerPunished(String id, PunishmentType type) {
        ArrayList punishments = new ArrayList();
        DATABASE.getPunishments(id, type, punishments::add);
        for (PunishmentData.Synced punishment : punishments) {
            if (punishment.isExpired()) {
                DATABASE.removePunishment(punishment.getId(), type);
                continue;
            }
            return true;
        }
        return false;
    }

    public static void addPunishment(PunishmentData punishment) {
        if (punishment.isExpired()) {
            CompletableFuture.runAsync(() -> {
                if (ConfigManager.getConfig().configData.storeAllPunishmentsInHistory) {
                    DATABASE.insertPunishmentIntoHistory(punishment);
                }
            });
        } else {
            BanHammerImpl.punishPlayer(punishment, true, true);
        }
    }

    private void onServerStarting(MinecraftServer server) {
        CardboardWarning.checkAndAnnounce();
        SERVER = server;
        boolean loaded = ConfigManager.loadConfig();
        File ipCacheFile = Paths.get("ipcache.json", new String[0]).toFile();
        try {
            ConcurrentHashMap ipCache;
            ConcurrentHashMap concurrentHashMap = ipCache = ipCacheFile.exists() ? (ConcurrentHashMap)GSON.fromJson((Reader)new FileReader(ipCacheFile), new TypeToken<ConcurrentHashMap<String, String>>(this){}.getType()) : null;
            if (ipCache != null) {
                for (Map.Entry entry : ipCache.entrySet()) {
                    try {
                        UUID uuid = UUID.fromString((String)entry.getKey());
                        String ip = (String)entry.getValue();
                        if (uuid == null || ip == null) continue;
                        UUID_TO_IP_CACHE.put(uuid, ip);
                        IP_TO_UUID_CACHE.computeIfAbsent(ip, x -> new HashSet()).add(uuid);
                    }
                    catch (Exception uuid) {}
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Couldn't load ipcache.json! Creating new one...");
        }
        if (loaded) {
            Config config = ConfigManager.getConfig();
            try {
                switch (config.configData.databaseType.toLowerCase(Locale.ROOT)) {
                    case "sqlite": {
                        DATABASE = new SQLiteDatabase(config.configData.sqliteDatabaseLocation);
                        break;
                    }
                    case "mysql": {
                        DbConfig dbConfig = config.getDatabaseConfig("mysql");
                        DATABASE = new MySQLDatabase(dbConfig.address, dbConfig.database, dbConfig.username, dbConfig.password, config.configData.databaseArgs);
                        break;
                    }
                    case "postgresql": 
                    case "postgres": {
                        DbConfig dbConfig = config.getDatabaseConfig("postgresql");
                        DATABASE = new PostgreSQLDatabase(dbConfig.address, dbConfig.database, dbConfig.username, dbConfig.password, config.configData.databaseArgs);
                        break;
                    }
                    default: {
                        LOGGER.error("Config file is invalid (database)! Stopping server...");
                        server.method_3782();
                        return;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("Couldn't connect to database! Stopping server...");
                server.method_3782();
                return;
            }
            IMPORTERS.put("vanilla", new VanillaImport());
            IMPORTERS.put("banhammer_export", new BanHammerJsonImporter());
            LOGGER.info("BanHammer connected successfully to " + DATABASE.name() + " database!");
        } else {
            LOGGER.error("Config file is invalid! Stopping server...");
            server.method_3782();
        }
    }

    public void onInitialize() {
        CardboardWarning.checkAndAnnounce();
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStarting);
        GenericModInfo.build((ModContainer)FabricLoader.getInstance().getModContainer("banhammer").get());
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            if (DATABASE != null) {
                DATABASE.closeConnection();
            }
            SERVER = null;
            DATABASE = null;
            File ipcacheFile = Paths.get("ipcache.json", new String[0]).toFile();
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(ipcacheFile));
                HashMap<String, String> ipCache = new HashMap<String, String>();
                for (Map.Entry<UUID, String> entry : UUID_TO_IP_CACHE.entrySet()) {
                    ipCache.put(entry.getKey().toString(), entry.getValue());
                }
                writer.write(GSON.toJson(ipCache));
                writer.close();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        });
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, sender, params) -> {
            List<PunishmentData.Synced> punishments = BanHammerImpl.getPlayersPunishments(sender.method_5845(), PunishmentType.MUTE);
            if (!punishments.isEmpty()) {
                PunishmentData.Synced punishment = punishments.getFirst();
                sender.method_7353(punishment.getDisconnectMessage(PlaceholderContext.of((class_3222)sender)), false);
                return false;
            }
            return true;
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            String ip = handler.field_14140.method_14209();
            Set<UUID> associatedAccounts = IP_TO_UUID_CACHE.get(ip);
            if (associatedAccounts.size() <= 1) {
                return;
            }
            LinkedList<class_5250> playerMessages = new LinkedList<class_5250>();
            for (UUID player : associatedAccounts) {
                String name = SERVER.method_73550().comp_4407().method_14512(player).map(class_11560::comp_4423).orElse(player.toString());
                class_5250 text = class_2561.method_43470((String)("[" + name + "]"));
                List<PunishmentData.Synced> punishments = BanHammerImpl.getPlayersPunishments(player.toString(), PunishmentType.BAN);
                playerMessages.add(text);
                if (SERVER.method_3760().method_14602(player) != null || player.equals(handler.field_14140.method_5667())) {
                    text.method_27692(class_124.field_1060);
                    continue;
                }
                if (punishments.isEmpty()) {
                    text.method_27692(class_124.field_1080);
                    continue;
                }
                text.method_27692(class_124.field_1061);
                PunishmentData.Synced punishment = punishments.getFirst();
                text.method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613(punishment.getChatMessage(PlaceholderContext.of((GameProfile)new GameProfile(punishment.playerUUID, punishment.playerName), (MinecraftServer)SERVER)))));
            }
            class_2561 message = class_2564.method_37112(playerMessages, (class_2561)class_2561.method_43470((String)" "));
            SERVER.method_43496(message);
            for (class_3222 player : SERVER.method_3760().method_14571()) {
                if (!Permissions.check((class_2172)player.method_64396(), (String)"banhammer.seeassociated", (int)3)) continue;
                player.method_64398(message);
            }
        });
        PunishCommands.register();
        UnpunishCommands.register();
        GeneralCommands.register();
    }

    static {
        UUID_TO_IP_CACHE = new ConcurrentHashMap();
        IP_TO_UUID_CACHE = new ConcurrentHashMap();
        IMPORTERS = new HashMap();
    }

    public static final class IpCacheFile {
        public int version = 1;
        public Map<String, String> data = new HashMap<String, String>();
    }
}

