/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.impl.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.banhammer.api.PunishmentType;
import eu.pb4.banhammer.impl.BHPlayerData;
import eu.pb4.banhammer.impl.BHUtils;
import eu.pb4.banhammer.impl.BanHammerImpl;
import eu.pb4.banhammer.impl.commands.GeneralCommands;
import eu.pb4.banhammer.impl.config.Config;
import eu.pb4.banhammer.impl.config.ConfigManager;
import eu.pb4.banhammer.impl.config.data.DiscordMessageData;
import eu.pb4.placeholders.api.node.TextNode;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class UnpunishCommands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register(UnpunishCommands.create("unban", PunishmentType.BAN));
            dispatcher.register(UnpunishCommands.create("unban-ip", PunishmentType.IP_BAN));
            dispatcher.register(UnpunishCommands.create("unmute", PunishmentType.MUTE));
            dispatcher.register(UnpunishCommands.create("unwarn", PunishmentType.WARN));
            dispatcher.register(UnpunishCommands.create("pardon", null));
        });
    }

    private static LiteralArgumentBuilder<class_2168> create(String command, PunishmentType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)command).requires(ConfigManager.requirePermissionOrOp("banhammer.unpunish." + command))).then(((RequiredArgumentBuilder)GeneralCommands.playerArgument("player").executes(ctx -> UnpunishCommands.removePunishmentCommand((CommandContext<class_2168>)ctx, type))).then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> UnpunishCommands.removePunishmentCommand((CommandContext<class_2168>)ctx, type))));
    }

    private static int removePunishmentCommand(CommandContext<class_2168> ctx, PunishmentType type) {
        CompletableFuture.runAsync(() -> {
            String reason;
            boolean isSilent;
            class_3222 executor;
            Config config = ConfigManager.getConfig();
            String playerNameOrIp = (String)ctx.getArgument("player", String.class);
            Collection<BHPlayerData> players = BHUtils.lookupPlayerData(playerNameOrIp, ((class_2168)ctx.getSource()).method_9211());
            if (players.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Couldn't find player " + playerNameOrIp + "!")).method_27692(class_124.field_1061), false);
            }
            try {
                executor = ((class_2168)ctx.getSource()).method_44023();
            }
            catch (Exception e) {
                executor = null;
            }
            try {
                String temp = (String)ctx.getArgument("reason", String.class);
                if (temp.startsWith("-")) {
                    String[] parts = temp.split(" ", 2);
                    isSilent = parts[0].contains("s");
                    reason = parts.length == 2 ? parts[1] : config.defaultReason;
                } else {
                    reason = temp;
                    isSilent = false;
                }
            }
            catch (Exception e) {
                reason = config.defaultReason;
                isSilent = false;
            }
            for (BHPlayerData player : players) {
                TextNode message = null;
                String altMessage = "";
                int n = 0;
                if (type != null) {
                    switch (type) {
                        case BAN: {
                            n += BanHammerImpl.removePunishment(player.uuid().toString(), PunishmentType.BAN);
                            message = config.unbanChatMessage;
                            altMessage = "This player wasn't banned!";
                            break;
                        }
                        case IP_BAN: {
                            if (player.ip() != null) {
                                n += BanHammerImpl.removePunishment(player.ip(), PunishmentType.IP_BAN);
                            }
                            if (type == PunishmentType.IP_BAN && ConfigManager.getConfig().configData.standardBanPlayersWithBannedIps) {
                                n += BanHammerImpl.removePunishment(player.uuid().toString(), PunishmentType.BAN);
                            }
                            message = config.ipUnbanChatMessage;
                            altMessage = "This player wasn't ipbanned!";
                            break;
                        }
                        case MUTE: {
                            n += BanHammerImpl.removePunishment(player.uuid().toString(), PunishmentType.MUTE);
                            message = config.unmuteChatMessage;
                            altMessage = "This player wasn't muted!";
                            break;
                        }
                        case WARN: {
                            n += BanHammerImpl.removePunishment(player.uuid().toString(), PunishmentType.WARN);
                            message = config.unwarnChatMessage;
                            altMessage = "This player wasn't warned!";
                        }
                    }
                } else {
                    if (player.uuid() != null) {
                        String uuid = player.uuid().toString();
                        n += BanHammerImpl.removePunishment(uuid, PunishmentType.BAN);
                        n += BanHammerImpl.removePunishment(uuid, PunishmentType.WARN);
                        n += BanHammerImpl.removePunishment(uuid, PunishmentType.MUTE);
                    }
                    if (player.ip() != null) {
                        n += BanHammerImpl.removePunishment(player.ip(), PunishmentType.IP_BAN);
                    }
                    message = config.pardonChatMessage;
                    altMessage = "This player didn't have any punishments!";
                }
                if (n > 0) {
                    DiscordMessageData.Message tempMessage;
                    HashMap<String, Object> list = new HashMap<String, Object>();
                    list.put("operator", ((class_2168)ctx.getSource()).method_9223());
                    list.put("banned", class_2561.method_43470((String)player.name()));
                    list.put("banned_uuid", class_2561.method_43470((String)player.uuid().toString()));
                    list.put("reason", class_2561.method_43470((String)reason));
                    class_2561 textMessage = message.toText(player.placeholderContext(((class_2168)ctx.getSource()).method_9211()).asParserContext().with(Config.PLACEHOLDER, list::get));
                    if (config.configData.punishmentsAreSilent || isSilent) {
                        if (player.player() != null) {
                            player.player().method_7353(textMessage, false);
                        }
                        ((class_2168)ctx.getSource()).method_9226(() -> textMessage, false);
                    } else {
                        ((class_2168)ctx.getSource()).method_9226(() -> textMessage, false);
                        for (class_3222 player2 : ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571()) {
                            if (player2 == executor) continue;
                            player2.method_64398(textMessage);
                        }
                    }
                    if (config.webhooks.isEmpty()) continue;
                    DiscordMessageData data = config.discordMessages;
                    if (type != null) {
                        tempMessage = switch (type) {
                            default -> throw new MatchException(null, null);
                            case PunishmentType.BAN -> {
                                if (data.sendUnbanMessage) {
                                    yield data.unbanMessage;
                                }
                                yield null;
                            }
                            case PunishmentType.IP_BAN -> {
                                if (data.sendUnbanIpMessage) {
                                    yield data.unBanIpMessage;
                                }
                                yield null;
                            }
                            case PunishmentType.MUTE -> {
                                if (data.sendUnmuteMessage) {
                                    yield data.unmuteMessage;
                                }
                                yield null;
                            }
                            case PunishmentType.WARN -> {
                                if (data.sendUnwarnMessage) {
                                    yield data.unwarnMessage;
                                }
                                yield null;
                            }
                            case PunishmentType.KICK -> null;
                        };
                    } else {
                        DiscordMessageData.Message message2 = tempMessage = data.sendPardonMessage ? data.pardonMessage : null;
                    }
                    if (tempMessage == null) continue;
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("operator", ((class_2168)ctx.getSource()).method_9223().getString());
                    placeholders.put("banned", player.name());
                    placeholders.put("banned_uuid", player.uuid().toString());
                    placeholders.put("reason", reason);
                    HttpRequest.BodyPublisher msg = HttpRequest.BodyPublishers.ofString(tempMessage.build(placeholders));
                    for (URI hook : config.webhooks) {
                        BanHammerImpl.HTTP_CLIENT.sendAsync(HttpRequest.newBuilder().uri(hook).headers("Content-Type", "application/json").POST(msg).build(), HttpResponse.BodyHandlers.discarding());
                    }
                    continue;
                }
                String finalAltMessage = altMessage;
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)finalAltMessage).method_27692(class_124.field_1061), false);
            }
        });
        return 1;
    }
}

