/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.impl.database;

import com.mysql.cj.jdbc.MysqlConnectionPoolDataSource;
import eu.pb4.banhammer.impl.config.ConfigManager;
import eu.pb4.banhammer.impl.database.MiniConnectionPoolManager;
import eu.pb4.banhammer.impl.database.PooledSQLDatabase;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionPoolDataSource;

public class MySQLDatabase
extends PooledSQLDatabase {
    public MySQLDatabase(String address, String database, String username, String password, Map<String, String> args) throws Exception {
        Class.forName("com.mysql.cj.jdbc.Driver");
        StringBuilder argBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iter = args.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> arg = iter.next();
            argBuilder.append(arg.getKey()).append("=").append(arg.getValue());
            if (!iter.hasNext()) continue;
            argBuilder.append("&");
        }
        MysqlConnectionPoolDataSource source = new MysqlConnectionPoolDataSource();
        source.setUrl("jdbc:mysql://" + address + "/" + database + (String)(argBuilder.isEmpty() ? "" : "?" + String.valueOf(argBuilder)));
        source.setUser(username);
        source.setPassword(password);
        source.setDatabaseName(database);
        this.manager = new MiniConnectionPoolManager((ConnectionPoolDataSource)source, ConfigManager.getConfig().configData.databaseMaxConnections);
        this.createTables();
    }

    @Override
    protected String getTableCreation() {
        return "CREATE TABLE IF NOT EXISTS %s (id INTEGER PRIMARY KEY AUTO_INCREMENT, bannedUUID varchar(36), bannedIP varchar(40), bannedName varchar(64), bannedDisplay TEXT, adminUUID varchar(36), adminDisplay TEXT, time BIGINT, duration BIGINT, reason TEXT)";
    }

    @Override
    protected String getHistoryTableCreation(String prefix) {
        return "CREATE TABLE IF NOT EXISTS " + prefix + "history (id INTEGER PRIMARY KEY AUTO_INCREMENT, bannedUUID varchar(36), bannedIP varchar(40), bannedName varchar(64), bannedDisplay TEXT, adminUUID varchar(36), adminDisplay TEXT, time BIGINT, duration BIGINT, reason TEXT, type varchar(16))";
    }

    @Override
    public String name() {
        return "MySQL";
    }
}

