/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.impl.database;

import eu.pb4.banhammer.impl.config.ConfigManager;
import eu.pb4.banhammer.impl.database.MiniConnectionPoolManager;
import eu.pb4.banhammer.impl.database.PooledSQLDatabase;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionPoolDataSource;
import org.postgresql.ds.PGConnectionPoolDataSource;

public class PostgreSQLDatabase
extends PooledSQLDatabase {
    public PostgreSQLDatabase(String address, String database, String username, String password, Map<String, String> args) throws Exception {
        Class.forName("org.postgresql.Driver");
        StringBuilder argBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iter = args.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> arg = iter.next();
            argBuilder.append(arg.getKey()).append("=").append(arg.getValue());
            if (!iter.hasNext()) continue;
            argBuilder.append("&");
        }
        PGConnectionPoolDataSource source = new PGConnectionPoolDataSource();
        source.setUrl("jdbc:postgresql://" + address + "/" + database + (String)(argBuilder.isEmpty() ? "" : "?" + String.valueOf(argBuilder)));
        source.setUser(username);
        source.setPassword(password);
        source.setDatabaseName(database);
        this.manager = new MiniConnectionPoolManager((ConnectionPoolDataSource)source, ConfigManager.getConfig().configData.databaseMaxConnections);
        this.createTables();
    }

    @Override
    protected String getTableCreation() {
        return "CREATE TABLE IF NOT EXISTS %s (id SERIAL PRIMARY KEY, bannedUUID varchar(36), bannedIP varchar(40), bannedName varchar(64), bannedDisplay TEXT, adminUUID varchar(36), adminDisplay TEXT, time BIGINT, duration BIGINT, reason TEXT)";
    }

    @Override
    protected String getHistoryTableCreation(String prefix) {
        return "CREATE TABLE IF NOT EXISTS " + prefix + "history (id SERIAL PRIMARY KEY, bannedUUID varchar(36), bannedIP varchar(40), bannedName varchar(64), bannedDisplay TEXT, adminUUID varchar(36), adminDisplay TEXT, time BIGINT, duration BIGINT, reason TEXT, type varchar(16))";
    }

    @Override
    public String name() {
        return "PostgreSQL";
    }
}

