/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.impl.importers;

import eu.pb4.banhammer.api.BanHammer;
import eu.pb4.banhammer.api.PunishmentData;
import eu.pb4.banhammer.api.PunishmentType;
import eu.pb4.banhammer.impl.BanHammerImpl;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;

public final class BanHammerJsonImporter
implements BanHammer.PunishmentImporter {
    public static final Path DEFAULT_PATH = FabricLoader.getInstance().getGameDir().resolve("banhammer_exports.json");

    public static String exportJson(boolean history) {
        return BanHammerImpl.GSON.toJson((Object)BanHammerJsonImporter.export(history));
    }

    @Override
    public boolean importPunishments(MinecraftServer server, BanHammer.PunishmentImporter.PunishmentConsumer consumer, boolean remove) {
        try {
            Serialized obj = (Serialized)BanHammerImpl.GSON.fromJson(Files.readString(DEFAULT_PATH), Serialized.class);
            if (obj.active != null) {
                obj.active.forEach(consumer);
            }
            if (obj.history != null) {
                obj.history.forEach(consumer::acceptHistory);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Serialized export(boolean history) {
        Serialized serialized = new Serialized();
        HashSet<PunishmentData> punishments = new HashSet<PunishmentData>();
        serialized.active = punishments;
        for (PunishmentType type : PunishmentType.values()) {
            if (!type.useDatabase()) continue;
            BanHammerImpl.DATABASE.getAllPunishments(type, p -> {
                if (!p.isExpired()) {
                    punishments.add((PunishmentData)p);
                }
            });
        }
        if (history) {
            serialized.history = new ArrayList<PunishmentData>();
            BanHammerImpl.DATABASE.getAllPunishmentsHistory(serialized.history::add);
        }
        return serialized;
    }

    public static class Serialized {
        public Collection<PunishmentData> active;
        public Collection<PunishmentData> history;
    }
}

