/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.mixin;

import com.mojang.authlib.GameProfile;
import eu.pb4.banhammer.api.PunishmentData;
import eu.pb4.banhammer.api.PunishmentType;
import eu.pb4.banhammer.impl.BHUtils;
import eu.pb4.banhammer.impl.BanHammerImpl;
import eu.pb4.banhammer.impl.config.ConfigManager;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_11560;
import net.minecraft.class_2561;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3324.class})
public class PlayerManagerMixin {
    @Shadow
    @Final
    private MinecraftServer field_14360;

    @Inject(method={"method_14586(Ljava/net/SocketAddress;Lnet/minecraft/class_11560;)Lnet/minecraft/class_2561;"}, at={@At(value="HEAD")})
    private void banHammer_cachePlayersIP(SocketAddress address, class_11560 profile, CallbackInfoReturnable<class_2561> cir) {
        if (address != null) {
            String stringAddress = BHUtils.stringifyAddress(address);
            BanHammerImpl.UUID_TO_IP_CACHE.put(profile.comp_4422(), stringAddress);
            BanHammerImpl.IP_TO_UUID_CACHE.computeIfAbsent(stringAddress, ip -> new HashSet()).add(profile.comp_4422());
        }
    }

    @Inject(method={"method_14586(Ljava/net/SocketAddress;Lnet/minecraft/class_11560;)Lnet/minecraft/class_2561;"}, at={@At(value="TAIL")}, cancellable=true)
    private void banHammer_checkIfBanned(SocketAddress address, class_11560 profile, CallbackInfoReturnable<class_2561> cir) {
        PunishmentData punishment = null;
        if (address == null || profile == null) {
            return;
        }
        String ip = BHUtils.stringifyAddress(address);
        for (PunishmentData pos : BanHammerImpl.CACHED_PUNISHMENTS) {
            if (pos.isExpired() || (pos.type != PunishmentType.IP_BAN || !pos.playerIP.equals(ip)) && (pos.type != PunishmentType.BAN || !pos.playerUUID.equals(profile.comp_4422()))) continue;
            punishment = pos;
            break;
        }
        if (punishment == null) {
            List<PunishmentData.Synced> bans = BanHammerImpl.getPlayersPunishments(profile.comp_4422().toString(), PunishmentType.BAN);
            List<PunishmentData.Synced> ipBans = BanHammerImpl.getPlayersPunishments(ip, PunishmentType.IP_BAN);
            if (!bans.isEmpty()) {
                punishment = bans.getFirst();
            } else if (!ipBans.isEmpty()) {
                punishment = ipBans.getFirst();
            }
        }
        if (punishment != null) {
            if (punishment.type == PunishmentType.IP_BAN && ConfigManager.getConfig().configData.standardBanPlayersWithBannedIps) {
                boolean silent = ConfigManager.getConfig().configData.autoBansFromIpBansAreSilent;
                PunishmentData punishment1 = new PunishmentData(profile.comp_4422(), BHUtils.stringifyAddress(address), (class_2561)class_2561.method_43470((String)profile.comp_4423()), profile.comp_4423(), punishment.adminUUID, punishment.adminDisplayName, punishment.time, punishment.duration, punishment.reason, PunishmentType.BAN);
                BanHammerImpl.punishPlayer(punishment1, silent, silent);
            }
            cir.setReturnValue((Object)punishment.getDisconnectMessage(PlaceholderContext.of((GameProfile)new GameProfile(profile.comp_4422(), profile.comp_4423()), (MinecraftServer)this.field_14360)));
        }
    }
}

