/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.impl;

import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import eu.pb4.banhammer.api.BanHammer;
import eu.pb4.banhammer.impl.BHPlayerData;
import eu.pb4.banhammer.impl.BanHammerImpl;
import eu.pb4.banhammer.impl.config.ConfigManager;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_11560;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3327;
import net.minecraft.server.MinecraftServer;

public final class BHUtils {
    private static final class_2561 UNKNOWN_PLAYER = class_2561.method_43470((String)"Unknown player").method_27692(class_124.field_1056);

    public static String stringifyAddress(SocketAddress socketAddress) {
        String string = socketAddress.toString();
        if (string.contains("/")) {
            string = string.substring(string.indexOf(47) + 1);
        }
        if (string.contains(":")) {
            string = string.substring(0, string.indexOf(58));
        }
        return string;
    }

    public static long parseDuration(String text) throws NumberFormatException {
        text = text.toLowerCase(Locale.ROOT);
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            String[] times = text.replaceAll("([a-z]+)", "$1|").split("\\|");
            long time = 0L;
            for (String x : times) {
                String numberOnly = x.replaceAll("[a-z]", "");
                String suffixOnly = x.replaceAll("[^a-z]", "");
                double d = time;
                time = (long)(d + (switch (suffixOnly) {
                    case "c" -> Double.parseDouble(numberOnly) * 60.0 * 60.0 * 24.0 * 365.0 * 100.0;
                    case "y", "year", "years" -> Double.parseDouble(numberOnly) * 60.0 * 60.0 * 24.0 * 365.0;
                    case "mo", "month", "months" -> Double.parseDouble(numberOnly) * 60.0 * 60.0 * 24.0 * 30.0;
                    case "w", "week", "weeks" -> Double.parseDouble(numberOnly) * 60.0 * 60.0 * 24.0 * 7.0;
                    case "d", "day", "days" -> Double.parseDouble(numberOnly) * 60.0 * 60.0 * 24.0;
                    case "h", "hour", "hours" -> Double.parseDouble(numberOnly) * 60.0 * 60.0;
                    case "m", "minute", "minutes" -> Double.parseDouble(numberOnly) * 60.0;
                    default -> Double.parseDouble(numberOnly);
                }));
            }
            return time;
        }
    }

    public static boolean isPunishableBy(GameProfile profile, class_2168 source) {
        MinecraftServer server = source.method_9211();
        class_3327 entry = (class_3327)server.method_3760().method_14603().method_14640((Object)new class_11560(profile));
        boolean permission = true;
        try {
            permission = Permissions.check((class_2172)source, (String)"banhammer.can_ban_admins") || (Boolean)Permissions.check((GameProfile)profile, (String)"banhammer.block_punishments").get() == false;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return server.method_16898().equals("Server") && source.method_9228() == null || (entry == null || source.method_9259(entry.method_14623())) && ConfigManager.getConfig().canPunish(profile) && permission && ((BanHammer.PunishmentCheckEvent)BanHammerImpl.CAN_PUNISH_CHECK_EVENT.invoker()).canSourcePunish(profile, source).get();
    }

    public static Collection<BHPlayerData> lookupPlayerData(String usernameOrIp, MinecraftServer server) {
        try {
            class_3222 player;
            boolean isUuid;
            boolean isIpLike = InetAddresses.isInetAddress((String)usernameOrIp);
            UUID uuid = null;
            try {
                uuid = UUID.fromString(usernameOrIp);
                isUuid = true;
            }
            catch (Exception e) {
                isUuid = false;
            }
            class_3222 class_32222 = isUuid ? server.method_3760().method_14602(uuid) : (player = isIpLike ? null : server.method_3760().method_14566(usernameOrIp));
            if (player != null) {
                return List.of(new BHPlayerData(player.method_7334(), player.method_14209(), player.method_5476(), player));
            }
            if (isIpLike) {
                Set<UUID> uuids = BanHammerImpl.IP_TO_UUID_CACHE.get(usernameOrIp);
                if (uuids.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<BHPlayerData> list = new ArrayList<BHPlayerData>();
                for (UUID uuid2 : uuids) {
                    Optional optional = server.method_73550().comp_4407().method_14512(uuid2);
                    if (optional.isPresent()) {
                        class_11560 profile = (class_11560)optional.get();
                        list.add(new BHPlayerData(new GameProfile(profile.comp_4422(), profile.comp_4423()), usernameOrIp, (class_2561)class_2561.method_43470((String)profile.comp_4423()), server.method_3760().method_14602(profile.comp_4422())));
                        continue;
                    }
                    list.add(new BHPlayerData(new GameProfile(uuid2, null), usernameOrIp, (class_2561)class_2561.method_43470((String)("??: " + String.valueOf(uuid2))).method_27692(class_124.field_1056), null));
                }
                return list;
            }
            String ip = "unknown";
            GameProfile profile = null;
            if (isUuid) {
                ip = BanHammerImpl.UUID_TO_IP_CACHE.getOrDefault(uuid, "unknown");
                class_11560 tmp = server.method_73550().comp_4407().method_14512(uuid).orElse(null);
                profile = tmp != null ? new GameProfile(tmp.comp_4422(), tmp.comp_4423()) : null;
            } else {
                Optional possibleProfile = server.method_73550().comp_4407().method_14515(usernameOrIp);
                if (possibleProfile.isPresent()) {
                    profile = new GameProfile(((class_11560)possibleProfile.get()).comp_4422(), ((class_11560)possibleProfile.get()).comp_4423(), PropertyMap.EMPTY);
                    ip = BanHammerImpl.UUID_TO_IP_CACHE.getOrDefault(profile.id(), "unknown");
                }
            }
            if (profile == null) {
                return List.of(new BHPlayerData(new GameProfile(uuid, ""), ip, UNKNOWN_PLAYER, null));
            }
            return List.of(new BHPlayerData(profile, ip, (class_2561)class_2561.method_43470((String)profile.name()), null));
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static long getNow() {
        return System.currentTimeMillis() / 1000L;
    }
}

