/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.impl.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.banhammer.api.BanHammer;
import eu.pb4.banhammer.api.PunishmentData;
import eu.pb4.banhammer.impl.BHPlayerData;
import eu.pb4.banhammer.impl.BHUtils;
import eu.pb4.banhammer.impl.BanHammerImpl;
import eu.pb4.banhammer.impl.GenericModInfo;
import eu.pb4.banhammer.impl.config.ConfigManager;
import eu.pb4.banhammer.impl.importers.BanHammerJsonImporter;
import eu.pb4.sgui.api.elements.BookElementBuilder;
import eu.pb4.sgui.api.gui.BookGui;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;

public class GeneralCommands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"banhammer").requires(Permissions.require((String)"banhammer.commands.main", (boolean)true))).executes(GeneralCommands::about)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"banhammer.commands.reload", (int)4))).executes(GeneralCommands::reloadConfig))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"import").requires(Permissions.require((String)"banhammer.commands.import", (int)4))).then(((RequiredArgumentBuilder)GeneralCommands.importArgument("source").executes(ctx -> GeneralCommands.importer((CommandContext<class_2168>)ctx, false))).then(class_2170.method_9247((String)"remove").executes(ctx -> GeneralCommands.importer((CommandContext<class_2168>)ctx, true)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"export_all_punishments").requires(Permissions.require((String)"banhammer.commands.export", (int)4))).executes(ctx -> GeneralCommands.exporter((CommandContext<class_2168>)ctx, false))).then(class_2170.method_9247((String)"with_history").executes(ctx -> GeneralCommands.exporter((CommandContext<class_2168>)ctx, true))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(Permissions.require((String)"banhammer.commands.list", (int)4))).then(GeneralCommands.playerArgument("player").executes(GeneralCommands::listBans)))));
    }

    private static int listBans(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 mainPlayer = ((class_2168)ctx.getSource()).method_44023();
        CompletableFuture.runAsync(() -> {
            ArrayList<PunishmentData> punishments = new ArrayList<PunishmentData>();
            String playerNameOrIp = (String)ctx.getArgument("player", String.class);
            Collection<BHPlayerData> players = BHUtils.lookupPlayerData(playerNameOrIp, ((class_2168)ctx.getSource()).method_9211());
            if (players.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Player not found!").method_27692(class_124.field_1061), false);
                return;
            }
            for (BHPlayerData player : players) {
                if (ConfigManager.getConfig().configData.storeAllPunishmentsInHistory) {
                    BanHammerImpl.DATABASE.getPunishmentsHistory(player.uuid().toString(), punishments::add);
                    continue;
                }
                punishments.addAll(BanHammerImpl.getPlayersPunishments(player.uuid().toString(), null));
            }
            punishments.sort(Comparator.comparingLong(e -> -e.time));
            BookElementBuilder book = new BookElementBuilder();
            for (PunishmentData p : punishments) {
                book.addPage(new class_2561[]{class_2561.method_43470((String)"User: ").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)p.playerName).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(false)))), class_2561.method_43470((String)"Type: ").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)p.type.name).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(false)))), class_2561.method_43470((String)"Date: ").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)p.getFormattedDate()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(false)))), class_2561.method_43470((String)"Expires: ").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)p.getFormattedExpirationDate()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(false)))), class_2561.method_43470((String)"By: ").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))).method_10852((class_2561)p.adminDisplayName.method_27661().method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(p.adminDisplayName.method_10866().method_10984())))), class_2561.method_43470((String)"Reason: ").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))).method_10852((class_2561)class_2561.method_43470((String)p.reason).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(false))))});
            }
            ((class_2168)ctx.getSource()).method_9211().execute(() -> {
                try {
                    new BookGui(mainPlayer, book).open();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        });
        return 0;
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        if (ConfigManager.loadConfig()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Reloaded config!"), false);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Error accrued while reloading config!").method_27692(class_124.field_1061));
        }
        return 1;
    }

    private static int about(CommandContext<class_2168> context) {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            GenericModInfo.build((ModContainer)FabricLoader.getInstance().getModContainer("banhammer").get());
        }
        for (class_2561 text : ((class_2168)context.getSource()).method_9228() instanceof class_3222 ? GenericModInfo.getAboutFull() : GenericModInfo.getAboutConsole()) {
            ((class_2168)context.getSource()).method_9226(() -> text, false);
        }
        return 1;
    }

    private static int importer(CommandContext<class_2168> context, boolean remove) {
        String type = (String)context.getArgument("source", String.class);
        BanHammer.PunishmentImporter importer = BanHammerImpl.IMPORTERS.get(type);
        if (importer != null) {
            ArrayList history = new ArrayList();
            ArrayList active = new ArrayList();
            boolean result = importer.importPunishments(((class_2168)context.getSource()).method_9211(), BanHammer.PunishmentImporter.PunishmentConsumer.of(active::add, history::add), remove);
            for (PunishmentData p : active) {
                BanHammerImpl.punishPlayer(p, true, true);
            }
            if (ConfigManager.getConfig().configData.storeAllPunishmentsInHistory && !history.isEmpty()) {
                CompletableFuture.runAsync(() -> {
                    for (PunishmentData p : history) {
                        BanHammerImpl.DATABASE.insertPunishmentIntoHistory(p);
                    }
                });
            }
            if (result) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully imported punishments!").method_27692(class_124.field_1060), false);
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Couldn't import punishments!"));
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid importer type!"));
        return 0;
    }

    private static int exporter(CommandContext<class_2168> context, boolean history) {
        CompletableFuture.runAsync(() -> {
            try {
                Files.writeString(BanHammerJsonImporter.DEFAULT_PATH, (CharSequence)BanHammerJsonImporter.exportJson(history), new OpenOption[0]);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully exported punishments to banhammer_exports.json file!").method_27692(class_124.field_1060), false);
            }
            catch (Throwable e) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Couldn't export punishments!"));
                e.printStackTrace();
            }
        });
        return 0;
    }

    public static RequiredArgumentBuilder<class_2168, String> importArgument(String name) {
        return class_2170.method_9244((String)name, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            for (String type : BanHammerImpl.IMPORTERS.keySet()) {
                if (!type.contains(remaining)) continue;
                builder.suggest(type);
            }
            return builder.buildFuture();
        });
    }

    public static RequiredArgumentBuilder<class_2168, String> playerArgument(String name) {
        return class_2170.method_9244((String)name, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            for (String player : ((class_2168)ctx.getSource()).method_9211().method_3858()) {
                if (!player.toLowerCase(Locale.ROOT).contains(remaining)) continue;
                builder.suggest(player);
            }
            return builder.buildFuture();
        });
    }
}

