/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.impl.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.banhammer.api.PunishmentData;
import eu.pb4.banhammer.api.PunishmentType;
import eu.pb4.banhammer.impl.BHPlayerData;
import eu.pb4.banhammer.impl.BHUtils;
import eu.pb4.banhammer.impl.BanHammerImpl;
import eu.pb4.banhammer.impl.commands.GeneralCommands;
import eu.pb4.banhammer.impl.config.Config;
import eu.pb4.banhammer.impl.config.ConfigManager;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class PunishCommands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register(PunishCommands.create("kick", PunishmentType.KICK, false));
            dispatcher.register(PunishCommands.create("mute", PunishmentType.MUTE, false));
            dispatcher.register(PunishCommands.create("tempmute", PunishmentType.MUTE, true));
            dispatcher.register(PunishCommands.create("ban", PunishmentType.BAN, false));
            dispatcher.register(PunishCommands.create("tempban", PunishmentType.BAN, true));
            dispatcher.register(PunishCommands.create("ban-ip", PunishmentType.IP_BAN, false));
            dispatcher.register(PunishCommands.create("tempban-ip", PunishmentType.IP_BAN, true));
            dispatcher.register(PunishCommands.create("warn", PunishmentType.WARN, false));
            dispatcher.register(PunishCommands.create("tempwarn", PunishmentType.WARN, true));
        });
    }

    private static LiteralArgumentBuilder<class_2168> create(String command, PunishmentType type, boolean temp) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)command).requires(ConfigManager.requirePermissionOrOp("banhammer.punish." + command))).then(temp ? GeneralCommands.playerArgument("player").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"duration", (ArgumentType)StringArgumentType.word()).executes(ctx -> PunishCommands.punishCommand((CommandContext<class_2168>)ctx, true, type))).then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> PunishCommands.punishCommand((CommandContext<class_2168>)ctx, true, type)))) : ((RequiredArgumentBuilder)GeneralCommands.playerArgument("player").then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> PunishCommands.punishCommand((CommandContext<class_2168>)ctx, false, type)))).executes(ctx -> PunishCommands.punishCommand((CommandContext<class_2168>)ctx, false, type)));
    }

    private static int punishCommand(CommandContext<class_2168> ctx, boolean isTemp, PunishmentType type) {
        CompletableFuture.runAsync(() -> {
            String reason;
            boolean isSilent;
            Config config = ConfigManager.getConfig();
            String playerNameOrIp = (String)ctx.getArgument("player", String.class);
            long duration = -1L;
            if (isTemp) {
                try {
                    String durText = (String)ctx.getArgument("duration", String.class);
                    long temp = BHUtils.parseDuration(durText);
                    if (Permissions.check((class_2172)((class_2172)ctx.getSource()), (String)"banhammer.ignoreTempLimit", (int)2)) {
                        duration = temp;
                    } else {
                        long temp2 = ConfigManager.getConfig().getDurationLimit((class_2172)ctx.getSource());
                        duration = Math.min(temp2, temp);
                    }
                }
                catch (Exception e) {
                    ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid duration!"));
                    return;
                }
            }
            try {
                String temp = (String)ctx.getArgument("reason", String.class);
                if (temp.startsWith("-")) {
                    String[] parts = temp.split(" ", 2);
                    isSilent = parts[0].contains("s");
                    reason = parts.length == 2 ? parts[1] : config.defaultReason;
                } else {
                    reason = temp;
                    isSilent = false;
                }
            }
            catch (Exception e) {
                reason = config.defaultReason;
                isSilent = false;
            }
            Collection<BHPlayerData> players = BHUtils.lookupPlayerData(playerNameOrIp, ((class_2168)ctx.getSource()).method_9211());
            if (players.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Couldn't find player " + playerNameOrIp + "!")).method_27692(class_124.field_1061), false);
            } else {
                for (BHPlayerData player : players) {
                    if (BHUtils.isPunishableBy(player.gameProfile(), (class_2168)ctx.getSource())) {
                        PunishmentData punishment = PunishmentData.create(player.uuid(), player.ip(), player.displayName(), player.name(), (class_2168)ctx.getSource(), reason, duration, type);
                        BanHammerImpl.punishPlayer(punishment, config.configData.punishmentsAreSilent || isSilent);
                        if (!config.configData.punishmentsAreSilent || Permissions.check((class_2172)((class_2172)ctx.getSource()), (String)"banhammer.seesilent", (int)1)) continue;
                        ((class_2168)ctx.getSource()).method_9226(() -> punishment.getChatMessage(player.placeholderContext(((class_2168)ctx.getSource()).method_9211())), false);
                        continue;
                    }
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"You can't punish ").method_10852(player.displayName()).method_27693("!").method_27692(class_124.field_1061), false);
                }
            }
        });
        return 1;
    }
}

