/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.impl.config;

import com.mojang.authlib.GameProfile;
import eu.pb4.banhammer.impl.BHUtils;
import eu.pb4.banhammer.impl.BanHammerImpl;
import eu.pb4.banhammer.impl.config.data.ConfigData;
import eu.pb4.banhammer.impl.config.data.DiscordMessageData;
import eu.pb4.banhammer.impl.config.data.MessageConfigData;
import eu.pb4.banhammer.impl.config.database.DbConfig;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.TagLikeParser;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class Config {
    public static final ParserContext.Key<Function<String, class_2561>> PLACEHOLDER = ParserContext.Key.of((String)"ban_hammer");
    private static final NodeParser PARSER = NodeParser.builder().quickText().simplifiedTextFormat().placeholders(TagLikeParser.PLACEHOLDER_USER, PLACEHOLDER).globalPlaceholders().build();
    public final List<String> mutedCommands;
    public final MessageConfigData messageConfigData;
    public final TextNode mutedMessage;
    public final TextNode tempMutedMessage;
    public final SimpleDateFormat dateTimeFormatter;
    public final String defaultReason;
    public final String neverExpires;
    public final TextNode banChatMessage;
    public final TextNode tempBanChatMessage;
    public final TextNode ipBanChatMessage;
    public final TextNode tempIpBanChatMessage;
    public final TextNode muteChatMessage;
    public final TextNode tempMuteChatMessage;
    public final TextNode warnChatMessage;
    public final TextNode tempWarnChatMessage;
    public final TextNode banScreenMessage;
    public final TextNode tempBanScreenMessage;
    public final TextNode ipBanScreenMessage;
    public final TextNode tempIpBanScreenMessage;
    public final TextNode kickScreenMessage;
    public final TextNode kickChatMessage;
    public final ConfigData configData;
    private final Map<String, Long> tempDurationLimit = new HashMap<String, Long>();
    public final long defaultDurationLimit;
    public final TextNode pardonChatMessage;
    public final TextNode unmuteChatMessage;
    public final TextNode unbanChatMessage;
    public final TextNode ipUnbanChatMessage;
    public final DiscordMessageData discordMessages;
    public final List<URI> webhooks;
    public final TextNode unwarnChatMessage;

    public Config(ConfigData data, MessageConfigData mData, DiscordMessageData discordMessages) {
        this.discordMessages = discordMessages;
        this.mutedMessage = this.toSingleString(mData.mutedText);
        this.tempMutedMessage = this.toSingleString(mData.tempMutedText);
        this.banScreenMessage = this.toSingleString(mData.banScreen);
        this.tempBanScreenMessage = this.toSingleString(mData.tempBanScreen);
        this.ipBanScreenMessage = this.toSingleString(mData.ipBanScreen);
        this.tempIpBanScreenMessage = this.toSingleString(mData.tempIpBanScreen);
        this.kickScreenMessage = this.toSingleString(mData.kickScreen);
        this.mutedCommands = data.muteBlockedCommands;
        this.dateTimeFormatter = new SimpleDateFormat(mData.dateFormat);
        this.defaultReason = mData.defaultReason;
        this.neverExpires = mData.neverExpiresText;
        this.banChatMessage = this.toSingleString(mData.banChatMessage);
        this.tempBanChatMessage = this.toSingleString(mData.tempBanChatMessage);
        this.ipBanChatMessage = this.toSingleString(mData.ipBanChatMessage);
        this.tempIpBanChatMessage = this.toSingleString(mData.tempIpBanChatMessage);
        this.muteChatMessage = this.toSingleString(mData.muteChatMessage);
        this.tempMuteChatMessage = this.toSingleString(mData.tempMuteChatMessage);
        this.kickChatMessage = this.toSingleString(mData.kickChatMessage);
        this.unbanChatMessage = this.toSingleString(mData.unbanChatMessage);
        this.ipUnbanChatMessage = this.toSingleString(mData.ipUnbanChatMessage);
        this.unmuteChatMessage = this.toSingleString(mData.unmuteChatMessage);
        this.pardonChatMessage = this.toSingleString(mData.pardonChatMessage);
        this.warnChatMessage = this.toSingleString(mData.warnChatMessage);
        this.tempWarnChatMessage = this.toSingleString(mData.tempWarnChatMessage);
        this.unwarnChatMessage = this.toSingleString(mData.unwarnChatMessage);
        long dur = BHUtils.parseDuration(data.defaultTempPunishmentDurationLimit);
        this.defaultDurationLimit = dur == -1L ? Long.MAX_VALUE : dur;
        for (Map.Entry<String, String> x : data.permissionTempLimit.entrySet()) {
            this.tempDurationLimit.put(x.getKey(), BHUtils.parseDuration(x.getValue()));
        }
        this.messageConfigData = mData;
        this.configData = data;
        this.webhooks = new ArrayList<URI>();
        if (!this.configData.discordWebhookUrls.isEmpty()) {
            for (String url : this.configData.discordWebhookUrls) {
                if (url == null || url.isEmpty()) continue;
                try {
                    this.webhooks.add(URI.create(url));
                }
                catch (Throwable e) {
                    BanHammerImpl.LOGGER.error("Could use webhook!");
                    e.printStackTrace();
                }
            }
        }
    }

    private TextNode toSingleString(List<String> text) {
        return PARSER.parseNode(String.join((CharSequence)"\n", text));
    }

    public long getDurationLimit(class_2172 source) {
        long out = 0L;
        boolean custom = false;
        for (Map.Entry<String, Long> x : this.tempDurationLimit.entrySet()) {
            if (!Permissions.check((class_2172)source, (String)("banhammer.duration." + x.getKey())) || out >= x.getValue()) continue;
            out = x.getValue();
            custom = true;
        }
        return custom ? out : this.defaultDurationLimit;
    }

    public boolean canPunish(GameProfile profile) {
        return !this.configData.blockPunishments.contains(profile.name()) && !this.configData.blockPunishments.contains(profile.id().toString());
    }

    public DbConfig getDatabaseConfig(String type) {
        DbConfig dbConfig = new DbConfig();
        String key = "PB_BANHAMMER_" + type.toUpperCase(Locale.ROOT) + "_";
        dbConfig.address = this.envOrVal(key + "ADDRESS", this.configData.databaseAddress);
        dbConfig.database = this.envOrVal(key + "DATABASE", this.configData.databaseName);
        dbConfig.username = this.envOrVal(key + "USERNAME", this.configData.databaseUsername);
        dbConfig.password = this.envOrVal(key + "PASSWORD", this.configData.databasePassword);
        return dbConfig;
    }

    private String envOrVal(String env, String val) {
        return System.getenv().getOrDefault(env, val);
    }
}

