/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.impl.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.pb4.banhammer.impl.BanHammerImpl;
import eu.pb4.banhammer.impl.config.Config;
import eu.pb4.banhammer.impl.config.data.ConfigData;
import eu.pb4.banhammer.impl.config.data.DiscordMessageData;
import eu.pb4.banhammer.impl.config.data.MessageConfigData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Predicate;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import org.jetbrains.annotations.NotNull;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Config CONFIG;

    public static Config getConfig() {
        return CONFIG;
    }

    public static boolean loadConfig() {
        boolean success;
        Config oldConfig = CONFIG;
        CONFIG = null;
        try {
            File configDir = Paths.get("", "config", "banhammer").toFile();
            configDir.mkdirs();
            File configFile = new File(configDir, "config.json");
            File messagesFile = new File(configDir, "messages.json");
            File discordMessagesFile = new File(configDir, "discord-messages.json");
            ConfigData configData = configFile.exists() ? (ConfigData)GSON.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF-8"), ConfigData.class) : new ConfigData();
            MessageConfigData messageConfigData = messagesFile.exists() ? (MessageConfigData)GSON.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(messagesFile), "UTF-8"), MessageConfigData.class) : new MessageConfigData();
            DiscordMessageData discordConfigData = discordMessagesFile.exists() ? (DiscordMessageData)GSON.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(discordMessagesFile), "UTF-8"), DiscordMessageData.class) : new DiscordMessageData();
            configData.update();
            CONFIG = new Config(configData, messageConfigData, discordConfigData);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), "UTF-8"));
            writer.write(GSON.toJson((Object)configData));
            writer.close();
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(messagesFile), "UTF-8"));
            writer.write(GSON.toJson((Object)messageConfigData));
            writer.close();
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(discordMessagesFile), "UTF-8"));
            writer.write(GSON.toJson((Object)discordConfigData));
            writer.close();
            success = true;
        }
        catch (IOException exception) {
            success = false;
            CONFIG = oldConfig;
            BanHammerImpl.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
        }
        return success;
    }

    @NotNull
    public static Predicate<class_2168> requirePermissionOrOp(@NotNull String permission) {
        Objects.requireNonNull(permission, "permission");
        return player -> Permissions.check((class_2172)player, (String)permission, (int)ConfigManager.CONFIG.configData.defaultOpPermissionLevel);
    }
}

