/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.impl.database;

import com.google.common.net.InetAddresses;
import eu.pb4.banhammer.api.PunishmentData;
import eu.pb4.banhammer.api.PunishmentType;
import eu.pb4.banhammer.impl.config.ConfigManager;
import eu.pb4.banhammer.impl.database.DatabaseHandlerInterface;
import eu.pb4.banhammer.impl.gson.CodecSerializer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import java.util.function.Consumer;

public abstract class AbstractSQLDatabase
implements DatabaseHandlerInterface {
    protected abstract String getTableCreation();

    protected abstract String getHistoryTableCreation(String var1);

    public void createTables() throws SQLException {
        try (Connection conn = this.getConnection();
             Statement stat = conn.createStatement();){
            String create = this.getTableCreation();
            String prefix = ConfigManager.getConfig().configData.databasePrefix;
            String createHistory = this.getHistoryTableCreation(prefix);
            for (PunishmentType type : PunishmentType.values()) {
                if (type.databaseName == null) continue;
                stat.execute(String.format(create, prefix + type.databaseName));
            }
            stat.execute(createHistory);
        }
    }

    @Override
    public boolean insertPunishmentIntoHistory(PunishmentData punishment) {
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("insert into " + ConfigManager.getConfig().configData.databasePrefix + "history (bannedUUID, bannedIP, bannedName, bannedDisplay,adminUUID, adminDisplay, time, duration, reason, type) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");){
            prepStmt.setString(1, punishment.playerUUID.toString());
            prepStmt.setString(2, punishment.playerIP);
            prepStmt.setString(3, punishment.playerName);
            prepStmt.setString(4, CodecSerializer.TEXT.toJsonString(punishment.playerDisplayName));
            prepStmt.setString(5, punishment.adminUUID.toString());
            prepStmt.setString(6, CodecSerializer.TEXT.toJsonString(punishment.adminDisplayName));
            prepStmt.setLong(7, punishment.time);
            prepStmt.setLong(8, punishment.duration);
            prepStmt.setString(9, punishment.reason);
            prepStmt.setString(10, punishment.type.name);
            prepStmt.setQueryTimeout(10);
            prepStmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean insertPunishment(PunishmentData punishment) {
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("insert into " + ConfigManager.getConfig().configData.databasePrefix + punishment.type.databaseName + "(bannedUUID, bannedIP, bannedName, bannedDisplay,adminUUID, adminDisplay, time, duration, reason) values (?, ?, ?, ?, ?, ?, ?, ?, ?);");){
            prepStmt.setString(1, punishment.playerUUID.toString());
            prepStmt.setString(2, punishment.playerIP);
            prepStmt.setString(3, punishment.playerName);
            prepStmt.setString(4, CodecSerializer.TEXT.toJsonString(punishment.playerDisplayName));
            prepStmt.setString(5, punishment.adminUUID.toString());
            prepStmt.setString(6, CodecSerializer.TEXT.toJsonString(punishment.adminDisplayName));
            prepStmt.setLong(7, punishment.time);
            prepStmt.setLong(8, punishment.duration);
            prepStmt.setString(9, punishment.reason);
            prepStmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void getPunishments(String id, PunishmentType type, Consumer<PunishmentData.Synced> consumer) {
        try (Connection conn = this.getConnection();
             PreparedStatement stat = conn.prepareStatement("SELECT * FROM " + ConfigManager.getConfig().configData.databasePrefix + type.databaseName + " WHERE " + (InetAddresses.isInetAddress((String)id) ? "bannedIP" : "bannedUUID") + "='" + id + "';");
             ResultSet result = stat.executeQuery();){
            while (!result.isClosed() && result.next()) {
                consumer.accept(new PunishmentData.Synced(result.getLong("id"), UUID.fromString(result.getString("bannedUUID")), result.getString("bannedIP"), CodecSerializer.TEXT.fromJson(result.getString("bannedDisplay")), result.getString("bannedName"), UUID.fromString(result.getString("adminUUID")), CodecSerializer.TEXT.fromJson(result.getString("adminDisplay")), result.getLong("time"), result.getLong("duration"), result.getString("reason"), type));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void getPunishmentsHistory(String id, Consumer<PunishmentData> consumer) {
        try (Connection conn = this.getConnection();
             PreparedStatement stat = conn.prepareStatement("SELECT * FROM " + ConfigManager.getConfig().configData.databasePrefix + "history WHERE " + (InetAddresses.isInetAddress((String)id) ? "bannedIP" : "bannedUUID") + "='" + id + "';");
             ResultSet result = stat.executeQuery();){
            while (!result.isClosed() && result.next()) {
                consumer.accept(new PunishmentData(UUID.fromString(result.getString("bannedUUID")), result.getString("bannedIP"), CodecSerializer.TEXT.fromJson(result.getString("bannedDisplay")), result.getString("bannedName"), UUID.fromString(result.getString("adminUUID")), CodecSerializer.TEXT.fromJson(result.getString("adminDisplay")), result.getLong("time"), result.getLong("duration"), result.getString("reason"), PunishmentType.fromName(result.getString("type"))));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void getAllPunishmentsHistory(Consumer<PunishmentData> consumer) {
        try (Connection conn = this.getConnection();
             PreparedStatement stat = conn.prepareStatement("SELECT * FROM " + ConfigManager.getConfig().configData.databasePrefix + "history;");
             ResultSet result = stat.executeQuery();){
            while (!result.isClosed() && result.next()) {
                consumer.accept(new PunishmentData(UUID.fromString(result.getString("bannedUUID")), result.getString("bannedIP"), CodecSerializer.TEXT.fromJson(result.getString("bannedDisplay")), result.getString("bannedName"), UUID.fromString(result.getString("adminUUID")), CodecSerializer.TEXT.fromJson(result.getString("adminDisplay")), result.getLong("time"), result.getLong("duration"), result.getString("reason"), PunishmentType.fromName(result.getString("type"))));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void getAllPunishments(PunishmentType type, Consumer<PunishmentData.Synced> consumer) {
        try (Connection conn = this.getConnection();
             PreparedStatement stat = conn.prepareStatement("SELECT * FROM " + ConfigManager.getConfig().configData.databasePrefix + type.databaseName + ";");
             ResultSet result = stat.executeQuery();){
            while (!result.isClosed() && result.next()) {
                consumer.accept(new PunishmentData.Synced(result.getLong("id"), UUID.fromString(result.getString("bannedUUID")), result.getString("bannedIP"), CodecSerializer.TEXT.fromJson(result.getString("bannedDisplay")), result.getString("bannedName"), UUID.fromString(result.getString("adminUUID")), CodecSerializer.TEXT.fromJson(result.getString("adminDisplay")), result.getLong("time"), result.getLong("duration"), result.getString("reason"), type));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract Connection getConnection() throws SQLException;

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int removePunishment(long id, PunishmentType type) {
        try (Connection conn = this.getConnection();){
            int n;
            block14: {
                PreparedStatement stat = conn.prepareStatement("DELETE FROM " + ConfigManager.getConfig().configData.databasePrefix + type.databaseName + " WHERE id=" + id + ";");
                try {
                    n = stat.executeUpdate();
                    if (stat == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stat != null) {
                        try {
                            stat.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stat.close();
            }
            return n;
        }
        catch (Exception x) {
            x.printStackTrace();
            return 0;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int removePunishment(String id, PunishmentType type) {
        try (Connection conn = this.getConnection();){
            int n;
            block14: {
                PreparedStatement stat = conn.prepareStatement("DELETE FROM " + ConfigManager.getConfig().configData.databasePrefix + type.databaseName + " WHERE " + (InetAddresses.isInetAddress((String)id) ? "bannedIP" : "bannedUUID") + "='" + id + "';");
                try {
                    n = stat.executeUpdate();
                    if (stat == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stat != null) {
                        try {
                            stat.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stat.close();
            }
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

