/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.banhammer.impl.database;

import eu.pb4.banhammer.impl.database.AbstractSQLDatabase;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SQLiteDatabase
extends AbstractSQLDatabase {
    private final Connection conn;
    private final Lock lock = new ReentrantLock();

    public SQLiteDatabase(String database) throws Exception {
        Class.forName("org.sqlite.JDBC");
        this.conn = DriverManager.getConnection("jdbc:sqlite:" + database);
        this.createTables();
    }

    @Override
    protected String getTableCreation() {
        return "CREATE TABLE IF NOT EXISTS %s (id INTEGER PRIMARY KEY AUTOINCREMENT, bannedUUID varchar(36), bannedIP varchar(40), bannedName varchar(64), bannedDisplay TEXT, adminUUID varchar(36), adminDisplay TEXT, time BIGINT, duration BIGINT, reason TEXT)";
    }

    @Override
    protected String getHistoryTableCreation(String prefix) {
        return "CREATE TABLE IF NOT EXISTS " + prefix + "history (id INTEGER PRIMARY KEY AUTOINCREMENT, bannedUUID varchar(36), bannedIP varchar(40), bannedName varchar(64), bannedDisplay TEXT, adminUUID varchar(36), adminDisplay TEXT, time BIGINT, duration BIGINT, reason TEXT, type varchar(16))";
    }

    @Override
    protected Connection getConnection() {
        try {
            this.lock.tryLock(60L, TimeUnit.SECONDS);
            return new WrappedConnection(this.conn, this.lock);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void closeConnection() {
        boolean x = false;
        try {
            this.lock.tryLock(60L, TimeUnit.SECONDS);
            x = true;
            this.conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (x) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public String name() {
        return "SQLite";
    }

    private record WrappedConnection(Connection connection, Lock lock) implements Connection
    {
        @Override
        public Statement createStatement() throws SQLException {
            return this.connection.createStatement();
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.connection.prepareStatement(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.connection.prepareCall(sql);
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.connection.nativeSQL(sql);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.connection.setAutoCommit(autoCommit);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.connection.getAutoCommit();
        }

        @Override
        public void commit() throws SQLException {
            this.connection.commit();
        }

        @Override
        public void rollback() throws SQLException {
            this.connection.rollback();
        }

        @Override
        public void close() throws SQLException {
            this.lock.unlock();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.connection.isClosed();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.connection.getMetaData();
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.connection.isReadOnly();
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.connection.setCatalog(catalog);
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.connection.getCatalog();
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.connection.setTransactionIsolation(level);
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.connection.getTransactionIsolation();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.connection.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.connection.clearWarnings();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.connection.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.connection.getTypeMap();
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.connection.setTypeMap(map);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.connection.setHoldability(holdability);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.connection.getHoldability();
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.connection.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.connection.setSavepoint(name);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.connection.rollback(savepoint);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.connection.releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this.connection.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this.connection.prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this.connection.prepareStatement(sql, columnNames);
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.connection.createClob();
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.connection.createBlob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.connection.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.connection.createSQLXML();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.connection.isValid(timeout);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.connection.setClientInfo(name, value);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.connection.setClientInfo(properties);
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.connection.getClientInfo(name);
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.connection.getClientInfo();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.connection.createArrayOf(typeName, elements);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.connection.createStruct(typeName, attributes);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.connection.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            return this.connection.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            this.connection.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.connection.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.connection.getNetworkTimeout();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return iface.isInstance(this.connection) ? (T)iface.cast(this.connection) : null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return iface.isAssignableFrom(this.connection.getClass());
        }
    }
}

